/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions;

import com.adobe.flash.compiler.definitions.IGetterDefinition;
import com.adobe.flash.compiler.definitions.ISetterDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTag;
import com.adobe.flash.compiler.internal.definitions.AccessorDefinition;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.definitions.SetterDefinition;
import com.adobe.flash.compiler.projects.ICompilerProject;

public class GetterDefinition
extends AccessorDefinition
implements IGetterDefinition {
    public GetterDefinition(String name) {
        super(name);
    }

    @Override
    public ISetterDefinition resolveSetter(ICompilerProject project) {
        return (ISetterDefinition)((Object)this.resolveCorrespondingAccessor(project));
    }

    @Override
    public boolean isSkinPart() {
        return this.getSkinPart() != null;
    }

    @Override
    public boolean isRequiredSkinPart() {
        IMetaTag skinPart = this.getSkinPart();
        if (skinPart == null) {
            return false;
        }
        return this.isRequiredSkinPart(skinPart);
    }

    @Override
    public void buildInnerString(StringBuilder sb) {
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        sb.append("function");
        sb.append(' ');
        if (this.isStatic()) {
            sb.append("static");
            sb.append(' ');
        }
        sb.append("get");
        sb.append(' ');
        sb.append(this.getBaseName());
        sb.append('(');
        sb.append(')');
        String type = this.getTypeAsDisplayString();
        if (!type.isEmpty()) {
            sb.append(':');
            sb.append(type);
        }
    }

    @Override
    public FunctionDefinition resolveOverriddenFunction(ICompilerProject project) {
        FunctionDefinition override = super.resolveOverriddenFunction(project);
        if (override instanceof SetterDefinition) {
            override = ((SetterDefinition)override).resolveCorrespondingAccessor(project);
        }
        return override;
    }
}

