/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions;

import com.adobe.flash.compiler.definitions.IAccessorDefinition;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IFunctionDefinition;
import com.adobe.flash.compiler.definitions.IGetterDefinition;
import com.adobe.flash.compiler.definitions.IInterfaceDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.IPackageDefinition;
import com.adobe.flash.compiler.definitions.IScopedDefinition;
import com.adobe.flash.compiler.definitions.ISetterDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.scopes.IDefinitionSet;
import com.adobe.flash.compiler.tree.as.IVariableNode;
import java.util.Iterator;

public abstract class AccessorDefinition
extends FunctionDefinition
implements IAccessorDefinition {
    public AccessorDefinition(String name) {
        super(name);
    }

    @Override
    public AccessorDefinition resolveCorrespondingAccessor(ICompilerProject project) {
        IDefinition parent = this.getParent();
        if (parent instanceof IClassDefinition) {
            IClassDefinition.IClassIterator iter = ((IClassDefinition)parent).classIterator(project, true);
            while (iter.hasNext()) {
                IClassDefinition cls = (IClassDefinition)iter.next();
                AccessorDefinition correspondingAccessor = this.findCorrespondingAccessor(cls, project);
                if (correspondingAccessor == null) continue;
                return correspondingAccessor;
            }
        } else if (parent instanceof IInterfaceDefinition) {
            Iterator<IInterfaceDefinition> iter = ((IInterfaceDefinition)parent).interfaceIterator(project, true);
            while (iter.hasNext()) {
                IInterfaceDefinition intf = iter.next();
                AccessorDefinition correspondingAccessor = this.findCorrespondingAccessor(intf, project);
                if (correspondingAccessor == null) continue;
                return correspondingAccessor;
            }
        } else {
            if (parent instanceof IPackageDefinition) {
                IPackageDefinition pd = (IPackageDefinition)parent;
                return this.findCorrespondingAccessor(pd, project);
            }
            if (parent == null) {
                ASScope scope = this.getContainingASScope();
                return this.findCorrespondingAccessor(scope, project);
            }
            assert (false);
        }
        return null;
    }

    private AccessorDefinition findCorrespondingAccessor(IScopedDefinition type, ICompilerProject project) {
        ASScope scope = (ASScope)type.getContainedScope();
        return this.findCorrespondingAccessor(scope, project);
    }

    private AccessorDefinition findCorrespondingAccessor(ASScope scope, ICompilerProject project) {
        String name = this.getBaseName();
        INamespaceReference namespaceReference = this.getNamespaceReference();
        boolean isStatic = this.isStatic();
        INamespaceDefinition thisNamespaceDef = namespaceReference.resolveNamespaceReference(project);
        if (thisNamespaceDef == null) {
            return null;
        }
        IDefinitionSet definitionSet = scope.getLocalDefinitionSetByName(name);
        if (definitionSet == null) {
            return null;
        }
        int n = definitionSet.getSize();
        for (int i = 0; i < n; ++i) {
            INamespaceReference testDefRef;
            INamespaceDefinition testNamespaceDef;
            IAccessorDefinition definition;
            IDefinition d = definitionSet.getDefinition(i);
            if (!(d instanceof IAccessorDefinition) || (definition = (IAccessorDefinition)d).isStatic() != isStatic || (!(this instanceof IGetterDefinition) || !(definition instanceof ISetterDefinition)) && (!(this instanceof ISetterDefinition) || !(definition instanceof IGetterDefinition)) || !thisNamespaceDef.equals(testNamespaceDef = (testDefRef = definition.getNamespaceReference()).resolveNamespaceReference(project))) continue;
            return (AccessorDefinition)definition;
        }
        return null;
    }

    @Override
    public IVariableDefinition.VariableClassification getVariableClassification() {
        IDefinition parent = this.getParent();
        if (parent instanceof IFunctionDefinition) {
            return IVariableDefinition.VariableClassification.LOCAL;
        }
        if (parent instanceof IClassDefinition) {
            return IVariableDefinition.VariableClassification.CLASS_MEMBER;
        }
        if (parent instanceof IInterfaceDefinition) {
            return IVariableDefinition.VariableClassification.INTERFACE_MEMBER;
        }
        if (parent instanceof IPackageDefinition) {
            return IVariableDefinition.VariableClassification.PACKAGE_MEMBER;
        }
        if (parent == null) {
            if (this.inPackageNamespace()) {
                return IVariableDefinition.VariableClassification.PACKAGE_MEMBER;
            }
            return IVariableDefinition.VariableClassification.FILE_MEMBER;
        }
        assert (false);
        return null;
    }

    @Override
    public IVariableNode getVariableNode() {
        return (IVariableNode)super.getNode();
    }

    @Override
    public Object resolveInitialValue(ICompilerProject project) {
        return null;
    }

    @Override
    public boolean inlineFunction() {
        return this.canFunctionBeInlined();
    }
}

