/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.css.semantics;

import com.adobe.flash.compiler.css.ICSSDocument;
import com.adobe.flash.utils.FilenameNormalization;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActivatedStyleSheets {
    private final List<ICSSDocument> defaults = new ArrayList<ICSSDocument>();
    private final List<ICSSDocument> themes = new ArrayList<ICSSDocument>();
    private final Map<ICSSDocument, String> libraries = new HashMap<ICSSDocument, String>();
    private final Comparator<ICSSDocument> comparator = new Comparator<ICSSDocument>(){

        @Override
        public int compare(ICSSDocument o1, ICSSDocument o2) {
            String swcFile1 = (String)ActivatedStyleSheets.this.libraries.get(o1);
            String swcFile2 = (String)ActivatedStyleSheets.this.libraries.get(o2);
            return swcFile1.compareTo(swcFile2);
        }
    };

    public void addDefaultCSS(ICSSDocument css) {
        assert (css != null) : "defaults css can't be null";
        this.defaults.add(css);
    }

    public void addThemeCSS(ICSSDocument css) {
        assert (css != null) : "theme css can't be null";
        this.themes.add(css);
    }

    public void addLibraryCSS(ICSSDocument css, String path) {
        assert (css != null) : "librarycss can't be null";
        this.libraries.put(css, FilenameNormalization.normalize(path));
    }

    public List<ICSSDocument> sort() {
        ArrayList<ICSSDocument> librariesSorted = new ArrayList<ICSSDocument>(this.libraries.keySet());
        Collections.sort(librariesSorted, this.comparator);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(this.defaults);
        builder.addAll(librariesSorted);
        builder.addAll(this.themes);
        return builder.build();
    }

    public Set<ICSSDocument> all() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.addAll(this.defaults);
        builder.addAll(this.libraries.keySet());
        builder.addAll(this.themes);
        return builder.build();
    }
}

