/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.css.codegen;

import com.adobe.flash.abc.visitors.IABCVisitor;
import com.adobe.flash.compiler.css.ICSSDocument;
import com.adobe.flash.compiler.css.ICSSProperty;
import com.adobe.flash.compiler.css.ICSSRule;
import com.adobe.flash.compiler.css.ICSSSelector;
import com.adobe.flash.compiler.internal.css.CSSDocument;
import com.adobe.flash.compiler.internal.css.CSSFontFace;
import com.adobe.flash.compiler.internal.css.CSSFunctionCallPropertyValue;
import com.adobe.flash.compiler.internal.css.CSSMediaQueryCondition;
import com.adobe.flash.compiler.internal.css.CSSNamespaceDefinition;
import com.adobe.flash.compiler.internal.css.CSSProperty;
import com.adobe.flash.compiler.internal.css.CSSRule;
import com.adobe.flash.compiler.internal.css.CSSSelector;
import com.adobe.flash.compiler.internal.css.codegen.CSSEmitter;
import com.adobe.flash.compiler.internal.css.codegen.CSSReducer;
import com.adobe.flash.compiler.internal.css.codegen.ICSSCodeGenResult;
import com.adobe.flash.compiler.internal.css.semantics.CSSSemanticAnalyzer;
import com.adobe.flash.compiler.internal.units.EmbedCompilationUnit;
import com.adobe.flash.compiler.projects.IFlexProject;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;

public class CSSCompilationSession {
    private static final CommonTree NO_TREE = null;
    private static final TokenStream NO_TOKEN_STREAM = null;
    private static final ImmutableList<CSSMediaQueryCondition> NO_MEDIA_QUERIES = ImmutableList.of();
    public final Map<CSSFunctionCallPropertyValue, EmbedCompilationUnit> resolvedEmbedProperties;
    public final Map<ICSSSelector, String> resolvedSelectors = new LinkedHashMap<ICSSSelector, String>();
    public final Set<String> inheritingStyles = new LinkedHashSet<String>();
    public final Set<ICSSRule> activatedRules;
    public final List<ICSSDocument> cssDocuments;
    private final Map<String, SingleSelectorRule> singleSelectorRules;
    private final Set<ICSSRule> rulesWithMediaQueries;
    private boolean cssDisabled = false;
    private boolean keepAllTypeSelectors = false;
    private static Function<ICSSProperty, CSSProperty> INTERF_TO_IMPL = new Function<ICSSProperty, CSSProperty>(){

        public CSSProperty apply(ICSSProperty property) {
            return (CSSProperty)property;
        }
    };

    public CSSCompilationSession() {
        this.resolvedEmbedProperties = new HashMap<CSSFunctionCallPropertyValue, EmbedCompilationUnit>();
        this.activatedRules = new HashSet<ICSSRule>();
        this.cssDocuments = new ArrayList<ICSSDocument>();
        this.singleSelectorRules = new LinkedHashMap<String, SingleSelectorRule>();
        this.rulesWithMediaQueries = new LinkedHashSet<ICSSRule>();
    }

    protected ICSSDocument synthesisNormalizedCSS() {
        assert (this.singleSelectorRules.isEmpty() && this.rulesWithMediaQueries.isEmpty()) : "CSSCompilationSession.synthesisNormalizedCSS() can only be called once per compilation session.";
        for (ICSSDocument cssDocument : this.cssDocuments) {
            for (ICSSRule newRule : cssDocument.getRules()) {
                if (!this.keepAllTypeSelectors && !this.activatedRules.contains(newRule)) continue;
                this.addRuleToCodeGeneration(newRule);
            }
        }
        ArrayList<CSSRule> rules = new ArrayList<CSSRule>();
        for (SingleSelectorRule ssRule : this.singleSelectorRules.values()) {
            rules.add(ssRule.createCSSRule());
        }
        for (ICSSRule rule : this.rulesWithMediaQueries) {
            rules.add((CSSRule)rule);
        }
        return new SynthesizedCSSDocument(rules);
    }

    private void addRuleToCodeGeneration(ICSSRule newRule) {
        if (newRule.getMediaQueryConditions().isEmpty()) {
            ImmutableList properties = ImmutableList.copyOf((Collection)Collections2.transform(newRule.getProperties(), INTERF_TO_IMPL));
            for (ICSSSelector newSelector : newRule.getSelectorGroup()) {
                String selectorName = this.getResolvedSelectorName(newSelector);
                assert (selectorName != null) : "All selectors in the rule must be resolved before the rule can be activated.";
                SingleSelectorRule activatedRuleWithSameSelector = this.singleSelectorRules.get(selectorName);
                if (activatedRuleWithSameSelector == null) {
                    SingleSelectorRule newSingleSelectorRule = new SingleSelectorRule((CSSSelector)newSelector, (List)properties);
                    this.singleSelectorRules.put(selectorName, newSingleSelectorRule);
                    continue;
                }
                for (CSSProperty newProperty : properties) {
                    String propertyName = newProperty.getName();
                    activatedRuleWithSameSelector.propertyMap.put(propertyName, newProperty);
                }
            }
        } else {
            this.rulesWithMediaQueries.add(newRule);
        }
    }

    public ICSSCodeGenResult emitStyleDataClass(IFlexProject project, IABCVisitor abcVisitor) throws Exception {
        ICSSDocument css = this.synthesisNormalizedCSS();
        CSSReducer reducer = new CSSReducer(project, css, abcVisitor, this, true);
        CSSEmitter emitter = new CSSEmitter(reducer);
        emitter.burm(css);
        return reducer;
    }

    private String getResolvedSelectorName(ICSSSelector selector) {
        String selectorQname;
        if (CSSSemanticAnalyzer.isWildcardSelector(selector)) {
            selectorQname = "";
        } else {
            String qname = this.resolvedSelectors.get(selector);
            assert (qname != null) : "Expected resolved class definition for an activated selector. Possible bug in CSS dependency loop. Selector=" + selector;
            selectorQname = qname;
        }
        String resolvedSelectorName = selectorQname.concat(Joiner.on((String)"").join(selector.getConditions()));
        return resolvedSelectorName;
    }

    public void disable() {
        this.cssDisabled = true;
    }

    public boolean isDisabled() {
        return this.cssDisabled;
    }

    public boolean isKeepAllTypeSelectors() {
        return this.keepAllTypeSelectors;
    }

    public void setKeepAllTypeSelectors(boolean keepAllTypeSelectors) {
        this.keepAllTypeSelectors = keepAllTypeSelectors;
    }

    private static class SynthesizedCSSDocument
    extends CSSDocument {
        private static final List<CSSNamespaceDefinition> NO_NAMESPACES = ImmutableList.of();
        private static final List<CSSFontFace> FONT_FACES = ImmutableList.of();

        private SynthesizedCSSDocument(List<CSSRule> rules) {
            super(rules, NO_NAMESPACES, FONT_FACES, NO_TREE, NO_TOKEN_STREAM);
        }
    }

    private static class SingleSelectorRule {
        private final CSSSelector selector;
        private final Map<String, CSSProperty> propertyMap = new HashMap<String, CSSProperty>();

        private SingleSelectorRule(CSSSelector selector, List<CSSProperty> properties) {
            for (CSSProperty property : properties) {
                this.propertyMap.put(property.getName(), property);
            }
            this.selector = selector;
        }

        private CSSRule createCSSRule() {
            CSSRule cssRule = new CSSRule((List<CSSMediaQueryCondition>)NO_MEDIA_QUERIES, (List<CSSSelector>)ImmutableList.of((Object)this.selector), (List<CSSProperty>)ImmutableList.copyOf(this.propertyMap.values()), NO_TREE, NO_TOKEN_STREAM);
            return cssRule;
        }
    }
}

