/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.css;

import com.adobe.flash.compiler.internal.css.CSSModelTreeType;
import com.adobe.flash.compiler.internal.css.CSSPropertyValue;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;

public class CSSStringPropertyValue
extends CSSPropertyValue {
    private final String value;

    protected CSSStringPropertyValue(String stringWithQuotes, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY_VALUE);
        assert (CSSStringPropertyValue.isQuoted(stringWithQuotes)) : "Don't strip quotes in parser: [" + stringWithQuotes + "]";
        this.value = CSSStringPropertyValue.stripQuotes(stringWithQuotes);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.format("\"%s\"", this.value);
    }

    public static boolean isQuoted(String testString) {
        return testString.startsWith("\"") && testString.endsWith("\"") || testString.startsWith("'") && testString.endsWith("'");
    }

    public static String stripQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }
}

