/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.css;

import com.adobe.flash.compiler.css.ICSSProperty;
import com.adobe.flash.compiler.css.ICSSPropertyValue;
import com.adobe.flash.compiler.internal.css.CSSModelTreeType;
import com.adobe.flash.compiler.internal.css.CSSNodeBase;
import com.adobe.flash.compiler.internal.css.CSSPropertyValue;
import com.google.common.base.Strings;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;

public class CSSProperty
extends CSSNodeBase
implements ICSSProperty {
    private final String normalizedName;
    private final String rawName;
    private final CSSPropertyValue value;

    protected CSSProperty(String name, CSSPropertyValue value, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY);
        assert (!Strings.isNullOrEmpty((String)name)) : "CSS property name can't be empty.";
        assert (value != null) : "CSS property name can't be null.";
        this.rawName = name;
        this.normalizedName = CSSProperty.normalize(name);
        this.value = value;
    }

    @Override
    public String getName() {
        return this.normalizedName;
    }

    @Override
    public ICSSPropertyValue getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.format("%s : %s ;", this.rawName, this.value.toString());
    }

    protected static String normalize(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean lastCharIsHyphen = false;
        boolean isFirstChar = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ('-' == c) {
                lastCharIsHyphen = true;
                continue;
            }
            if (lastCharIsHyphen) {
                result.append(Character.toUpperCase(c));
                lastCharIsHyphen = false;
                continue;
            }
            if (isFirstChar) {
                result.append(Character.toLowerCase(c));
                isFirstChar = false;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

