/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.css;

import com.adobe.flash.compiler.internal.css.CSSModelTreeType;
import com.adobe.flash.compiler.internal.css.CSSPropertyValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;

public class CSSNumberPropertyValue
extends CSSPropertyValue {
    private static final Pattern PATTERN = Pattern.compile("[\\+\\-]?((\\d+(\\.\\d+)?)|(\\.\\d+))");
    private final String raw;
    private final Number number;
    private final String unit;

    protected CSSNumberPropertyValue(String numberWithUnit, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.PROPERTY_VALUE);
        assert (numberWithUnit != null) : "Number can't be null.";
        Matcher matcher = PATTERN.matcher(numberWithUnit);
        if (matcher.find()) {
            this.number = Float.valueOf(Float.parseFloat(matcher.group()));
            this.unit = numberWithUnit.substring(matcher.end());
        } else {
            this.number = null;
            this.unit = null;
        }
        this.raw = numberWithUnit;
    }

    public Number getNumber() {
        return this.number;
    }

    public String getUnit() {
        return this.unit;
    }

    @Override
    public String toString() {
        return this.raw;
    }
}

