/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.css;

import com.adobe.flash.compiler.css.ICSSDocument;
import com.adobe.flash.compiler.css.ICSSManager;
import com.adobe.flash.compiler.css.ICSSRule;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.caches.CSSDocumentCache;
import com.adobe.flash.compiler.internal.caches.CacheStoreKeyBase;
import com.adobe.flash.compiler.internal.css.codegen.CSSCompilationSession;
import com.adobe.flash.compiler.internal.css.semantics.CSSSemanticAnalyzer;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.units.EmbedCompilationUnit;
import com.adobe.flash.compiler.problems.CSSUnresolvedClassReferenceProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class CSSManager
implements ICSSManager {
    private final FlexProject flexProject;

    static void getClassDefinitionDependencies(CSSCompilationSession session, FlexProject flexProject, ImmutableSet<ICSSRule> cssRules, Set<IClassDefinition> classReferences, Set<EmbedCompilationUnit> embedCompilationUnits, Collection<ICompilerProblem> problems) {
        for (ICSSRule matchedRule : cssRules) {
            CSSSemanticAnalyzer.resolveDependencies(session.resolvedEmbedProperties, matchedRule, flexProject, classReferences, embedCompilationUnits, problems);
        }
    }

    static ImmutableSet<ICompilationUnit> getCompilationUnitsForDefinitions(FlexProject flexProject, Set<IClassDefinition> classDefinitions, Collection<ICompilerProblem> problems) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (IClassDefinition classDefinition : classDefinitions) {
            ASProjectScope scope = flexProject.getScope();
            ICompilationUnit compilationUnit = scope.getCompilationUnitForDefinition(classDefinition);
            if (compilationUnit != null) {
                builder.add((Object)compilationUnit);
                continue;
            }
            assert (CSSManager.problemCreatedForUnresolvedClassReference(problems, classDefinition)) : "Can't find compilation unit for class '" + classDefinition.getQualifiedName() + "'. Expected a 'CSSUnresolvedClassReference'.";
        }
        return builder.build();
    }

    static boolean problemCreatedForUnresolvedClassReference(Collection<ICompilerProblem> problems, IClassDefinition classDefinition) {
        for (ICompilerProblem problem : problems) {
            if (!(problem instanceof CSSUnresolvedClassReferenceProblem)) continue;
            CSSUnresolvedClassReferenceProblem unresolved = (CSSUnresolvedClassReferenceProblem)problem;
            if (!unresolved.qname.equals(classDefinition.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public CSSManager(FlexProject flexProject) {
        assert (flexProject != null);
        this.flexProject = flexProject;
    }

    @Override
    public Collection<ICSSDocument> getCSSFromStyleModules() {
        return null;
    }

    @Override
    public Collection<ICSSDocument> getCSSFromSWCDefaultStyle() {
        ArrayList<ICSSDocument> result = new ArrayList<ICSSDocument>();
        for (ISWC swc : this.flexProject.getLibraries()) {
            ICSSDocument css = this.getDefaultCSS(swc.getSWCFile());
            if (css == null) continue;
            result.add(css);
        }
        return result;
    }

    @Override
    public ICSSDocument getDefaultCSS(File swcFile) {
        ISWCManager swcManager = this.flexProject.getWorkspace().getSWCManager();
        CSSDocumentCache cache = swcManager.getCSSDocumentCache();
        ISWC swc = swcManager.get(swcFile);
        return cache.getDefaultsCSS(swc, this.flexProject.getCompatibilityVersion());
    }

    @Override
    public Collection<ICompilationUnit> getDependentCompilationUnitsFromCSS(CSSCompilationSession session, ICSSDocument cssDocument, Collection<IDefinition> definitions, Collection<ICompilerProblem> problems) {
        assert (cssDocument != null) : "Expected CSS document to get CSS dependencies.";
        assert (definitions != null) : "Expected a set of definitions to activate CSS rules.";
        assert (problems != null) : "Expected problems collection. Do not ignore problems.";
        ImmutableSet qnames = CSSSemanticAnalyzer.buildQNameToDefinitionMap(CSSSemanticAnalyzer.getClassDefinitionSet(definitions)).keySet();
        ImmutableSet<ICSSRule> matchedRules = CSSSemanticAnalyzer.getMatchedRules(session, this.flexProject, cssDocument, (ImmutableSet<String>)qnames, problems);
        HashSet<IClassDefinition> classReferences = new HashSet<IClassDefinition>();
        HashSet<EmbedCompilationUnit> embedCompilationUnits = new HashSet<EmbedCompilationUnit>();
        CSSManager.getClassDefinitionDependencies(session, this.flexProject, matchedRules, classReferences, embedCompilationUnits, problems);
        ImmutableSet<ICompilationUnit> classReferenceCompilationUnits = CSSManager.getCompilationUnitsForDefinitions(this.flexProject, classReferences, problems);
        for (ICSSRule rule : matchedRules) {
            session.activatedRules.add(rule);
        }
        return new ImmutableSet.Builder().addAll(classReferenceCompilationUnits).addAll(embedCompilationUnits).build();
    }

    @Override
    public Collection<ICSSDocument> getCSSFromThemes(Collection<ICompilerProblem> problems) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        ISWCManager swcManager = this.flexProject.getWorkspace().getSWCManager();
        CSSDocumentCache cssCache = swcManager.getCSSDocumentCache();
        for (IFileSpecification themeFile : this.flexProject.getThemeFiles()) {
            try {
                ICSSDocument css;
                String extension = FilenameUtils.getExtension((String)themeFile.getPath());
                if ("swc".equalsIgnoreCase(extension)) {
                    ISWC swc = swcManager.get(new File(themeFile.getPath()));
                    css = cssCache.getDefaultsCSS(swc, this.flexProject.getCompatibilityVersion());
                } else {
                    if (!"css".equalsIgnoreCase(extension)) continue;
                    CacheStoreKeyBase key = CSSDocumentCache.createKey(themeFile.getPath());
                    css = (ICSSDocument)cssCache.get(key);
                }
                if (css == null || css == CSSDocumentCache.EMPTY_CSS_DOCUMENT) continue;
                builder.add((Object)css);
            }
            catch (CSSDocumentCache.ProblemParsingCSSRuntimeException cssError) {
                problems.addAll(cssError.cssParserProblems);
            }
        }
        return builder.build();
    }

    @Override
    public boolean isFlex3CSS() {
        Integer compatibilityVersion = this.flexProject.getCompatibilityVersion();
        if (compatibilityVersion == null) {
            return false;
        }
        return compatibilityVersion <= 0x3000000;
    }

    @Override
    public ICSSDocument getCSS(String cssFilename) {
        CacheStoreKeyBase key;
        CSSDocumentCache cache = this.flexProject.getWorkspace().getSWCManager().getCSSDocumentCache();
        ICSSDocument css = (ICSSDocument)cache.get(key = CSSDocumentCache.createKey(cssFilename));
        if (CSSDocumentCache.EMPTY_CSS_DOCUMENT == css) {
            return null;
        }
        return css;
    }
}

