/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.css;

import com.adobe.flash.compiler.css.FontFaceSourceType;
import com.adobe.flash.compiler.css.ICSSFontFace;
import com.adobe.flash.compiler.css.ICSSPropertyValue;
import com.adobe.flash.compiler.internal.css.CSSFunctionCallPropertyValue;
import com.adobe.flash.compiler.internal.css.CSSModelTreeType;
import com.adobe.flash.compiler.internal.css.CSSNodeBase;
import com.adobe.flash.compiler.internal.css.CSSProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;

public class CSSFontFace
extends CSSNodeBase
implements ICSSFontFace {
    private final CSSFunctionCallPropertyValue source;
    private final String fontFamily;
    private final String fontStyle;
    private final String fontWeight;
    private final boolean isAdvancedAntiAliasing;

    protected CSSFontFace(List<CSSProperty> properties, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.FONT_FACE);
        assert (properties != null) : "Properties can't be null for @font-face.";
        ICSSPropertyValue srcValue = null;
        Object fontFamilyValue = null;
        Object fontStyleValue = null;
        Object fontWeightValue = null;
        ICSSPropertyValue advancedAAValue = null;
        for (CSSProperty property : properties) {
            String name = property.getName();
            ICSSPropertyValue value = property.getValue();
            if (name.equals("src")) {
                srcValue = value;
                continue;
            }
            if (name.equals("fontFamily")) {
                fontFamilyValue = value;
                continue;
            }
            if (name.equals("fontStyle")) {
                fontStyleValue = value;
                continue;
            }
            if (name.equals("fontWeight")) {
                fontWeightValue = value;
                continue;
            }
            if (!name.equals("advancedAntiAliasing")) continue;
            advancedAAValue = value;
        }
        Preconditions.checkNotNull(srcValue, (Object)"'src' is required in @font-face");
        this.source = (CSSFunctionCallPropertyValue)srcValue;
        Preconditions.checkNotNull(fontFamilyValue, (Object)"'fontFamily' is required in @font-face");
        this.fontFamily = fontFamilyValue.toString();
        this.fontStyle = fontStyleValue == null ? "normal" : fontStyleValue.toString();
        this.fontWeight = fontWeightValue == null ? "normal" : fontWeightValue.toString();
        this.isAdvancedAntiAliasing = advancedAAValue == null ? true : advancedAAValue.toString().equalsIgnoreCase("true");
    }

    @Override
    public FontFaceSourceType getSourceType() {
        throw new UnsupportedOperationException("need an css function call sub parser");
    }

    @Override
    public String getSourceValue() {
        throw new UnsupportedOperationException("need an css function call sub parser");
    }

    @Override
    public String getFontFamily() {
        return this.fontFamily;
    }

    @Override
    public String getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public String getFontWeight() {
        return this.fontWeight;
    }

    @Override
    public boolean getAdvancedAntiAliasing() {
        return this.isAdvancedAntiAliasing;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("@font-face {\n");
        result.append("    src : ").append(this.source).append(";\n");
        result.append("    fontFamily : ").append(this.fontFamily).append(";\n");
        result.append("    advancedAntiAliasing : ").append(this.isAdvancedAntiAliasing).append(";\n");
        result.append("    fontStyle : ").append(this.fontStyle).append(";\n");
        result.append("    fontWeight : ").append(this.fontWeight).append(";\n");
        result.append("}\n");
        return result.toString();
    }
}

