/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.css;

import com.adobe.flash.compiler.css.ICSSDocument;
import com.adobe.flash.compiler.css.ICSSFontFace;
import com.adobe.flash.compiler.css.ICSSNamespaceDefinition;
import com.adobe.flash.compiler.css.ICSSRule;
import com.adobe.flash.compiler.internal.css.CSSFontFace;
import com.adobe.flash.compiler.internal.css.CSSLexer;
import com.adobe.flash.compiler.internal.css.CSSModelTreeType;
import com.adobe.flash.compiler.internal.css.CSSNamespaceDefinition;
import com.adobe.flash.compiler.internal.css.CSSNodeBase;
import com.adobe.flash.compiler.internal.css.CSSParser;
import com.adobe.flash.compiler.internal.css.CSSRule;
import com.adobe.flash.compiler.internal.css.CSSTree;
import com.adobe.flash.compiler.internal.css.CSSTypedNode;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.UnexpectedExceptionProblem;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;

public class CSSDocument
extends CSSNodeBase
implements ICSSDocument {
    private static final String DEFAULT_NAMESPACE_SHORT_NAME = "";
    private static final Function<CSSNamespaceDefinition, String> KEY_GENERATOR = new Function<CSSNamespaceDefinition, String>(){

        public String apply(CSSNamespaceDefinition ns) {
            String prefix = ns.getPrefix();
            if (prefix == null) {
                return CSSDocument.DEFAULT_NAMESPACE_SHORT_NAME;
            }
            return prefix;
        }
    };
    private final ImmutableList<ICSSRule> rules;
    private final ImmutableList<ICSSNamespaceDefinition> namespaces;
    private final ImmutableList<ICSSFontFace> fontFaces;
    private final ImmutableMap<String, CSSNamespaceDefinition> namespacesLookup;

    public static CSSDocument parse(CharStream input, Collection<ICompilerProblem> problems) {
        assert (input != null) : "CSS input can't be null";
        assert (problems != null) : "Problem collection can't be null";
        try {
            CSSLexer lexer = new CSSLexer(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            CSSParser parser = new CSSParser(tokens);
            CSSParser.stylesheet_return stylesheet = parser.stylesheet();
            CommonTree ast = (CommonTree)stylesheet.getTree();
            CommonTreeNodeStream nodes = new CommonTreeNodeStream(ast);
            nodes.setTokenStream(tokens);
            CSSTree treeWalker = new CSSTree(nodes);
            treeWalker.stylesheet();
            problems.addAll(lexer.problems);
            problems.addAll(parser.problems);
            problems.addAll(treeWalker.problems);
            return treeWalker.model;
        }
        catch (RecognitionException e) {
            assert (false) : "RecognitionException must be collected as ICompilerProblem.";
            problems.add(new UnexpectedExceptionProblem(e));
            return null;
        }
    }

    protected CSSDocument(List<CSSRule> rules, List<CSSNamespaceDefinition> namespaces, List<CSSFontFace> fontFaces, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.DOCUMENT);
        assert (rules != null) : "Rules can't be null.";
        assert (namespaces != null) : "Namespace definitions can't be null";
        assert (fontFaces != null) : "Font face definitions can't be null";
        this.rules = new ImmutableList.Builder().addAll(rules).build();
        this.namespaces = new ImmutableList.Builder().addAll(namespaces).build();
        this.fontFaces = new ImmutableList.Builder().addAll(fontFaces).build();
        this.namespacesLookup = Maps.uniqueIndex(namespaces, KEY_GENERATOR);
        this.children.add(new CSSTypedNode(CSSModelTreeType.NAMESPACE_LIST, this.namespaces));
        this.children.add(new CSSTypedNode(CSSModelTreeType.FONT_FACE_LIST, this.fontFaces));
        this.children.add(new CSSTypedNode(CSSModelTreeType.RULE_LIST, this.rules));
    }

    @Override
    public ImmutableList<ICSSRule> getRules() {
        return this.rules;
    }

    @Override
    public ImmutableList<ICSSNamespaceDefinition> getAtNamespaces() {
        return this.namespaces;
    }

    @Override
    public String toString() {
        return Joiner.on((String)"\n").join((Object)Joiner.on((String)"\n").join(this.namespaces), (Object)Joiner.on((String)"\n").join(this.fontFaces), new Object[]{Joiner.on((String)"\n").join(this.rules)});
    }

    @Override
    public ImmutableList<ICSSFontFace> getFontFaces() {
        return this.fontFaces;
    }

    @Override
    public ICSSNamespaceDefinition getNamespaceDefinition(String prefix) {
        return (ICSSNamespaceDefinition)this.namespacesLookup.get((Object)prefix);
    }

    @Override
    public ICSSNamespaceDefinition getDefaultNamespaceDefinition() {
        return (ICSSNamespaceDefinition)this.namespacesLookup.get((Object)DEFAULT_NAMESPACE_SHORT_NAME);
    }
}

