/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.config.localization;

import com.adobe.flash.compiler.Messages;
import com.adobe.flash.compiler.internal.config.localization.ILocalizedText;
import com.adobe.flash.compiler.internal.config.localization.ILocalizer;
import com.adobe.flash.compiler.internal.config.localization.LocalizationManager;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class ResourceBundleLocalizer
implements ILocalizer {
    @Override
    public ILocalizedText getLocalizedText(Locale locale, String id) {
        int dot;
        String prefix = id;
        while ((dot = prefix.lastIndexOf(46)) != -1) {
            prefix = prefix.substring(0, dot);
            String suffix = id.substring(dot + 1);
            try {
                String message = Messages.getString(suffix);
                if (message == null) continue;
                return new ResourceBundleText(message);
            }
            catch (MissingResourceException e) {
            }
        }
        return null;
    }

    private class ResourceBundleText
    implements ILocalizedText {
        private String text;

        public ResourceBundleText(String text) {
            this.text = text;
        }

        @Override
        public String format(Map<String, Object> parameters) {
            return LocalizationManager.replaceInlineReferences(this.text, parameters);
        }
    }
}

