/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.config;

import com.adobe.flash.compiler.config.Configuration;
import com.adobe.flash.compiler.config.Configurator;
import com.adobe.flash.compiler.config.RSLSettings;
import com.adobe.flash.compiler.internal.config.FrameInfo;
import com.adobe.flash.compiler.internal.projects.LibraryPathManager;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.utils.FilenameNormalization;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;

public class TargetSettings
implements ITargetSettings {
    private File output;
    private File defaultCSS;
    private List<File> themes;
    private Collection<File> externalLibraryPath;
    private Collection<File> includeLibraries;
    private List<RSLSettings> rslLibraryPath;
    private Set<File> includeSources;
    private Map<String, File> includeFiles;
    private final Configuration configuration;
    private Set<String> externalLinkageLibraries;

    public TargetSettings(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isAccessible() {
        return this.configuration.getCompilerAccessible();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.configuration.isDebuggingEnabled();
    }

    @Override
    public boolean isOptimized() {
        return this.configuration.getCompilerOptimize();
    }

    @Override
    public boolean useCompression() {
        return this.configuration.useCompression();
    }

    @Override
    public boolean areVerboseStacktracesEnabled() {
        return this.configuration.debug();
    }

    @Override
    public boolean keepAllTypeSelectors() {
        return this.configuration.keepAllTypeSelectors();
    }

    @Override
    public boolean useNetwork() {
        return this.configuration.getUseNetwork();
    }

    @Override
    public boolean removeUnusedRuntimeSharedLibraryPaths() {
        return this.configuration.getRemoveUnusedRsls();
    }

    @Override
    public boolean verifyDigests() {
        return this.configuration.getVerifyDigests();
    }

    @Override
    public boolean useResourceBundleMetadata() {
        return true;
    }

    @Override
    public boolean isIncludeLookupOnlyEnabled() {
        return this.configuration.getIncludeLookupOnly();
    }

    @Override
    public int getDefaultBackgroundColor() {
        return this.configuration.getDefaultBackgroundColor();
    }

    @Override
    public int getDefaultFrameRate() {
        return this.configuration.getDefaultFrameRate();
    }

    @Override
    public boolean areDefaultScriptLimitsSet() {
        return this.configuration.scriptLimitsSet();
    }

    @Override
    public int getDefaultScriptTimeLimit() {
        return this.configuration.getScriptTimeLimit();
    }

    @Override
    public int getDefaultScriptRecursionLimit() {
        return this.configuration.getScriptRecursionLimit();
    }

    @Override
    public int getDefaultWidth() {
        return this.configuration.getDefaultWidth();
    }

    @Override
    public int getDefaultHeight() {
        return this.configuration.getDefaultHeight();
    }

    @Override
    public File getOutput() {
        if (this.output == null) {
            this.output = FilenameNormalization.normalize(new File(this.configuration.getOutput()));
        }
        return this.output;
    }

    @Override
    public Collection<String> getASMetadataNames() {
        return this.configuration.getCompilerKeepAs3Metadata();
    }

    @Override
    public File getDefaultCSS() {
        if (this.defaultCSS == null) {
            this.defaultCSS = FilenameNormalization.normalize(new File(this.configuration.getCompilerDefaultsCssUrl()));
        }
        return this.defaultCSS;
    }

    @Override
    public Collection<String> getExterns() {
        return this.configuration.getExterns();
    }

    @Override
    public Collection<String> getIncludes() {
        return this.configuration.getIncludes();
    }

    @Override
    public List<FrameInfo> getFrameLabels() {
        return this.configuration.getFrameList();
    }

    @Override
    public String getSWFMetadata() {
        return this.configuration.getRawMetadata();
    }

    @Override
    public int getSWFVersion() {
        return this.configuration.getSwfVersion();
    }

    @Override
    public String getPreloaderClassName() {
        return this.configuration.getPreloader();
    }

    @Override
    public String getRootSourceFileName() {
        return this.configuration.getTargetFile();
    }

    @Override
    public String getRootClassName() {
        return this.configuration.getMainDefinition();
    }

    @Override
    public List<File> getThemes() {
        if (this.themes == null) {
            this.themes = Configurator.toFileList(this.configuration.getCompilerThemeFiles());
        }
        return this.themes;
    }

    @Override
    public Collection<File> getExternalLibraryPath() {
        if (this.externalLibraryPath == null) {
            List<File> files = Configurator.toFileList(this.configuration.getCompilerExternalLibraryPath());
            Set<File> expandedFiles = LibraryPathManager.discoverSWCFilePathsAsFiles(files.toArray(new File[files.size()]));
            this.externalLibraryPath = new ArrayList<File>(expandedFiles.size());
            for (File swcFile : expandedFiles) {
                this.externalLibraryPath.add(swcFile);
            }
        }
        return this.externalLibraryPath;
    }

    @Override
    public Collection<File> getIncludeLibraries() {
        if (this.includeLibraries == null) {
            this.includeLibraries = Configurator.toFileList(this.configuration.getCompilerIncludeLibraries());
        }
        return this.includeLibraries;
    }

    @Override
    public List<String> getRuntimeSharedLibraries() {
        return this.configuration.getRuntimeSharedLibraries();
    }

    @Override
    public List<RSLSettings> getRuntimeSharedLibraryPath() {
        if (this.rslLibraryPath == null) {
            this.rslLibraryPath = Configurator.getRSLSettingsFromConfiguration(this.configuration);
        }
        return this.rslLibraryPath;
    }

    @Override
    public Collection<String> getIncludeClasses() {
        return this.configuration.getIncludeClasses();
    }

    @Override
    public Collection<File> getIncludeSources() {
        if (this.includeSources == null) {
            this.includeSources = new HashSet<File>();
            List<File> files = Configurator.toFileList(this.configuration.getIncludeSources());
            for (File file : files) {
                if (file.isFile()) {
                    this.includeSources.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                for (File fileInFolder : FileUtils.listFiles((File)file, (String[])new String[]{"as", "mxml"}, (boolean)true)) {
                    this.includeSources.add(fileInFolder);
                }
            }
        }
        return this.includeSources;
    }

    @Override
    public Map<String, File> getIncludeFiles() {
        if (this.includeFiles == null) {
            this.includeFiles = new TreeMap<String, File>();
            for (Map.Entry<String, String> fileEntry : this.configuration.getIncludeFiles().entrySet()) {
                this.includeFiles.put(fileEntry.getKey(), FilenameNormalization.normalize(new File(fileEntry.getValue())));
            }
        }
        return this.includeFiles;
    }

    @Override
    public Collection<String> getIncludeNamespaces() {
        return this.configuration.getIncludeNamespaces();
    }

    @Override
    public Collection<String> getIncludeResourceBundles() {
        return this.configuration.getIncludeResourceBundles();
    }

    @Override
    public Map<String, File> getIncludeStyleSheets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLinkageExternal(String path) {
        if (this.externalLinkageLibraries == null) {
            this.initExternalLinkageLibraries();
        }
        return this.externalLinkageLibraries.contains(path);
    }

    @Override
    public boolean useDirectBlit() {
        return false;
    }

    @Override
    public boolean useGPU() {
        return false;
    }

    private void initExternalLinkageLibraries() {
        this.externalLinkageLibraries = new HashSet<String>(this.getExternalLibraryPath().size() + this.getRuntimeSharedLibraryPath().size());
        for (File library : this.getExternalLibraryPath()) {
            this.externalLinkageLibraries.add(library.getAbsolutePath());
        }
        for (RSLSettings rsl : this.getRuntimeSharedLibraryPath()) {
            this.externalLinkageLibraries.add(rsl.getLibraryFile().getAbsolutePath());
        }
    }

    @Override
    public List<String> getDefaultsCSSFiles() {
        return ImmutableList.copyOf(this.configuration.getDefaultsCSSFiles());
    }

    @Override
    public File getLinkReport() {
        return this.configuration.getLinkReport();
    }

    @Override
    public File getSizeReport() {
        return this.configuration.getSizeReport();
    }

    @Override
    public String getFlexMinimumSupportedVersion() {
        return this.configuration.getCompilerMinimumSupportedVersionString();
    }

    @Override
    public boolean getRemoveDeadCode() {
        return this.configuration.getRemoveDeadCode();
    }

    @Override
    public boolean isAdvancedTelemetryEnabled() {
        return this.configuration.isAdvancedTelemetryEnabled();
    }

    @Override
    public String getAdvancedTelemetryPassword() {
        return this.configuration.getAdvancedTelemetryPassword();
    }
}

