/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.codegen.databinding;

import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IConstantDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IFunctionDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.internal.codegen.databinding.BindingDatabase;
import com.adobe.flash.compiler.internal.codegen.databinding.BindingInfo;
import com.adobe.flash.compiler.internal.codegen.databinding.FunctionWatcherInfo;
import com.adobe.flash.compiler.internal.codegen.databinding.PropertyWatcherInfo;
import com.adobe.flash.compiler.internal.codegen.databinding.StaticPropertyWatcherInfo;
import com.adobe.flash.compiler.internal.codegen.databinding.WatcherInfoBase;
import com.adobe.flash.compiler.internal.codegen.databinding.XMLWatcherInfo;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IFunctionCallNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.IMemberAccessExpressionNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class WatcherAnalyzer {
    private final BindingDatabase bindingDataBase;
    private final Collection<ICompilerProblem> problems;
    private final BindingInfo bindingInfo;
    private final ICompilerProject project;

    public WatcherAnalyzer(BindingDatabase bindingDataBase, Collection<ICompilerProblem> problems, BindingInfo bindingInfo, ICompilerProject project) {
        this.bindingDataBase = bindingDataBase;
        this.problems = problems;
        this.bindingInfo = bindingInfo;
        this.project = project;
    }

    public void analyze() {
        for (IExpressionNode expression : this.bindingInfo.getExpressionNodesForGetter()) {
            this.doAnalyze(expression, new AnalysisState());
        }
    }

    private void doAnalyze(IASNode node, AnalysisState state) {
        ASTNodeID id = node.getNodeID();
        switch (id) {
            case IdentifierID: {
                this.analyzeIdentifierNode((IIdentifierNode)node, state);
                break;
            }
            case MemberAccessExpressionID: {
                this.andalyzeMemberAccessExpression((IMemberAccessExpressionNode)node, state);
                break;
            }
            case FunctionCallID: {
                this.analyzeFunctionCallNode((IFunctionCallNode)node, state);
                break;
            }
            default: {
                this.analyzeChildren(node, state);
            }
        }
    }

    private void analyzeChildren(IASNode node, AnalysisState state) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            IASNode ch = node.getChild(i);
            this.doAnalyze(ch, state);
        }
    }

    private void analyzeFunctionCallNode(IFunctionCallNode node, AnalysisState state) {
        assert (state.functionCallNameDefintion == null);
        IExpressionNode nameNode = node.getNameNode();
        IDefinition nameDef = nameNode.resolve(this.project);
        if (nameDef != null && nameDef.isBindable()) {
            state.functionCallNameDefintion = nameDef;
        }
        this.analyzeChildren(node, state);
        state.functionCallNameDefintion = null;
    }

    private void andalyzeMemberAccessExpression(IMemberAccessExpressionNode node, AnalysisState state) {
        IASNode parent;
        boolean wasChaining = state.chaining;
        state.chaining = true;
        IExpressionNode left = node.getLeftOperandNode();
        IExpressionNode right = node.getRightOperandNode();
        IDefinition leftDef = left.resolve(this.project);
        IDefinition rightDef = right.resolve(this.project);
        if (leftDef instanceof IClassDefinition) {
            this.doAnalyze(right, state);
        } else {
            if (rightDef == null && leftDef != null) {
                boolean isProxy;
                ITypeDefinition leftType = leftDef.resolveType(this.project);
                FlexProject project = (FlexProject)this.project;
                String objectProxyClass = project.getObjectProxyClass();
                boolean bl = isProxy = leftType == null ? false : leftType.isInstanceOf(objectProxyClass, (ICompilerProject)project);
                if (isProxy) {
                    state.isObjectProxyExpression = true;
                    state.objectProxyEventNames = leftType.getBindableEventNames();
                }
            }
            this.doAnalyze(left, state);
            this.doAnalyze(right, state);
        }
        if (!wasChaining) {
            state.chaining = false;
            state.curChain = null;
        }
        if (state.isObjectProxyExpression && !((parent = node.getParent()) instanceof IMemberAccessExpressionNode)) {
            state.isObjectProxyExpression = false;
            state.objectProxyEventNames = null;
        }
    }

    private void analyzeIdentifierNode(IIdentifierNode node, AnalysisState state) {
        IDefinition def = node.resolve(this.project);
        if (def == null && !state.isObjectProxyExpression) {
            return;
        }
        if (def instanceof IConstantDefinition) {
            return;
        }
        assert (state.chaining || state.curChain == null);
        List<String> eventNames = null;
        WatcherInfoBase.WatcherType type = WatcherInfoBase.WatcherType.ERROR;
        String name = null;
        Object id = null;
        if (def == null && state.isObjectProxyExpression) {
            type = WatcherInfoBase.WatcherType.PROPERTY;
            name = node.getName();
            id = node;
            eventNames = state.objectProxyEventNames;
        } else {
            if (def instanceof IClassDefinition) {
                return;
            }
            type = WatcherAnalyzer.determineWatcherType(def);
            if (type == WatcherInfoBase.WatcherType.ERROR) {
                System.err.println("can't get watcher for " + def);
                return;
            }
            if (type == WatcherInfoBase.WatcherType.FUNCTION && def != state.functionCallNameDefintion) {
                return;
            }
            eventNames = WatcherInfoBase.getEventNamesFromDefinition(def, this.problems, node);
            name = def.getBaseName();
            id = def;
        }
        this.makeWatcherOfKnownType(id, type, state, node, eventNames, name, def);
        if (def instanceof IVariableDefinition) {
            boolean isVarXML;
            IVariableDefinition var = (IVariableDefinition)def;
            ITypeDefinition varType = var.resolveType(this.project);
            boolean bl = isVarXML = varType == null ? false : varType.isInstanceOf("XML", this.project);
            if (isVarXML) {
                String key = "XML";
                List<String> empty = Collections.emptyList();
                this.makeWatcherOfKnownType(key, WatcherInfoBase.WatcherType.XML, state, node, empty, name, null);
            }
        }
    }

    private void makeWatcherOfKnownType(Object watcherKey, WatcherInfoBase.WatcherType type, AnalysisState state, IASNode node, List<String> eventNames, String name, IDefinition optionalDefinition) {
        PropertyWatcherInfo pwi;
        assert (eventNames != null);
        assert (name != null);
        WatcherInfoBase watcherInfo = this.bindingDataBase.getOrCreateWatcher(state.curChain, type, watcherKey, this.problems, node, eventNames);
        if (type == WatcherInfoBase.WatcherType.FUNCTION) {
            FunctionWatcherInfo fwi = (FunctionWatcherInfo)watcherInfo;
            fwi.setFunctionName(name);
        } else if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY || type == WatcherInfoBase.WatcherType.PROPERTY) {
            pwi = (PropertyWatcherInfo)watcherInfo;
            pwi.setPropertyName(name);
        } else if (type == WatcherInfoBase.WatcherType.XML) {
            XMLWatcherInfo xwi = (XMLWatcherInfo)watcherInfo;
            xwi.setPropertyName(name);
        }
        if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY) {
            assert (optionalDefinition != null);
            pwi = (StaticPropertyWatcherInfo)watcherInfo;
            ((StaticPropertyWatcherInfo)pwi).init(optionalDefinition, this.project);
        }
        watcherInfo.addBinding(this.bindingInfo);
        if (state.chaining) {
            state.curChain = watcherInfo;
        }
    }

    private static WatcherInfoBase.WatcherType determineWatcherType(IDefinition definition) {
        WatcherInfoBase.WatcherType ret = WatcherInfoBase.WatcherType.ERROR;
        if (definition == null) {
            return ret;
        }
        if (definition instanceof IVariableDefinition) {
            ret = !definition.isStatic() ? WatcherInfoBase.WatcherType.PROPERTY : WatcherInfoBase.WatcherType.STATIC_PROPERTY;
        } else if (definition instanceof IFunctionDefinition) {
            ret = WatcherInfoBase.WatcherType.FUNCTION;
        } else assert (false);
        return ret;
    }

    static class AnalysisState {
        public boolean chaining = false;
        public WatcherInfoBase curChain = null;
        public IDefinition functionCallNameDefintion = null;
        public boolean isObjectProxyExpression = false;
        List<String> objectProxyEventNames = null;

        AnalysisState() {
        }
    }
}

