/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.codegen.databinding;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.MethodInfo;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.visitors.IABCVisitor;
import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.references.IResolvedQualifiersReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import com.adobe.flash.compiler.internal.codegen.databinding.BindingCodeGenUtils;
import com.adobe.flash.compiler.internal.codegen.databinding.BindingDatabase;
import com.adobe.flash.compiler.internal.codegen.databinding.BindingInfo;
import com.adobe.flash.compiler.internal.codegen.databinding.FunctionWatcherInfo;
import com.adobe.flash.compiler.internal.codegen.databinding.PropertyWatcherInfo;
import com.adobe.flash.compiler.internal.codegen.databinding.StaticPropertyWatcherInfo;
import com.adobe.flash.compiler.internal.codegen.databinding.WatcherInfoBase;
import com.adobe.flash.compiler.internal.codegen.databinding.XMLWatcherInfo;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.mxml.IMXMLTypeConstants;
import com.adobe.flash.compiler.tree.mxml.IMXMLBindingNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDataBindingNode;
import java.util.Map;
import java.util.Set;

public class MXMLBindingDirectiveHelper {
    private static final Name NAME_OBJTYPE = new Name("Object");
    private static final Name NAME_ARRAYTYPE = new Name("Array");
    private final MXMLClassDirectiveProcessor host;
    private final IABCVisitor emitter;
    private BindingDatabase bindingDataBase = new BindingDatabase();
    private MethodInfo propertyGetter = null;

    public MXMLBindingDirectiveHelper(MXMLClassDirectiveProcessor ddp, IABCVisitor emitter) {
        this.host = ddp;
        this.emitter = emitter;
    }

    public void visitNode(IMXMLDataBindingNode node) {
        this.bindingDataBase.analyze(node, this.host.getProblems(), this.host);
    }

    public void visitNode(IMXMLBindingNode node) {
        this.bindingDataBase.analyzeBindingNode(node, this.host.getProblems(), this.host);
    }

    public InstructionList getConstructorCode() {
        if (this.bindingDataBase.getBindingInfo().isEmpty()) {
            return null;
        }
        if (!this.establishSDKDependencies()) {
            return null;
        }
        this.bindingDataBase.finishAnalysis();
        InstructionList ret = new InstructionList();
        this.makeSpecialMemberVariablesForBinding();
        this.makePropertyGetterIfNeeded();
        ret.addAll(this.makeBindingsAndGetters());
        ret.addAll(this.makeAllWatchers());
        ret.addAll(BindingCodeGenUtils.fireInitialBindings());
        return ret;
    }

    private InstructionList makeBindingsAndGetters() {
        InstructionList insns = new InstructionList();
        MXMLBindingDirectiveHelper.log(insns, "makeBindingsAndGetters");
        for (BindingInfo bindingInfo : this.bindingDataBase.getBindingInfo()) {
            this.makeBindingAndGetter(insns, bindingInfo);
        }
        insns.addInstruction(86, this.bindingDataBase.getBindingInfo().size());
        insns.addInstruction(208);
        insns.addInstruction(43);
        insns.addInstruction(97, IMXMLTypeConstants.NAME_BINDINGS);
        this.linkTwoWayCounterparts(insns);
        MXMLBindingDirectiveHelper.log(insns, "leave makebindingsArray");
        return insns;
    }

    private void linkTwoWayCounterparts(InstructionList insns) {
        Map<Integer, Integer> pairs = this.bindingDataBase.getTwoWayBindingInfoPairs();
        Set<Map.Entry<Integer, Integer>> entries = pairs.entrySet();
        for (Map.Entry<Integer, Integer> pair : entries) {
            this.setTwoWayCounterpart(insns, pair.getKey(), pair.getValue());
            this.setTwoWayCounterpart(insns, pair.getValue(), pair.getKey());
        }
    }

    private void setTwoWayCounterpart(InstructionList insns, int dest, int src) {
        assert (dest >= 0);
        assert (src >= 0);
        assert (src != dest);
        insns.addInstruction(208);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_BINDINGS);
        insns.pushNumericConstant(dest);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        insns.addInstruction(208);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_BINDINGS);
        insns.pushNumericConstant(src);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        insns.addInstruction(97, IMXMLTypeConstants.NAME_TWOWAYCOUNTERPART);
    }

    private void makeBindingAndGetter(InstructionList insns, BindingInfo bindingInfo) {
        MXMLBindingDirectiveHelper.log(insns, "makeBindingAndGetter");
        InstructionList methodIsns = new InstructionList();
        if (bindingInfo.isSourceSimplePublicProperty()) {
            methodIsns.addInstruction(32);
        } else {
            BindingCodeGenUtils.generateGetter(this.emitter, methodIsns, bindingInfo.getExpressionNodesForGetter(), this.host.getInstanceScope());
        }
        if (bindingInfo.getExpressionNodeForDestination() != null) {
            BindingCodeGenUtils.generateSetter(methodIsns, bindingInfo.getExpressionNodeForDestination(), this.host.getInstanceScope());
        } else {
            methodIsns.addInstruction(32);
        }
        String destStr = bindingInfo.getDestinationString();
        String srcStr = bindingInfo.getSourceString();
        BindingCodeGenUtils.makeBinding(insns, this.host.getProject(), destStr, srcStr, methodIsns);
    }

    private boolean establishSDKDependencies() {
        FlexProject project = this.host.getProject();
        String[] depends = new String[]{project.getBindingClass(), project.getPropertyWatcherClass(), project.getStaticPropertyWatcherClass(), project.getFunctionReturnWatcherClass(), project.getXMLWatcherClass(), project.getBindingManagerClass()};
        ASScope scope = this.bindingDataBase.getScope();
        Workspace workspace = project.getWorkspace();
        for (String depend : depends) {
            IResolvedQualifiersReference ref = ReferenceFactory.packageQualifiedReference(workspace, depend);
            if (ref == null) {
                assert (false);
                return false;
            }
            IDefinition def = ref.resolve(project, scope, DependencyType.EXPRESSION, false);
            if (def != null) continue;
            assert (false);
            return false;
        }
        return true;
    }

    private InstructionList makeAllWatchers() {
        InstructionList insns = new InstructionList();
        MXMLBindingDirectiveHelper.log(insns, "makeWatchers");
        this.allocateNullWatchersArray(insns, this.bindingDataBase.getNumWatchers());
        insns.addInstruction(208);
        insns.addInstruction(42);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_BINDINGS);
        insns.addInstruction(213);
        insns.addInstruction(102, IMXMLTypeConstants.NAME_WATCHERS);
        insns.addInstruction(214);
        Set<Map.Entry<Object, WatcherInfoBase>> watcherChains = this.bindingDataBase.getWatcherChains();
        if (watcherChains != null) {
            for (Map.Entry<Object, WatcherInfoBase> ent : watcherChains) {
                this.makeWatcherChain(insns, ent.getValue());
            }
        }
        MXMLBindingDirectiveHelper.log(insns, "leave makeWatchersArray");
        return insns;
    }

    private void allocateNullWatchersArray(InstructionList insns, int numWatchers) {
        MXMLBindingDirectiveHelper.log(insns, "allocateNullWatchersArray");
        for (int i = 0; i < numWatchers; ++i) {
            insns.addInstruction(32);
        }
        insns.addInstruction(86, numWatchers);
        insns.addInstruction(208);
        insns.addInstruction(43);
        insns.addInstruction(97, IMXMLTypeConstants.NAME_WATCHERS);
    }

    private void makeWatcherChain(InstructionList insns, WatcherInfoBase watcherChain) {
        MXMLBindingDirectiveHelper.log(insns, "** makeWatcherChain " + watcherChain.getIndex());
        if (watcherChain.getChildren() == null && watcherChain.getEventNames().isEmpty()) {
            MXMLBindingDirectiveHelper.log("not making watcher for non-bindable");
            if (watcherChain.getType() != WatcherInfoBase.WatcherType.FUNCTION) {
                return;
            }
        }
        this.makeWatcherAndChildren(insns, watcherChain);
        this.watcherUpdateParent(insns, watcherChain);
        this.watcherAddChildren(insns, watcherChain);
    }

    private void watcherAddChildren(InstructionList insns, WatcherInfoBase watcher) {
        Set<Map.Entry<Object, WatcherInfoBase>> children = watcher.getChildren();
        if (children == null) {
            return;
        }
        for (Map.Entry<Object, WatcherInfoBase> child : children) {
            this.watcherAddChild(insns, watcher, child.getValue());
            this.watcherAddChildren(insns, child.getValue());
        }
    }

    private void watcherAddChild(InstructionList insns, WatcherInfoBase parent, WatcherInfoBase child) {
        MXMLBindingDirectiveHelper.log(insns, "add child. parent=" + parent.getIndex() + " child=" + child.getIndex());
        insns.addInstruction(210);
        insns.pushNumericConstant(parent.getIndex());
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        insns.addInstruction(215);
        insns.addInstruction(210);
        insns.pushNumericConstant(child.getIndex());
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        insns.addInstruction(99, 4);
        if (child.getType() == WatcherInfoBase.WatcherType.FUNCTION) {
            insns.addInstruction(98, 4);
            insns.addInstruction(211);
            insns.addInstruction(97, IMXMLTypeConstants.NAME_PARENTWATCHER);
        }
        insns.addInstruction(211);
        insns.addInstruction(98, 4);
        insns.addInstruction(79, IMXMLTypeConstants.ARG_ADDCHILD);
    }

    private void watcherUpdateParent(InstructionList insns, WatcherInfoBase watcherInfo) {
        assert (watcherInfo.getIndex() >= 0 && watcherInfo.getIndex() < this.bindingDataBase.getNumWatchers());
        insns.addInstruction(210);
        insns.pushNumericConstant(watcherInfo.getIndex());
        insns.addInstruction(102, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
        switch (watcherInfo.getType()) {
            case PROPERTY: 
            case FUNCTION: {
                insns.addInstruction(208);
                break;
            }
            case STATIC_PROPERTY: {
                StaticPropertyWatcherInfo pwinfo = (StaticPropertyWatcherInfo)watcherInfo;
                Name classMName = pwinfo.getContainingClass(this.host.getProject());
                insns.addInstruction(96, classMName);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        insns.addInstruction(79, IMXMLTypeConstants.ARG_UPDATEPARENT);
    }

    private void makeWatcherAndChildren(InstructionList insns, WatcherInfoBase watcherInfo) {
        MXMLBindingDirectiveHelper.log(insns, "makeWatchers for " + watcherInfo.getIndex());
        this.makeWatcher(insns, watcherInfo);
        Set<Map.Entry<Object, WatcherInfoBase>> children = watcherInfo.getChildren();
        if (children != null) {
            for (Map.Entry<Object, WatcherInfoBase> ent : children) {
                this.makeWatcherAndChildren(insns, ent.getValue());
            }
        }
    }

    private void makeWatcher(InstructionList insns, WatcherInfoBase watcherInfo) {
        MXMLBindingDirectiveHelper.log(insns, "makeWatcher slot " + watcherInfo.getIndex());
        insns.addInstruction(210);
        insns.pushNumericConstant(watcherInfo.getIndex());
        WatcherInfoBase.WatcherType type = watcherInfo.getType();
        if (type == WatcherInfoBase.WatcherType.FUNCTION) {
            FunctionWatcherInfo functionWatcherInfo = (FunctionWatcherInfo)watcherInfo;
            BindingCodeGenUtils.makeFunctionWatcher(insns, this.host.getProject(), this.emitter, functionWatcherInfo.getFunctionName(), functionWatcherInfo.getEventNames(), functionWatcherInfo.getBindings());
        } else if (type == WatcherInfoBase.WatcherType.STATIC_PROPERTY || type == WatcherInfoBase.WatcherType.PROPERTY) {
            PropertyWatcherInfo propertyWatcherInfo = (PropertyWatcherInfo)watcherInfo;
            boolean makeStaticWatcher = watcherInfo.getType() == WatcherInfoBase.WatcherType.STATIC_PROPERTY;
            MethodInfo propertyGetterFunction = null;
            if (watcherInfo.isRoot && !makeStaticWatcher) {
                propertyGetterFunction = this.propertyGetter;
                assert (propertyGetterFunction != null);
            } else if (!watcherInfo.isRoot || makeStaticWatcher) {
                // empty if block
            }
            BindingCodeGenUtils.makePropertyWatcher(makeStaticWatcher, insns, propertyWatcherInfo.getPropertyName(), propertyWatcherInfo.getEventNames(), propertyWatcherInfo.getBindings(), propertyGetterFunction, this.host.getProject());
        } else if (type == WatcherInfoBase.WatcherType.XML) {
            XMLWatcherInfo xmlWatcherInfo = (XMLWatcherInfo)watcherInfo;
            BindingCodeGenUtils.makeXMLWatcher(insns, xmlWatcherInfo.getPropertyName(), xmlWatcherInfo.getBindings(), this.host.getProject());
        } else assert (false);
        ++this.bindingDataBase._watchersCreated;
        insns.addInstruction(97, IMXMLTypeConstants.NAME_ARRAYINDEXPROP);
    }

    private void makeSpecialMemberVariablesForBinding() {
        this.host.addVariableTrait(IMXMLTypeConstants.NAME_BINDINGSBYDESTINATION, NAME_OBJTYPE);
        this.host.addVariableTrait(IMXMLTypeConstants.NAME_BINDINGSBEGINWITHWORD, NAME_OBJTYPE);
        this.host.addVariableTrait(IMXMLTypeConstants.NAME_WATCHERS, NAME_ARRAYTYPE);
        this.host.addVariableTrait(IMXMLTypeConstants.NAME_BINDINGS, NAME_ARRAYTYPE);
    }

    private void makePropertyGetterIfNeeded() {
        assert (this.propertyGetter == null);
        if (this.bindingDataBase.getRequiresPropertyGetter()) {
            this.propertyGetter = BindingCodeGenUtils.generatePropertyGetterFunction(this.emitter, this.host.getProject(), this.bindingDataBase.getScope());
        }
    }

    private static void log(String s) {
        BindingCodeGenUtils.log(s);
    }

    private static void log(InstructionList insns, String s) {
        BindingCodeGenUtils.log(insns, s);
    }
}

