/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.codegen.databinding;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.as.codegen.InstructionListNode;
import com.adobe.flash.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import com.adobe.flash.compiler.internal.codegen.databinding.BindingDestinationMaker;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.TypeScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.IMemberAccessExpressionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLBindingAttributeNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLBindingNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassDefinitionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassReferenceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLConcatenatedDataBindingNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDataBindingNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLExpressionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLInstanceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLModelPropertyNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLSingleDataBindingNode;
import java.util.LinkedList;
import java.util.List;

public class BindingInfo
implements Comparable<BindingInfo> {
    private final List<IExpressionNode> expressionNodesForGetter;
    private String destinationString;
    final int index;
    private boolean isSimplePublicProperty;
    private String sourceString;
    private int twoWayCounterpart = -1;
    private IExpressionNode expressionNodeForSetter;

    public BindingInfo(IMXMLDataBindingNode dbnode, int index, MXMLClassDirectiveProcessor host) {
        this.index = index;
        this.expressionNodesForGetter = new LinkedList<IExpressionNode>();
        if (dbnode instanceof IMXMLSingleDataBindingNode) {
            this.expressionNodesForGetter.add(((IMXMLSingleDataBindingNode)dbnode).getExpressionNode());
        } else if (dbnode instanceof IMXMLConcatenatedDataBindingNode) {
            for (int childIndex = 0; childIndex < dbnode.getChildCount(); ++childIndex) {
                IASNode child = dbnode.getChild(childIndex);
                if (child instanceof IMXMLSingleDataBindingNode) {
                    this.expressionNodesForGetter.add(((IMXMLSingleDataBindingNode)child).getExpressionNode());
                    continue;
                }
                if (child instanceof IExpressionNode) {
                    this.expressionNodesForGetter.add((IExpressionNode)child);
                    continue;
                }
                assert (false);
            }
        } else assert (false);
        this.expressionNodeForSetter = BindingDestinationMaker.makeDestinationFunctionInstructionList(dbnode);
        this.destinationString = BindingInfo.findDestinationString(dbnode, host);
        this.finishInit(host);
    }

    public BindingInfo(IMXMLBindingNode bindingNode, int index, MXMLClassDirectiveProcessor host, boolean reverseSourceAndDest) {
        this.index = index;
        IExpressionNode destinationNode = null;
        this.expressionNodesForGetter = new LinkedList<IExpressionNode>();
        if (!reverseSourceAndDest) {
            this.expressionNodesForGetter.add(bindingNode.getSourceAttributeNode().getExpressionNode());
            destinationNode = bindingNode.getDestinationAttributeNode().getExpressionNode();
        } else {
            this.expressionNodesForGetter.add(bindingNode.getDestinationAttributeNode().getExpressionNode());
            destinationNode = bindingNode.getSourceAttributeNode().getExpressionNode();
        }
        this.expressionNodeForSetter = destinationNode;
        this.destinationString = BindingInfo.findDestinationString(destinationNode, host);
        assert (this.expressionNodeForSetter != null);
        this.finishInit(host);
    }

    private void finishInit(MXMLClassDirectiveProcessor host) {
        ClassDefinition classDef = host.getClassDefinition();
        ASScope classScope = classDef.getContainedScope();
        this.analyzeExpression(host.getProject(), classScope);
    }

    public int getIndex() {
        assert (this.index >= 0);
        return this.index;
    }

    public int getTwoWayCounterpart() {
        return this.twoWayCounterpart;
    }

    public void setTwoWayCounterpart(int twoWayCounterparterpart) {
        this.twoWayCounterpart = twoWayCounterparterpart;
    }

    public List<IExpressionNode> getExpressionNodesForGetter() {
        return this.expressionNodesForGetter;
    }

    public IExpressionNode getExpressionNodeForDestination() {
        return this.expressionNodeForSetter;
    }

    public String getDestinationString() {
        return this.destinationString;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BindingInfo #" + this.index + " destStr:" + this.destinationString + " srcStr:" + this.sourceString + "\n");
        if (this.expressionNodeForSetter != null) {
            sb.append("    destFunc ");
            sb.append("node:\n");
            NodeBase n = (NodeBase)((Object)this.expressionNodeForSetter);
            n.buildStringRecursive(sb, 3, false);
        }
        if (!this.expressionNodesForGetter.isEmpty()) {
            sb.append("    Getter Expressions:\n");
            for (IExpressionNode e : this.expressionNodesForGetter) {
                NodeBase n = (NodeBase)((Object)e);
                n.buildStringRecursive(sb, 3, false);
            }
        }
        return sb.toString();
    }

    private static String findDestinationString(IASNode node, MXMLClassDirectiveProcessor host) {
        String destString = null;
        IASNode parent = node.getParent();
        if (parent instanceof IMXMLPropertySpecifierNode) {
            destString = BindingInfo.findDestinationStringFromPropertySpecifier((IMXMLPropertySpecifierNode)parent);
        } else if (parent instanceof IMXMLBindingAttributeNode) {
            destString = BindingInfo.findDestinationStringFromBindingAttribute(node);
        } else if (parent instanceof IMXMLExpressionNode) {
            String id = ((IMXMLExpressionNode)parent).getEffectiveID();
            assert (id != null);
            destString = id;
        } else if (!(parent instanceof IMXMLModelPropertyNode)) {
            System.err.println("findDestinationString can't parse parent: " + parent);
        }
        return destString;
    }

    private static String findDestinationStringFromBindingAttribute(IASNode node) {
        String ret = null;
        if (node instanceof IMemberAccessExpressionNode) {
            IMemberAccessExpressionNode maNode = (IMemberAccessExpressionNode)node;
            IExpressionNode left = maNode.getLeftOperandNode();
            IExpressionNode right = maNode.getRightOperandNode();
            if (left instanceof IIdentifierNode && right instanceof IIdentifierNode) {
                ret = ((IIdentifierNode)left).getName() + "." + ((IIdentifierNode)right).getName();
            }
        } else if (node instanceof IIdentifierNode) {
            ret = ((IIdentifierNode)node).getName();
        } else if (!(node instanceof InstructionListNode)) {
            // empty if block
        }
        return ret;
    }

    private static String findDestinationStringFromPropertySpecifier(IMXMLPropertySpecifierNode propertySpecifier) {
        String ret = null;
        IMXMLClassReferenceNode propertyParent = (IMXMLClassReferenceNode)propertySpecifier.getAncestorOfType(IMXMLClassReferenceNode.class);
        assert (propertyParent != null);
        if (propertyParent instanceof IMXMLInstanceNode) {
            IMXMLInstanceNode instanceNode = (IMXMLInstanceNode)propertyParent;
            String id = instanceNode.getEffectiveID();
            assert (id != null);
            assert (instanceNode.getID() == null || id.equals(instanceNode.getID()));
            ret = id + "." + propertySpecifier.getName();
        } else if (propertyParent instanceof IMXMLClassDefinitionNode) {
            ret = "this." + propertySpecifier.getName();
        } else assert (false);
        return ret;
    }

    @Override
    public int compareTo(BindingInfo o) {
        return this.index - o.index;
    }

    public boolean isSourceSimplePublicProperty() {
        return this.isSimplePublicProperty;
    }

    public String getSourceString() {
        return this.sourceString;
    }

    private void analyzeExpression(ICompilerProject project, ASScope scope) {
        assert (scope instanceof TypeScope);
        if (this.expressionNodesForGetter.size() != 1) {
            return;
        }
        IExpressionNode expressionNodeForGetter = this.expressionNodesForGetter.get(0);
        if (expressionNodeForGetter instanceof IIdentifierNode) {
            INamespaceReference ns;
            IVariableDefinition var;
            String name = ((IIdentifierNode)expressionNodeForGetter).getName();
            IReference ref = ReferenceFactory.lexicalReference(project.getWorkspace(), name);
            IDefinition def = ref.resolve(project, scope, DependencyType.EXPRESSION, false);
            if (def instanceof IVariableDefinition && !(var = (IVariableDefinition)def).isStatic() && (ns = var.getNamespaceReference()) == NamespaceDefinition.getPublicNamespaceDefinition()) {
                this.sourceString = def.getBaseName();
                this.isSimplePublicProperty = true;
            }
        }
    }
}

