/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.codegen.databinding;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.compiler.internal.as.codegen.InstructionListNode;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDataBindingNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLModelNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLModelPropertyNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLModelRootNode;
import java.util.LinkedList;

public class BindingDestinationMaker {
    public static IExpressionNode makeDestinationFunctionInstructionList(IMXMLDataBindingNode dbnode) {
        InstructionListNode ret = null;
        IASNode parent = dbnode.getParent();
        if (parent instanceof IMXMLModelPropertyNode) {
            LinkedList<IASNode> nodes = new LinkedList<IASNode>();
            IASNode tempNode = parent;
            boolean done = false;
            while (!done) {
                if (tempNode instanceof IMXMLModelNode) {
                    done = true;
                }
                if (!(tempNode instanceof IMXMLModelRootNode)) {
                    nodes.addFirst(tempNode);
                }
                if ((tempNode = tempNode.getParent()) != null) continue;
                assert (false);
                return null;
            }
            InstructionList insns = new InstructionList();
            insns.addInstruction(208);
            int nodeIndex = 0;
            for (IASNode n : nodes) {
                boolean last = nodeIndex == nodes.size() - 1;
                BindingDestinationMaker.generateOne(insns, n, last);
                ++nodeIndex;
            }
            ret = new InstructionListNode(insns);
        }
        return ret;
    }

    private static void generateOne(InstructionList insns, IASNode node, boolean lastOne) {
        if (node instanceof IMXMLModelPropertyNode) {
            BindingDestinationMaker.generateOneLevel(insns, (IMXMLModelPropertyNode)node, lastOne);
        } else if (node instanceof IMXMLModelNode) {
            BindingDestinationMaker.generateModel(insns, (IMXMLModelNode)node, lastOne);
        } else assert (false);
    }

    private static void generateOneLevel(InstructionList insns, IMXMLModelPropertyNode node, boolean lastOne) {
        if (!lastOne) {
            insns.addInstruction(102, new Name(node.getName()));
            if (node.getIndex() >= 0) {
                String nodeIndexName = Integer.toString(node.getIndex());
                insns.addInstruction(102, new Name(nodeIndexName));
            }
        } else if (node.getIndex() < 0) {
            insns.addInstruction(209);
            insns.addInstruction(97, new Name(node.getName()));
        } else {
            insns.addInstruction(102, new Name(node.getName()));
            insns.addInstruction(209);
            String nodeIndexName = Integer.toString(node.getIndex());
            insns.addInstruction(97, new Name(nodeIndexName));
        }
    }

    private static void generateModel(InstructionList insns, IMXMLModelNode model, boolean lastOne) {
        if (!lastOne) {
            String id = model.getEffectiveID();
            assert (id != null);
            insns.addInstruction(102, new Name(id));
        } else assert (false);
    }

    public static class Destination {
        public IExpressionNode destinationASTNode;
        boolean transformationRequired;

        public Destination(IExpressionNode destinationASTNode, boolean transformationRequired) {
            this.destinationASTNode = destinationASTNode;
            this.transformationRequired = transformationRequired;
        }
    }
}

