/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.codegen.databinding;

import com.adobe.flash.compiler.internal.as.codegen.MXMLClassDirectiveProcessor;
import com.adobe.flash.compiler.internal.codegen.databinding.BindingDatabase;
import com.adobe.flash.compiler.internal.codegen.databinding.BindingInfo;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.tree.as.IScopedNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLBindingNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDataBindingNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;
import java.util.Collection;

public class BindingAnalyzer {
    public static BindingInfo analyze(IMXMLDataBindingNode node, BindingDatabase bindingDataBase, Collection<ICompilerProblem> problems, int bindingIndex, MXMLClassDirectiveProcessor host) {
        BindingInfo info = new BindingInfo(node, bindingIndex, host);
        bindingDataBase.getBindingInfo().add(info);
        BindingAnalyzer.saveScope(node, bindingDataBase);
        return info;
    }

    private static void saveScope(IMXMLNode node, BindingDatabase bindingDataBase) {
        IScopedNode scopedNode = node.getContainingScope();
        IASScope iscope = scopedNode.getScope();
        ASScope scope = (ASScope)iscope;
        bindingDataBase.setScope(scope);
    }

    public static BindingInfo analyze(IMXMLBindingNode node, BindingDatabase bindingDataBase, Collection<ICompilerProblem> problems, int bindingIndex, boolean reverseSourceAndDest, MXMLClassDirectiveProcessor host) {
        BindingInfo info = new BindingInfo(node, bindingIndex, host, reverseSourceAndDest);
        bindingDataBase.getBindingInfo().add(info);
        BindingAnalyzer.saveScope(node, bindingDataBase);
        return info;
    }
}

