/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.codegen;

import com.adobe.flash.abc.ABCEmitter;
import com.adobe.flash.abc.semantics.MethodBodyInfo;
import com.adobe.flash.abc.semantics.MethodInfo;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.Nsset;
import com.adobe.flash.abc.visitors.IMethodBodyVisitor;
import com.adobe.flash.abc.visitors.IMethodVisitor;
import com.adobe.flash.abc.visitors.IScriptVisitor;
import com.adobe.flash.abc.visitors.ITraitsVisitor;
import java.util.Arrays;
import java.util.Vector;

public class IntrinsicGen {
    static void createEmptyScriptInit(ABCEmitter emitter, IScriptVisitor sv) {
        MethodInfo miInit = new MethodInfo();
        IMethodVisitor mvInit = emitter.visitMethod(miInit);
        mvInit.visit();
        MethodBodyInfo mbiInit = new MethodBodyInfo();
        mbiInit.setMethodInfo(miInit);
        IMethodBodyVisitor mbvInit = mvInit.visitBody(mbiInit);
        mbvInit.visit();
        mbvInit.visitInstruction(71);
        mbvInit.visitEnd();
        mvInit.visitBody(mbiInit);
        mvInit.visitEnd();
        sv.visitInit(miInit);
    }

    static MethodInfo createIntrinsic(ABCEmitter emitter, int opcode, Name retType, Name[] paramTypes) {
        MethodInfo mi = new MethodInfo();
        mi.setReturnType(retType);
        Vector<Name> paramTypeVec = new Vector<Name>();
        paramTypeVec.addAll(Arrays.asList(paramTypes));
        mi.setParamTypes(paramTypeVec);
        IMethodVisitor mv = emitter.visitMethod(mi);
        mv.visit();
        MethodBodyInfo mbi = new MethodBodyInfo();
        mbi.setMethodInfo(mi);
        IMethodBodyVisitor mbv = mv.visitBody(mbi);
        mbv.visit();
        if (paramTypes.length > 3) {
            throw new Error("Too many intrinsic arguments");
        }
        if (paramTypes.length > 2) {
            mbv.visitInstruction(211);
        }
        if (paramTypes.length > 1) {
            mbv.visitInstruction(210);
        }
        if (paramTypes.length > 0) {
            mbv.visitInstruction(209);
        }
        mbv.visitInstruction(opcode);
        if (retType != null && retType.equals(new Name("void"))) {
            mbv.visitInstruction(71);
        } else {
            mbv.visitInstruction(72);
        }
        mbv.visitEnd();
        mv.visitEnd();
        return mi;
    }

    static void createIntrinsics(ABCEmitter emitter, Intrinsic[] intrinsics) {
        IScriptVisitor sv = emitter.visitScript();
        sv.visit();
        ITraitsVisitor tsv = sv.visitTraits();
        tsv.visit();
        for (Intrinsic i : intrinsics) {
            MethodInfo mi = IntrinsicGen.createIntrinsic(emitter, i.opcode, i.retType, i.paramTypes);
            tsv.visitMethodTrait(1, new Name(7, i.nameQualifier, i.name), 0, mi);
        }
        tsv.visitEnd();
        IntrinsicGen.createEmptyScriptInit(emitter, sv);
        sv.visitEnd();
    }

    public static byte[] generateIntrinsicsABC() throws Exception {
        ABCEmitter emitter = new ABCEmitter();
        emitter.visit(46, 16);
        Name int_t = new Name("int");
        Name Number_t = new Name("Number");
        Name void_t = new Name("void");
        Namespace memoryNS = new Namespace(22, "avm2.intrinsics.memory");
        Nsset memoryNSS = new Nsset(memoryNS);
        Namespace iterationNS = new Namespace(22, "avm2.intrinsics.iteration");
        Nsset iterationNSS = new Nsset(iterationNS);
        IntrinsicGen.createIntrinsics(emitter, new Intrinsic[]{new Intrinsic(53, memoryNSS, "li8", int_t, new Name[]{int_t}), new Intrinsic(54, memoryNSS, "li16", int_t, new Name[]{int_t}), new Intrinsic(55, memoryNSS, "li32", int_t, new Name[]{int_t}), new Intrinsic(56, memoryNSS, "lf32", Number_t, new Name[]{int_t}), new Intrinsic(57, memoryNSS, "lf64", Number_t, new Name[]{int_t}), new Intrinsic(58, memoryNSS, "si8", void_t, new Name[]{int_t, int_t}), new Intrinsic(59, memoryNSS, "si16", void_t, new Name[]{int_t, int_t}), new Intrinsic(60, memoryNSS, "si32", void_t, new Name[]{int_t, int_t}), new Intrinsic(61, memoryNSS, "sf32", void_t, new Name[]{int_t, Number_t}), new Intrinsic(62, memoryNSS, "sf64", void_t, new Name[]{int_t, Number_t}), new Intrinsic(80, memoryNSS, "sxi1", int_t, new Name[]{int_t}), new Intrinsic(81, memoryNSS, "sxi8", int_t, new Name[]{int_t}), new Intrinsic(82, memoryNSS, "sxi16", int_t, new Name[]{int_t}), new Intrinsic(31, iterationNSS, "hasnext", int_t, new Name[]{null, int_t}), new Intrinsic(35, iterationNSS, "nextvalue", null, new Name[]{null, int_t}), new Intrinsic(30, iterationNSS, "nextname", null, new Name[]{null, int_t})});
        return emitter.emit();
    }

    static class Intrinsic {
        public final int opcode;
        public final Nsset nameQualifier;
        public final String name;
        public final Name retType;
        public final Name[] paramTypes;

        public Intrinsic(int opcode, Nsset nameQualifier, String name, Name retType, Name[] paramTypes) {
            this.opcode = opcode;
            this.nameQualifier = nameQualifier;
            this.name = name;
            this.retType = retType;
            this.paramTypes = paramTypes;
        }
    }
}

