/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.caches;

import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.caches.CacheStoreKeyBase;
import com.adobe.flash.compiler.internal.caches.ConcurrentCacheStoreBase;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLToken;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLTokenizer;
import com.adobe.flash.compiler.mxml.MXMLData;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class MXMLDataCache
extends ConcurrentCacheStoreBase<MXMLData> {
    public static MXMLDataCacheKey createKey(IFileSpecification fileSpec) {
        return new MXMLDataCacheKey(fileSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MXMLData createEntryValue(CacheStoreKeyBase key) {
        IFileSpecification fileSpec = ((MXMLDataCacheKey)key).fileSpec;
        MXMLTokenizer tokenizer = new MXMLTokenizer(fileSpec);
        try {
            MXMLData mxmlData;
            List<MXMLToken> tokens = tokenizer.parseTokens(fileSpec.createReader());
            MXMLData mXMLData = mxmlData = new MXMLData(tokens, tokenizer.getPrefixMap(), fileSpec);
            return mXMLData;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            MXMLData mXMLData = null;
            return mXMLData;
        }
        finally {
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
    }

    private static class MXMLDataCacheKey
    extends CacheStoreKeyBase {
        private IFileSpecification fileSpec;

        public MXMLDataCacheKey(IFileSpecification fileSpec) {
            assert (fileSpec != null);
            this.fileSpec = fileSpec;
        }

        @Override
        public String generateKey() {
            return String.valueOf(this.fileSpec.isOpenDocument()) + ":" + this.fileSpec.getPath();
        }
    }
}

