/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.caches;

import com.adobe.flash.compiler.internal.caches.CacheStoreKeyBase;
import com.adobe.flash.compiler.internal.caches.ConcurrentCacheStoreBase;
import com.adobe.flash.compiler.internal.caches.FileScopeCache;
import com.adobe.flash.compiler.internal.caches.SWFCache;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCScript;
import com.adobe.flash.swc.SWCManager;
import com.adobe.flash.swf.ITagContainer;
import com.adobe.flash.swf.TagType;
import com.adobe.flash.swf.tags.ICharacterReferrer;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.IImportClassName;
import com.adobe.flash.swf.tags.ITag;
import com.adobe.flash.swf.tags.SymbolClassTag;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class AssetTagCache
extends ConcurrentCacheStoreBase<AssetTagCacheValue> {
    private final SWCManager swcManager;

    public static AssetTagCacheKey createKey(ISWC swc, String swfPath, ISWCScript script, String qname) {
        AssetTagCacheKey key = new AssetTagCacheKey();
        key.swc = swc;
        key.swfPath = swfPath;
        key.scriptName = script.getName();
        key.qname = qname;
        return key;
    }

    public AssetTagCache(SWCManager swcManager) {
        this.swcManager = swcManager;
    }

    @Override
    protected AssetTagCacheValue createEntryValue(CacheStoreKeyBase key) {
        if (!(key instanceof AssetTagCacheKey)) {
            throw new IllegalArgumentException("expect AssetTagCacheKey but got " + key.getClass().getSimpleName());
        }
        AssetTagCacheKey assetTagCacheKey = (AssetTagCacheKey)key;
        ITagContainer tagContainer = (ITagContainer)this.swcManager.getSWFCache().get(SWFCache.createKey(assetTagCacheKey.swc, assetTagCacheKey.swfPath));
        SymbolClassTag symbolClassTag = AssetTagCache.getSymbolClass(tagContainer);
        if (symbolClassTag == null) {
            return new AssetTagCacheValue(null);
        }
        ICharacterTag assetTag = symbolClassTag.getSymbol(assetTagCacheKey.qname);
        AssetTagCacheValue result = new AssetTagCacheValue(assetTag);
        AssetTagCache.getAllReferredTags(assetTag, result.referredTags, result.importClassNames);
        return result;
    }

    private static SymbolClassTag getSymbolClass(ITagContainer tagContainer) {
        for (ITag tag : tagContainer) {
            if (tag.getTagType() != TagType.SymbolClass) continue;
            return (SymbolClassTag)tag;
        }
        return null;
    }

    private static void getAllReferredTags(ITag tag, Collection<ITag> referredTags, Set<String> importClassNames) {
        AssetTagCache.getImportClassNames(tag, importClassNames);
        if (tag instanceof ICharacterReferrer) {
            for (ICharacterTag referredTag : ((ICharacterReferrer)((Object)tag)).getReferences()) {
                assert (referredTag != null);
                referredTags.add(referredTag);
                AssetTagCache.getAllReferredTags(referredTag, referredTags, importClassNames);
            }
        }
    }

    private static void getImportClassNames(ITag tag, Set<String> importClassNames) {
        if (tag instanceof IImportClassName) {
            importClassNames.addAll(((IImportClassName)((Object)tag)).getClassNames());
        }
    }

    public static class AssetTagCacheValue {
        public final ICharacterTag assetTag;
        public final Collection<ITag> referredTags;
        public final Set<String> importClassNames;

        private AssetTagCacheValue(ICharacterTag assetTag) {
            this.assetTag = assetTag;
            this.referredTags = new LinkedList<ITag>();
            this.importClassNames = new HashSet<String>();
        }
    }

    protected static class AssetTagCacheKey
    extends FileScopeCache.FileScopeCacheKey {
        protected String qname;

        protected AssetTagCacheKey() {
        }

        @Override
        public String generateKey() {
            return String.format("%s:%s:%s:%s", this.swc.getSWCFile().getAbsolutePath(), this.swfPath, this.scriptName, this.qname).intern();
        }
    }
}

