/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.as.codegen;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

class UnknownTreePatternInputOutput
extends DefaultHandler2 {
    Map<String, ArrayList<Template>> destination;
    String packageName = "com.adobe.flash.compiler.internal.as.codegen";
    String className = "UnknownTreeHandlerPatterns";
    String emitterName = "com.adobe.flash.compiler.internal.as.codegen.CmcEmitter";
    Stack<Template> nodeStack = new Stack();
    PrintWriter output;

    UnknownTreePatternInputOutput() {
    }

    boolean load(String pattern_file, Map<String, ArrayList<Template>> dest) {
        this.destination = dest;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            parser.parse((InputStream)new FileInputStream(pattern_file), (DefaultHandler)this);
            return true;
        }
        catch (Throwable load_failed) {
            System.err.println("Load of " + pattern_file + " failed!");
            load_failed.printStackTrace();
            return false;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!localName.equals("Pattern")) {
            if (!localName.equals("SEW")) {
                System.err.println("Unknown element " + localName);
            }
            return;
        }
        Template template = new Template();
        for (int index = 0; index < attributes.getLength(); ++index) {
            String class_name;
            String state_id;
            String attr_name = attributes.getLocalName(index);
            String attr_value = attributes.getValue(index);
            if ("ID".equals(attr_name)) {
                template.id = attr_value;
                continue;
            }
            if ("cantHaveState".equals(attr_name)) {
                template.cantHaveState = state_id = "__" + attr_value + "_NT";
                continue;
            }
            if ("mustHaveState".equals(attr_name)) {
                template.mustHaveState = state_id = "__" + attr_value + "_NT";
                continue;
            }
            if ("problem".equals(attr_name)) {
                class_name = attr_value.startsWith("com.adobe.") ? attr_value : "com.adobe.flash.compiler.problems." + attr_value;
                template.problemClass = class_name;
                continue;
            }
            if ("nodeClass".equals(attr_name)) {
                class_name = attr_value.startsWith("com.adobe.") ? attr_value : "com.adobe.flash.compiler.internal.tree.as." + attr_value;
                template.nodeClass = class_name;
                continue;
            }
            if ("provisional".equals(attr_name)) {
                template.provisional = Boolean.valueOf(attr_value);
                continue;
            }
            System.err.println("** Unknown attr name:" + attr_name);
        }
        if (this.nodeStack.isEmpty()) {
            assert (template.problemClass != null) : "Top-level template " + template + " must have a problem class.";
            if (!this.destination.containsKey(template.id)) {
                this.destination.put(template.id, new ArrayList());
            }
            this.destination.get(template.id).add(template);
        } else {
            Template base = this.nodeStack.peek();
            if (base.requiredSubtree == null) {
                base.requiredSubtree = template;
            } else {
                System.err.println("already has subtree: " + base);
            }
        }
        this.nodeStack.push(template);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("Pattern")) {
            this.nodeStack.pop();
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 2) {
            System.err.println("Usage: java com.adobe.flash.compiler.internal.as.codegen.UnknownTreePatternInputOutput <xml pattern file> <destination java file>");
            System.exit(1);
        }
        new UnknownTreePatternInputOutput().dumpTemplateData(argv[0], argv[1]);
    }

    void dumpTemplateData(String src_file_name, String dest_file_name) throws Exception {
        if (!this.load(src_file_name, new HashMap<String, ArrayList<Template>>())) {
            return;
        }
        this.output = new PrintWriter(dest_file_name);
        this.output.println("package " + this.packageName + ";");
        this.output.println("import java.util.ArrayList;");
        this.output.println("import java.util.HashMap;");
        this.output.println("import java.util.Map;");
        this.output.println("import com.adobe.flash.compiler.tree.ASTNodeID;");
        this.output.println("import static com.adobe.flash.compiler.tree.ASTNodeID.*;");
        this.output.println("import " + this.emitterName + ";");
        this.output.println();
        this.output.println("public class " + this.className);
        this.output.println("{");
        this.output.println();
        this.output.println("    //  Patterns generated " + new Date().toString() + " from " + src_file_name);
        this.output.println("    public static Map<ASTNodeID, ArrayList<UnknownTreeFinding.Template> > allTemplates = new HashMap<ASTNodeID, ArrayList<UnknownTreeFinding.Template>>();");
        this.output.println("    static");
        this.output.println("    {");
        for (String id : this.destination.keySet()) {
            String templates_name = "templates_for_" + id;
            this.output.printf("        ArrayList<UnknownTreeFinding.Template> %s = allTemplates.get(%s);%n", templates_name, id);
            this.output.printf("        if ( %s == null ) {%n", templates_name);
            this.output.printf("            %s = new ArrayList<UnknownTreeFinding.Template>();%n", templates_name);
            this.output.printf("            allTemplates.put(%s, %s);%n", id, templates_name);
            this.output.printf("        }%n", new Object[0]);
            for (Template templ : this.destination.get(id)) {
                this.output.printf("        {%n", new Object[0]);
                this.dumpTemplate(templ, "current_template");
                this.output.printf("            %s.add(current_template);%n", templates_name);
                this.output.printf("        }%n", new Object[0]);
            }
        }
        this.output.println("    }");
        this.output.println("}");
        this.output.close();
    }

    void dumpTemplate(Template templ, String var_name) {
        this.output.printf("            UnknownTreeFinding.Template %s = new UnknownTreeFinding.Template();%n", var_name);
        this.output.printf("            %s.id = %s;%n", var_name, templ.id);
        if (templ.problemClass != null) {
            this.output.printf("            %s.problemClass = %s.class;%n", var_name, templ.problemClass);
        }
        if (templ.nodeClass != null) {
            this.output.printf("            %s.nodeClass = %s.class;%n", var_name, templ.nodeClass);
        }
        if (templ.mustHaveState != null) {
            this.output.printf("            %s.mustHaveState = CmcEmitter.%s;%n", var_name, templ.mustHaveState);
        }
        if (templ.cantHaveState != null) {
            this.output.printf("            %s.cantHaveState = CmcEmitter.%s;%n", var_name, templ.cantHaveState);
        }
        this.output.printf("            %s.provisional = %s;%n", var_name, templ.provisional);
        if (templ.requiredSubtree != null) {
            String subtemp_name = var_name + "_subtempl";
            this.dumpTemplate(templ.requiredSubtree, subtemp_name);
            this.output.printf("            %s.requiredSubtree = %s;%n", var_name, subtemp_name);
        }
    }

    private static class Template {
        String id = "UnknownID";
        String problemClass;
        String nodeClass;
        String mustHaveState;
        String cantHaveState;
        Boolean provisional = Boolean.FALSE;
        Template requiredSubtree;

        private Template() {
        }
    }
}

