/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.as.codegen;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.Instruction;
import com.adobe.flash.abc.semantics.InstructionFactory;
import com.adobe.flash.abc.semantics.Metadata;
import com.adobe.flash.abc.semantics.MethodBodyInfo;
import com.adobe.flash.abc.semantics.MethodInfo;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.Nsset;
import com.adobe.flash.abc.semantics.PooledValue;
import com.adobe.flash.abc.visitors.IABCVisitor;
import com.adobe.flash.abc.visitors.IMetadataVisitor;
import com.adobe.flash.abc.visitors.IMethodBodyVisitor;
import com.adobe.flash.abc.visitors.IMethodVisitor;
import com.adobe.flash.abc.visitors.ITraitVisitor;
import com.adobe.flash.abc.visitors.ITraitsVisitor;
import com.adobe.flash.abc.visitors.IVisitor;
import com.adobe.flash.compiler.common.IMetaInfo;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.IParameterDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTagAttribute;
import com.adobe.flash.compiler.internal.as.codegen.BindableHelper;
import com.adobe.flash.compiler.internal.as.codegen.Binding;
import com.adobe.flash.compiler.internal.as.codegen.ControlFlowContextManager;
import com.adobe.flash.compiler.internal.as.codegen.GlobalLexicalScope;
import com.adobe.flash.compiler.internal.as.codegen.ICodeGenerator;
import com.adobe.flash.compiler.internal.as.codegen.InlineFunctionLexicalScope;
import com.adobe.flash.compiler.internal.definitions.DefinitionBase;
import com.adobe.flash.compiler.internal.definitions.VariableDefinition;
import com.adobe.flash.compiler.internal.definitions.metadata.MetaTag;
import com.adobe.flash.compiler.internal.scopes.FunctionScope;
import com.adobe.flash.compiler.internal.semantics.MethodBodySemanticChecker;
import com.adobe.flash.compiler.internal.semantics.SemanticUtils;
import com.adobe.flash.compiler.internal.tree.as.BaseVariableNode;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.ILanguageIdentifierNode;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class LexicalScope {
    public static final Name anyType = null;
    public static final Object noInitializer = null;
    public static final int DEBUG_LINE_UNKNOWN = -1;
    private static final Name NAME_Array = new Name("Array");
    private static final Name NAME_arguments = new Name(new Namespace(23, ""), "arguments");
    private static final IMetaInfo[] EMPTY_META_INFO = new IMetaInfo[0];
    private final GlobalLexicalScope globalLexicalScope;
    private final Map<String, Binding> localBindings = new HashMap<String, Binding>();
    private List<Binding> inlinedBindings = null;
    private final LexicalScope enclosingFrame;
    private MethodInfo methodInfo = null;
    private boolean needsThis = true;
    private Vector<Name> paramTypes = null;
    private boolean hasRestParam = false;
    private final ArrayList<Name> allParams = new ArrayList();
    private ControlFlowContextManager flowMgr = null;
    private Binding activationStorage = null;
    private final ArrayList<Hasnext2Wrapper> hasnexts = new ArrayList();
    private IASNode initialControlFlowRegionNode;
    private int slotId = 1;
    private InstructionList hoistedInitInstructions = null;
    private IASScope localScope = null;
    private final Set<Name> declaredVariables = new HashSet<Name>();
    private String currentDebugFile = null;
    private int currentDebugLine = -1;
    private NestingState nestingState = NestingState.NotNested;
    private final List<IVisitor> deferredVisitEnds = new LinkedList<IVisitor>();
    private ArgumentsState argumentsState = ArgumentsState.INITIAL;
    private Name argumentsName = null;
    ITraitsVisitor traitsVisitor = null;
    IMethodBodyVisitor methodBodyVisitor = null;
    IMethodVisitor methodVisitor = null;
    protected MethodBodySemanticChecker methodBodySemanticChecker = null;
    private final TempManager tempManager;

    protected LexicalScope() {
        assert (this instanceof GlobalLexicalScope) : "LexicalScope() should only ever be called by GlobalLexicalScope()";
        this.globalLexicalScope = (GlobalLexicalScope)this;
        this.enclosingFrame = null;
        this.tempManager = new TempManager();
    }

    protected LexicalScope(LexicalScope enclosingFrame) {
        this(enclosingFrame, false);
    }

    protected LexicalScope(LexicalScope enclosingFrame, boolean mergableTempManager) {
        assert (!(this instanceof GlobalLexicalScope)) : "LexicalScope(LexicalScope) should never be called by GlobalLexicalScope()";
        this.enclosingFrame = enclosingFrame;
        this.globalLexicalScope = enclosingFrame.globalLexicalScope;
        this.nestingState = enclosingFrame.nestingState;
        this.tempManager = mergableTempManager ? new TempManager(enclosingFrame.tempManager) : new TempManager();
    }

    public void makeVariable(Binding var) {
        this.makeVariable(var, anyType, EMPTY_META_INFO);
    }

    public void makeVariable(Binding var, Name var_type, IMetaInfo[] meta_tags) {
        this.makeVariable(var, var_type, meta_tags, noInitializer);
    }

    public void makeVariable(Binding var, Name var_type, IMetaInfo[] meta_tags, Object initializer) {
        this.makeVariable(var, var_type, meta_tags, initializer, VariableMutability.Default);
    }

    public void makeVariable(Binding var, Name var_type, IMetaInfo[] meta_tags, Object initializer, VariableMutability mutability) {
        assert (initializer == null || SemanticUtils.isConstDefinition(var.getDefinition())) : "only consts can have an initializer";
        Name var_name = var.getName();
        if (var_name == null || this.declaredVariables.contains(var_name)) {
            return;
        }
        this.declareVariableName(var_name);
        IDefinition var_def = var.getDefinition();
        if (this.localsInRegisters()) {
            if (!this.localBindings.containsKey(var_name.getBaseName())) {
                if (var.getNode() instanceof BaseVariableNode) {
                    IExpressionNode name_node = ((BaseVariableNode)var.getNode()).getNameExpressionNode();
                    Binding var_binding = this.getBinding(name_node, var_name, var_def);
                    this.localBindings.put(var_name.getBaseName(), var_binding);
                    var_binding.setIsLocal(true);
                } else {
                    Binding error_binding = new Binding(var.getNode(), new Name("error in binding"), null);
                    this.localBindings.put(var_name.getBaseName(), error_binding);
                }
            }
        } else {
            int trait_kind = SemanticUtils.isConstDefinition(var_def) || mutability == VariableMutability.Constant ? 6 : 0;
            assert (this.traitsVisitor != null) : "No traits";
            ITraitVisitor tv = this.traitsVisitor.visitSlotTrait(trait_kind, this.ensureQName(var_name), this.getSlotId(var), var_type, initializer);
            tv.visitStart();
            this.processMetadata(tv, meta_tags);
            this.deferredVisitEnds.add(tv);
        }
    }

    private int getSlotId(Binding binding) {
        if (!this.needsActivation()) {
            return 0;
        }
        binding.setSlotId(this.slotId++);
        return binding.getSlotId();
    }

    public boolean needsHoistedInitInsns(IDefinition var_def, Name var_name, boolean has_initializer) {
        if (this.localsInRegisters()) {
            if (this.allParams.contains(var_name)) {
                return false;
            }
            if (!has_initializer) {
                return true;
            }
            if (var_def instanceof VariableDefinition && ((VariableDefinition)var_def).declaredInControlFlow()) {
                return true;
            }
            Binding b = this.localBindings.get(var_name.getBaseName());
            return b != null;
        }
        return false;
    }

    public void declareVariableName(Name n) {
        this.checkForArgumentsDecl(n);
        this.declaredVariables.add(n);
    }

    public void makeBindableVariable(Binding var, Name var_type, IMetaInfo[] metaTags) {
        Name var_name = var.getName();
        if (var_name == null || this.declaredVariables.contains(var_name)) {
            return;
        }
        this.declareVariableName(var_name);
        Name backingPropertyName = BindableHelper.getBackingPropertyName(var_name);
        assert (this.traitsVisitor != null) : "No traits";
        this.traitsVisitor.visitSlotTrait(0, this.ensureQName(backingPropertyName), this.getSlotId(var), var_type, noInitializer);
        ITraitVisitor getterTv = BindableHelper.generateBindableGetter(this, var_name, backingPropertyName, var_type);
        IDefinition bindableVarDef = var.getDefinition();
        MetaTag gotoDefinitionMetaTag = MetaTag.createGotoDefinitionHelp(bindableVarDef, bindableVarDef.getContainingFilePath(), Integer.toString(bindableVarDef.getNameStart()), false);
        metaTags = MetaTag.addMetaTag(metaTags, gotoDefinitionMetaTag);
        this.processMetadata(getterTv, metaTags);
        getterTv.visitEnd();
        ITraitVisitor setterTv = BindableHelper.generateBindableSetter(this, var_name, backingPropertyName, var_type, var.getDefinition());
        this.processMetadata(setterTv, new IMetaInfo[]{gotoDefinitionMetaTag});
        setterTv.visitEnd();
    }

    private Name ensureQName(Name n) {
        Name result = n != null ? (n.getKind() == 7 ? n : new Name(7, new Nsset(new Namespace(22)), n.getBaseName())) : null;
        return result;
    }

    public void makeNamespace(INamespaceDefinition nsDef, Binding ns_binding, Namespace ns_init) {
        Name ns_name = ns_binding.getName();
        if (this.declaredVariables.contains(ns_name)) {
            return;
        }
        this.declareVariableName(ns_name);
        assert (ns_init != null);
        assert (this.traitsVisitor != null) : "No traits";
        if (this.localsInRegisters()) {
            this.localBindings.put(ns_name.getBaseName(), ns_binding);
            ns_binding.setIsLocal(true);
        } else {
            ITraitVisitor tv = this.traitsVisitor.visitSlotTrait(6, ns_name, this.getSlotId(ns_binding), anyType, ns_init);
            tv.visitStart();
            this.processMetadata(tv, this.getAllMetaTags(nsDef));
            this.deferredVisitEnds.add(tv);
        }
    }

    public void makeParameter(IDefinition def, Name param_type) {
        Name param_name = ((DefinitionBase)def).getMName(this.getProject());
        if (((IParameterDefinition)def).isRest()) {
            this.hasRestParam = true;
        } else {
            this.getParamTypes().add(param_type);
        }
        this.allParams.add(param_name);
        Binding var = this.getBinding(def);
        this.makeVariable(var, param_type, EMPTY_META_INFO);
    }

    private void makeImplicitParameter(Name param_name, Name param_type) {
        this.allParams.add(param_name);
        Binding var = this.getBinding(null, param_name, null);
        this.makeVariable(var, param_type, EMPTY_META_INFO);
    }

    public void addDefaultValue(PooledValue value) {
        if (value != null) {
            this.methodInfo.addDefaultValue(value);
        }
    }

    public boolean needsThis() {
        return this.needsThis;
    }

    public Vector<Name> getParamTypes() {
        if (this.paramTypes == null) {
            this.paramTypes = new Vector();
        }
        return this.paramTypes;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public void setMethodInfo(MethodInfo methodInfo) {
        assert (this.methodInfo == null) : "trying to set an already set methodInfo";
        this.methodInfo = methodInfo;
        this.methodBodySemanticChecker = new MethodBodySemanticChecker(this);
    }

    public void resetMethodInfo() {
        this.methodInfo = null;
        this.methodBodySemanticChecker = null;
    }

    public Binding allocateTemp() {
        return this.allocateTemp(true);
    }

    public Binding allocateTemp(boolean reuse_free) {
        return this.tempManager.allocateTemp(reuse_free);
    }

    public void releaseTemp(Binding temp) {
        this.tempManager.releaseTemp(temp);
    }

    protected void mergeTemps(LexicalScope scopeToMerge) {
        this.tempManager.mergeTemps(scopeToMerge.tempManager);
    }

    protected void addInlinedBindings(Collection<Binding> bindings) {
        if (this.inlinedBindings == null) {
            this.inlinedBindings = new ArrayList<Binding>();
        }
        this.inlinedBindings.addAll(bindings);
    }

    protected void addHasNexts(Collection<Hasnext2Wrapper> nexts) {
        this.hasnexts.addAll(nexts);
    }

    protected Collection<Hasnext2Wrapper> getHasNexts() {
        return this.hasnexts;
    }

    protected Collection<Binding> getLocalBindings() {
        return this.localBindings.values();
    }

    Hasnext2Wrapper hasnext2() {
        Hasnext2Wrapper hasnext = new Hasnext2Wrapper();
        this.hasnexts.add(hasnext);
        hasnext.stem_temp = this.allocateTemp(false);
        hasnext.index_temp = this.allocateTemp(false);
        return hasnext;
    }

    public IASScope getLocalASScope() {
        return this.localScope;
    }

    public void setLocalASScope(IASScope scope) {
        assert (this.localScope == null || this.localScope == scope) : "Local scope already set.";
        this.localScope = scope;
    }

    public boolean isLocalDefinition(IDefinition candidate) {
        return candidate != null && candidate.getContainingScope() != null && candidate.getContainingScope() == this.localScope;
    }

    public Binding resolveName(IdentifierNode id) {
        ICompilerProject project = this.getProject();
        if (id instanceof ILanguageIdentifierNode) {
            ILanguageIdentifierNode lang_id = (ILanguageIdentifierNode)((Object)id);
            ILanguageIdentifierNode.LanguageIdentifierKind kind = lang_id.getKind();
            if (kind == ILanguageIdentifierNode.LanguageIdentifierKind.THIS) {
                return this.getThisBinding(id);
            }
            if (kind == ILanguageIdentifierNode.LanguageIdentifierKind.ANY_TYPE) {
                return new Binding(id, id.getMName(project), id.resolve(project));
            }
            if (kind == ILanguageIdentifierNode.LanguageIdentifierKind.VOID) {
                return new Binding(id, id.getMName(project), id.resolve(project));
            }
            assert (false) : "Unhandled LanguageIdentifierKind " + (Object)((Object)kind);
        }
        IDefinition def = id.resolve(project);
        Name name = id.getName().length() == 0 ? new Name(this.getGlobalScope().getSyntheticName("anonymous")) : id.getMName(project);
        if (SemanticUtils.isRefToClassBeingInited(id, def) && !this.insideInlineFunction()) {
            Binding b = this.getBinding(id, name, def);
            b.setIsLocal(true);
            b.setLocalRegister(0);
            return b;
        }
        if (name != null) {
            return this.getBinding(id, name, def);
        }
        return new Binding(id, new Name(id.getName()), def);
    }

    public Binding getBinding(IDefinition def) {
        return this.getBinding(null, this.getNameFromDefinition(def), def);
    }

    public Binding getBinding(IASNode node, Name name, IDefinition def) {
        if (name != null && this.isLocalDefinition(def) && this.localBindings.containsKey(name.getBaseName())) {
            Binding b = this.localBindings.get(name.getBaseName());
            return new Binding(node, b);
        }
        Binding result = new Binding(node, name, def);
        if (this.isLocalDefinition(def)) {
            this.localBindings.put(name.getBaseName(), result);
            if (this.localsInRegisters()) {
                result.setIsLocal(true);
            }
        }
        this.checkForArgumentsReference(result);
        return result;
    }

    private boolean needsImplicitArguments() {
        return this.argumentsState == ArgumentsState.REFERENCED;
    }

    private void checkForArgumentsDecl(Name name) {
        if (name != null && "arguments".equals(name.getBaseName())) {
            switch (this.argumentsState) {
                case INITIAL: 
                case REFERENCED: {
                    this.argumentsState = ArgumentsState.DECLARED;
                    break;
                }
            }
        }
    }

    private void checkForArgumentsReference(Binding b) {
        if (SemanticUtils.isArgumentsReference(b)) {
            switch (this.argumentsState) {
                case INITIAL: {
                    this.argumentsState = ArgumentsState.REFERENCED;
                    this.argumentsName = b.getName();
                    break;
                }
            }
        }
    }

    Binding getLocalBinding(Name name) {
        if (name != null) {
            return this.localBindings.get(name.getBaseName());
        }
        return null;
    }

    private Name getNameFromDefinition(IDefinition idef) {
        DefinitionBase def = (DefinitionBase)idef;
        return def.getMName(this.getProject());
    }

    protected Binding getThisBinding(IdentifierNode id) {
        Binding thisBinding = new Binding(id, null, null);
        thisBinding.setIsLocal(true);
        thisBinding.setLocalRegister(0);
        return thisBinding;
    }

    public InstructionList findProperty(Binding binding, boolean useStrict) {
        return this.findProperty(binding.getName(), binding.getDefinition(), useStrict);
    }

    public InstructionList findProperty(Name name, IDefinition def, boolean useStrict) {
        InstructionList result = new InstructionList(1);
        if (useStrict) {
            result.addInstruction(93, name);
        } else {
            result.addInstruction(94, name);
        }
        return result;
    }

    public InstructionList getPropertyValue(Binding binding) {
        return this.getPropertyValue(binding.getName(), binding.getDefinition());
    }

    public InstructionList getPropertyValue(Name name, IDefinition def) {
        InstructionList result = new InstructionList(1);
        result.addInstruction(96, name);
        return result;
    }

    public LexicalScope getEnclosingFrame() {
        return this.enclosingFrame;
    }

    InstructionList finishMethodDeclaration(boolean hasBody, String source_path) {
        InstructionList result = new InstructionList();
        if (this.needsThis) {
            result.addInstruction(208);
            result.addInstruction(48);
        }
        if (source_path != null) {
            String encoded_filename = this.getGlobalScope().getEncodedDebugFile(source_path);
            result.addInstruction(241, encoded_filename);
        }
        if (this.needsImplicitArguments()) {
            this.setNeedsArguments();
        }
        if (this.needsArguments()) {
            this.makeImplicitParameter(this.argumentsName, NAME_Array);
        }
        if (!this.isGlobalScope()) {
            int temp_register_count = 0;
            if (this.needsActivation()) {
                result.addInstruction(87);
                if (this.activationStorage != null) {
                    result.addInstruction(42);
                    result.addInstruction(this.activationStorage.setlocal());
                }
                result.addInstruction(48);
                for (int param_num = 0; param_num < this.allParams.size(); ++param_num) {
                    Name param_name = this.allParams.get(param_num);
                    result.addInstruction(93, param_name);
                    result.addInstruction(98, param_num + 1);
                    result.addInstruction(97, param_name);
                }
                temp_register_count = this.allParams.size() + 1;
            } else {
                HashSet<String> uniqueParamNames = new HashSet<String>();
                for (int param_num = this.allParams.size() - 1; param_num >= 0; --param_num) {
                    Name param_name = this.allParams.get(param_num);
                    String param_base_name = param_name.getBaseName();
                    Binding param_binding = this.localBindings.get(param_base_name);
                    if (param_binding == null || uniqueParamNames.contains(param_base_name)) continue;
                    param_binding.setLocalRegister(param_num + 1);
                    uniqueParamNames.add(param_base_name);
                }
                int local_num = this.allParams.size() + 1;
                for (Binding local_binding : this.localBindings.values()) {
                    if (local_binding.localNumberIsSet()) continue;
                    local_binding.setLocalRegister(local_num++);
                }
                temp_register_count = local_num;
            }
            this.initializeTempRegisters(temp_register_count);
        }
        this.addDebugNamesToDefinitions(result);
        if (this.hasHoistedInitInstructions()) {
            result.addAll(this.getHoistedInitInstructions());
        }
        return result;
    }

    public void finishClassStaticInitializer(InstructionList cinit_insns) {
        this.initializeTempRegisters(1);
        this.addDebugNamesToDefinitions(cinit_insns);
    }

    private void addDebugNamesToDefinitions(InstructionList result) {
        if (this.needsActivation()) {
            for (int param_num = 0; param_num < this.allParams.size(); ++param_num) {
                this.addDebugNameToDefinition(this.allParams.get(param_num).getBaseName(), param_num, result);
            }
            if (this.activationStorage != null) {
                this.addDebugNameToDefinition(this.methodInfo.getMethodName() + "$0", this.activationStorage.getLocalRegister() - 1, result);
            }
        } else {
            for (Binding local_binding : this.localBindings.values()) {
                if (SemanticUtils.isConstDefinition(local_binding.getDefinition())) continue;
                int index = local_binding.getLocalRegister() - 1;
                this.addDebugNameToDefinition(local_binding.getName().getBaseName(), index, result);
            }
        }
    }

    private void addDebugNameToDefinition(String name, int index, InstructionList result) {
        Object[] args = new Object[]{1, name, index};
        result.addInstruction(239, args);
    }

    public void initializeTempRegisters(int base) {
        base = this.tempManager.initializeTempRegisters(base);
        if (this.inlinedBindings != null) {
            for (Binding inlined_binding : this.inlinedBindings) {
                if (inlined_binding.localNumberIsSet()) continue;
                inlined_binding.setLocalRegister(base++);
            }
        }
        for (Hasnext2Wrapper hasnext : this.hasnexts) {
            hasnext.instruction.setTempRegisters(new Object[]{hasnext.stem_temp.getLocalRegister(), hasnext.index_temp.getLocalRegister()});
        }
    }

    public LexicalScope pushFrame() {
        return new LexicalScope(this);
    }

    public InlineFunctionLexicalScope pushInlineFunctionFrame(IASScope containingScope, boolean storeClassBinding, FunctionNode functionNode, boolean needsReturnValue) {
        return new InlineFunctionLexicalScope(this, containingScope, storeClassBinding, functionNode, needsReturnValue);
    }

    public boolean insideInlineFunction() {
        return false;
    }

    public LexicalScope popFrame() {
        assert (!this.isGlobalScope()) : "popping global scope";
        LexicalScope result = this.enclosingFrame;
        result.deferredVisitEnds.addAll(this.deferredVisitEnds);
        return result;
    }

    public boolean isGlobalScope() {
        return false;
    }

    public final GlobalLexicalScope getGlobalScope() {
        return this.globalLexicalScope;
    }

    public boolean needsActivation() {
        boolean result = this.methodInfo != null && (this.methodInfo.getFlags() & 2) != 0;
        return result;
    }

    public void setNeedsActivation() {
        if (this.methodInfo != null) {
            this.methodInfo.setFlags(this.methodInfo.getFlags() | 2);
        }
    }

    private boolean localsInRegisters() {
        return !this.needsActivation() && this.localScope != null;
    }

    public boolean needsArguments() {
        return this.methodInfo != null && (this.methodInfo.getFlags() & 1) != 0;
    }

    public void setNeedsArguments() {
        if (this.methodInfo != null) {
            this.methodInfo.setFlags(this.methodInfo.getFlags() | 1);
        }
    }

    public void setNeedsRest() {
        assert (this.methodInfo != null) : "methodInfo should not be null here";
        this.methodInfo.setFlags(this.methodInfo.getFlags() | 4);
    }

    public void setSetsDxns() {
        if (this.methodInfo != null) {
            this.methodInfo.setFlags(this.methodInfo.getFlags() | 0x40);
        }
    }

    public ControlFlowContextManager getFlowManager() {
        if (null == this.flowMgr) {
            this.flowMgr = new ControlFlowContextManager(this);
        }
        return this.flowMgr;
    }

    Binding getActivationStorage() {
        assert (this.needsActivation()) : "no activation storage present";
        if (this.activationStorage == null) {
            this.activationStorage = new Binding(null, new Name("activation"), null);
            this.activationStorage.setIsLocal(true);
            this.tempManager.addAllocatedTemp(this.activationStorage);
        }
        return this.activationStorage;
    }

    boolean hasHoistedInitInstructions() {
        return this.hoistedInitInstructions != null;
    }

    InstructionList getHoistedInitInstructions() {
        if (this.hoistedInitInstructions == null) {
            this.hoistedInitInstructions = new InstructionList();
        }
        return this.hoistedInitInstructions;
    }

    IMethodBodyVisitor getMethodBodyVisitor() {
        IMethodBodyVisitor result = this.methodBodyVisitor;
        if (result == null && this.enclosingFrame != null) {
            result = this.enclosingFrame.getMethodBodyVisitor();
        }
        assert (result != null);
        return result;
    }

    void declareAnonymousFunction() {
        this.declareNestedFunction();
        this.setFunctionName(this.getGlobalScope().getSyntheticName("anonymous"));
    }

    void declareFunctionObject(String name) {
        assert (name != null) : "Name must be specified.";
        this.declareNestedFunction();
        this.setFunctionName(name);
    }

    void declareNestedFunction() {
        this.setMethodInfo(new MethodInfo());
        this.methodVisitor = this.getEmitter().visitMethod(this.methodInfo);
        this.methodVisitor.visit();
        MethodBodyInfo mbi = new MethodBodyInfo();
        mbi.setMethodInfo(this.methodInfo);
        this.methodBodyVisitor = this.methodVisitor.visitBody(mbi);
        this.methodBodyVisitor.visit();
        this.traitsVisitor = this.methodBodyVisitor.visitTraits();
        this.needsThis = false;
        this.nestingState = NestingState.Nested;
    }

    void setFunctionName(String func_name) {
        assert (this.methodInfo != null && this.methodInfo.getMethodName() == null);
        this.methodInfo.setMethodName(func_name);
    }

    void generateNestedFunction(InstructionList body) {
        assert (this.methodInfo != null && this.methodInfo.getMethodName() != null) : String.format("this.methodInfo %s, this.methodInfo.getMethodName %s", this.methodInfo, this.methodInfo != null ? this.methodInfo.getMethodName() : "n/a");
        this.methodInfo.setParamTypes(this.getParamTypes());
        if (this.hasRestParam) {
            this.setNeedsRest();
        }
        if (!this.declaredVariables.contains(NAME_arguments) && this.localBindings.containsKey(NAME_arguments.getBaseName())) {
            this.setNeedsArguments();
        }
        if (body != null) {
            this.methodBodyVisitor.visitInstructionList(body);
        }
        this.finishMethod();
    }

    private void finishMethod() {
        this.deferredVisitEnds.add(this.traitsVisitor);
        this.deferredVisitEnds.add(this.methodBodyVisitor);
        this.deferredVisitEnds.add(this.methodVisitor);
    }

    public void processMetadata(ITraitVisitor tv, IMetaInfo[] meta_infos) {
        if (meta_infos == null) {
            return;
        }
        if (meta_infos.length == 0) {
            return;
        }
        IMetadataVisitor mv = tv.visitMetadata(meta_infos.length);
        LexicalScope.processMetadata(mv, meta_infos);
    }

    private static void processMetadata(IMetadataVisitor mv, IMetaInfo[] meta_infos) {
        for (IMetaInfo meta_info : meta_infos) {
            String name = meta_info.getTagName();
            IMetaTagAttribute[] attrs = meta_info.getAllAttributes();
            String[] keys = new String[attrs.length];
            String[] values = new String[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                keys[i] = attrs[i].getKey();
                values[i] = attrs[i].getValue();
            }
            Metadata metadata = new Metadata(name, keys, values);
            mv.visit(metadata);
        }
    }

    public boolean emitFile(String candidate) {
        return candidate != null && !this.getGlobalScope().getEncodedDebugFile(candidate).equals(this.currentDebugFile);
    }

    public boolean emitLine(int candidate) {
        return candidate > 0 && this.currentDebugFile != null && candidate != this.currentDebugLine;
    }

    public void setDebugFile(String file_name) {
        this.currentDebugFile = this.getGlobalScope().getEncodedDebugFile(file_name);
        this.setDebugLine(-1);
    }

    public String getDebugFile() {
        return this.currentDebugFile;
    }

    public void setDebugLine(int line_num) {
        this.currentDebugLine = line_num;
    }

    public void resetDebugInfo() {
        this.setDebugFile(null);
        this.setDebugLine(-1);
    }

    public NestingState getNestingState() {
        return this.nestingState;
    }

    void setInitialControlFlowRegionNode(IASNode node) {
        assert (this.initialControlFlowRegionNode == null) : "The syntax tree node should only be set once.";
        assert (node != null) : "The syntax tree node should never be set to null.";
        this.initialControlFlowRegionNode = node;
    }

    IASNode getInitialControlFlowRegionNode() {
        return this.initialControlFlowRegionNode;
    }

    void addVisitEndsToList(List<IVisitor> visitEnds) {
        visitEnds.addAll(this.deferredVisitEnds);
    }

    void callVisitEnds() {
        for (IVisitor v : this.deferredVisitEnds) {
            v.visitEnd();
        }
    }

    public void transferInitializerData() {
        this.hasnexts.addAll(this.enclosingFrame.hasnexts);
        this.enclosingFrame.hasnexts.clear();
        this.tempManager.addAllocatedTemps(this.enclosingFrame.tempManager.getAllocatedTemps());
        this.enclosingFrame.tempManager.clearAllocatedTemps();
    }

    public ICompilerProject getProject() {
        return this.getGlobalScope().getProject();
    }

    public ICodeGenerator getGenerator() {
        return this.getGlobalScope().getGenerator();
    }

    IABCVisitor getEmitter() {
        return this.getGlobalScope().getEmitter();
    }

    public boolean getInInvisibleCompilationUnit() {
        return this.getGlobalScope().getInInvisibleCompilationUnit();
    }

    public InstructionList getInitInstructions() {
        return this.getGlobalScope().getInitInstructions();
    }

    public MethodBodySemanticChecker getMethodBodySemanticChecker() {
        if (this.methodBodySemanticChecker != null) {
            return this.methodBodySemanticChecker;
        }
        if (this.enclosingFrame != null) {
            return this.enclosingFrame.getMethodBodySemanticChecker();
        }
        assert (false) : "No MethodBodySemanticChecker found.";
        return null;
    }

    public Collection<ICompilerProblem> getProblems() {
        return this.getGlobalScope().getProblems();
    }

    public void addProblem(ICompilerProblem problem) {
        this.getProblems().add(problem);
    }

    public void addProblems(Collection<ICompilerProblem> problems) {
        this.getProblems().addAll(problems);
    }

    final IMetaInfo[] getAllMetaTags(IDefinition definition) {
        assert (definition != null);
        boolean isLocalDef = this.isLocalDefinition(definition);
        assert (!(this.getLocalASScope() instanceof FunctionScope) || isLocalDef) : "If this lexical scope is for a function body, then all IDefinition passed to this method should be local definitions!";
        IMetaInfo[] existingTags = definition.getAllMetaTags();
        if (isLocalDef) {
            return existingTags;
        }
        if (definition.isPrivate()) {
            return existingTags;
        }
        MetaTag metaTag = MetaTag.createGotoDefinitionHelp(definition, definition.getContainingFilePath(), Integer.toString(definition.getNameStart()), false);
        IMetaInfo[] metaTags = MetaTag.addMetaTag(existingTags, metaTag);
        return metaTags;
    }

    class Hasnext2Wrapper {
        Binding stem_temp;
        Binding index_temp;
        Instruction instruction = InstructionFactory.getHasnext2Instruction();

        Hasnext2Wrapper() {
        }

        public void release() {
            LexicalScope.this.releaseTemp(this.index_temp);
            LexicalScope.this.releaseTemp(this.stem_temp);
        }
    }

    public static enum VariableMutability {
        Default,
        Variable,
        Constant;

    }

    private static enum ArgumentsState {
        INITIAL,
        REFERENCED,
        DECLARED;

    }

    public static enum NestingState {
        NotNested,
        Nested;

    }

    protected static class TempManager {
        private final ArrayList<Binding> allocatedTemps = new ArrayList();
        private final ArrayList<Binding> freeTemps = new ArrayList();
        private int tempNum = 0;

        protected TempManager() {
        }

        protected TempManager(TempManager tempManager) {
            this();
            this.tempNum = tempManager.tempNum;
        }

        protected Binding allocateTemp(boolean reuse_free) {
            Binding result;
            if (this.freeTemps.isEmpty() || !reuse_free) {
                result = new Binding(null, new Name("Temp #" + this.tempNum++), null);
                result.setIsLocal(true);
                this.addAllocatedTemp(result);
            } else {
                result = this.freeTemps.remove(0);
            }
            return result;
        }

        protected void addAllocatedTemp(Binding temp) {
            this.allocatedTemps.add(temp);
        }

        protected void addAllocatedTemps(ImmutableList<Binding> temps) {
            for (Binding temp : temps) {
                this.allocatedTemps.add(temp);
            }
        }

        protected ImmutableList<Binding> getAllocatedTemps() {
            return ImmutableList.copyOf(this.allocatedTemps);
        }

        protected void clearAllocatedTemps() {
            this.allocatedTemps.clear();
        }

        protected void releaseTemp(Binding temp) {
            assert (!this.freeTemps.contains(temp)) : "Temp " + temp + " is already freed.";
            this.freeTemps.add(temp);
        }

        protected int initializeTempRegisters(int base) {
            for (Binding temp : this.allocatedTemps) {
                temp.setLocalRegister(base++);
            }
            return base;
        }

        protected void mergeTemps(TempManager tempManagerToMerge) {
            for (Binding temp : tempManagerToMerge.allocatedTemps) {
                if (tempManagerToMerge.freeTemps.contains(temp)) continue;
                tempManagerToMerge.releaseTemp(temp);
            }
            this.tempNum += tempManagerToMerge.tempNum;
            this.freeTemps.addAll(tempManagerToMerge.freeTemps);
            this.allocatedTemps.addAll(tempManagerToMerge.allocatedTemps);
        }
    }
}

