/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.as.codegen;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.ClassInfo;
import com.adobe.flash.abc.semantics.InstanceInfo;
import com.adobe.flash.abc.semantics.MethodInfo;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.visitors.IABCVisitor;
import com.adobe.flash.abc.visitors.IClassVisitor;
import com.adobe.flash.abc.visitors.IMethodVisitor;
import com.adobe.flash.abc.visitors.ITraitVisitor;
import com.adobe.flash.abc.visitors.ITraitsVisitor;
import com.adobe.flash.compiler.common.ASModifier;
import com.adobe.flash.compiler.common.ModifiersSet;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IInterfaceDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.internal.as.codegen.DirectiveProcessor;
import com.adobe.flash.compiler.internal.as.codegen.LexicalScope;
import com.adobe.flash.compiler.internal.definitions.AmbiguousDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.DefinitionBase;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.definitions.InterfaceDefinition;
import com.adobe.flash.compiler.internal.semantics.SemanticUtils;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.internal.tree.as.ImportNode;
import com.adobe.flash.compiler.internal.tree.as.InterfaceNode;
import com.adobe.flash.compiler.internal.tree.as.NamespaceIdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.VariableNode;
import com.adobe.flash.compiler.problems.AmbiguousReferenceProblem;
import com.adobe.flash.compiler.problems.BadAccessInterfaceMemberProblem;
import com.adobe.flash.compiler.problems.CannotExtendClassProblem;
import com.adobe.flash.compiler.problems.ConstructorInInterfaceProblem;
import com.adobe.flash.compiler.problems.DuplicateInterfaceDefinitionProblem;
import com.adobe.flash.compiler.problems.FinalOutsideClassProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.InterfaceBindablePropertyProblem;
import com.adobe.flash.compiler.problems.InterfaceMethodWithBodyProblem;
import com.adobe.flash.compiler.problems.InterfaceNamespaceAttributeProblem;
import com.adobe.flash.compiler.problems.InvalidOverrideProblem;
import com.adobe.flash.compiler.problems.NamespaceInInterfaceProblem;
import com.adobe.flash.compiler.problems.NativeUsedInInterfaceProblem;
import com.adobe.flash.compiler.problems.StaticOutsideClassProblem;
import com.adobe.flash.compiler.problems.UnknownInterfaceProblem;
import com.adobe.flash.compiler.problems.VarInInterfaceProblem;
import com.adobe.flash.compiler.problems.VirtualOutsideClassProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.INamespaceDecorationNode;
import java.util.Iterator;

public class InterfaceDirectiveProcessor
extends DirectiveProcessor {
    InterfaceNode interfaceNode;
    LexicalScope interfaceScope;
    IABCVisitor emitter;
    Name interfaceName;
    ITraitsVisitor itraits;
    IClassVisitor cv;
    ClassInfo cinfo = new ClassInfo();
    InstanceInfo iinfo = new InstanceInfo();

    InterfaceDirectiveProcessor(InterfaceNode in, LexicalScope enclosing_scope, IABCVisitor emitter) {
        super(enclosing_scope.getProblems());
        this.interfaceNode = in;
        this.emitter = emitter;
        this.interfaceScope = enclosing_scope.pushFrame();
        InterfaceDefinition interfDef = this.interfaceNode.getDefinition();
        this.iinfo.name = this.interfaceName = interfDef.getMName(this.interfaceScope.getProject());
        switch (SemanticUtils.getMultiDefinitionType(this.interfaceNode.getDefinition(), this.interfaceScope.getProject())) {
            case AMBIGUOUS: {
                this.interfaceScope.addProblem(new DuplicateInterfaceDefinitionProblem(in, this.interfaceName.getBaseName()));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.interfaceName != null) {
            SemanticUtils.checkScopedToDefaultNamespaceProblem(this.interfaceScope, in, interfDef, this.interfaceName.getBaseName());
        }
        Iterator<IInterfaceDefinition> ifaces = interfDef.interfaceIterator(this.interfaceScope.getProject(), false, this.interfaceScope.getProblems());
        while (ifaces.hasNext()) {
            ifaces.next();
        }
        this.iinfo.superName = null;
        IExpressionNode[] raw_interfaces = this.interfaceNode.getExtendedInterfaceNodes();
        this.iinfo.interfaceNames = new Name[raw_interfaces.length];
        for (int i = 0; i < raw_interfaces.length; ++i) {
            IExpressionNode extendedInterface = raw_interfaces[i];
            IDefinition extendedDefinition = extendedInterface.resolve(this.interfaceScope.getProject());
            if (extendedDefinition instanceof IInterfaceDefinition) {
                Name interfaceName;
                this.iinfo.interfaceNames[i] = interfaceName = ((DefinitionBase)extendedDefinition).getMName(this.interfaceScope.getProject());
            } else if (extendedDefinition instanceof ClassDefinition) {
                this.interfaceScope.addProblem(new CannotExtendClassProblem(extendedInterface, extendedDefinition.getBaseName()));
            } else if (extendedDefinition instanceof AmbiguousDefinition) {
                if (extendedInterface instanceof IIdentifierNode) {
                    this.interfaceScope.addProblem(new AmbiguousReferenceProblem(extendedInterface, ((IIdentifierNode)extendedInterface).getName()));
                } else {
                    this.interfaceScope.addProblem(new AmbiguousReferenceProblem(extendedInterface, ""));
                }
            } else if (extendedDefinition != null) {
                this.interfaceScope.addProblem(new UnknownInterfaceProblem(extendedInterface, extendedDefinition.getBaseName()));
            } else if (extendedInterface instanceof IIdentifierNode) {
                this.interfaceScope.addProblem(new UnknownInterfaceProblem(extendedInterface, ((IIdentifierNode)extendedInterface).getName()));
            } else {
                this.interfaceScope.addProblem(new UnknownInterfaceProblem(extendedInterface, ""));
            }
            if (extendedDefinition == null || !extendedDefinition.isDeprecated() || SemanticUtils.hasDeprecatedAncestor(extendedInterface)) continue;
            ICompilerProblem problem = SemanticUtils.createDeprecationProblem(extendedDefinition, extendedInterface);
            this.interfaceScope.addProblem(problem);
        }
        this.iinfo.flags |= 4;
        this.cv = emitter.visitClass(this.iinfo, this.cinfo);
        this.cv.visit();
        this.itraits = this.cv.visitInstanceTraits();
        InstructionList setup_insns = this.interfaceScope.getGlobalScope().getInitInstructions();
        setup_insns.addInstruction(101, 0);
        setup_insns.addInstruction(32);
        setup_insns.addInstruction(88, this.cinfo);
        setup_insns.addInstruction(104, this.interfaceName);
        ITraitVisitor tv = this.interfaceScope.getGlobalScope().traitsVisitor.visitClassTrait(4, this.interfaceName, 0, this.cinfo);
        this.interfaceScope.processMetadata(tv, this.interfaceScope.getAllMetaTags(interfDef));
        tv.visitEnd();
    }

    void finishInterfaceDefinition() {
        this.itraits.visitEnd();
        this.cv.visitEnd();
    }

    @Override
    void declareVariable(VariableNode var) {
        this.interfaceScope.addProblem(new VarInInterfaceProblem(var.getNameExpressionNode()));
    }

    @Override
    void declareFunction(FunctionNode func) {
        func.parseFunctionBody(this.interfaceScope.getProblems());
        this.functionSemanticChecks(func);
        FunctionDefinition func_def = func.getDefinition();
        String interfaceBaseName = this.interfaceNode.getShortName();
        if (func_def.getBaseName().equals(interfaceBaseName)) {
            return;
        }
        MethodInfo mi = this.interfaceScope.getGenerator().createMethodInfoWithDefaultArgumentValues(this.interfaceScope, func);
        ICompilerProject project = this.interfaceScope.getProject();
        ExpressionNodeBase return_type_expr = (ExpressionNodeBase)func.getReturnTypeNode();
        if (return_type_expr != null) {
            Name return_type_name = return_type_expr.getMName(project);
            mi.setReturnType(return_type_name);
        }
        IMethodVisitor mv = this.emitter.visitMethod(mi);
        mv.visit();
        mv.visitEnd();
        Name funcName = func_def.getMName(project);
        ITraitVisitor traitVisitor = this.itraits.visitMethodTrait(InterfaceDirectiveProcessor.functionTraitKind(func, 1), funcName, 0, mi);
        traitVisitor.visitStart();
        this.interfaceScope.processMetadata(traitVisitor, this.interfaceScope.getAllMetaTags(func_def));
        traitVisitor.visitEnd();
    }

    void functionSemanticChecks(FunctionNode func) {
        Name funcName;
        FunctionDefinition func_def = func.getDefinition();
        String interfaceBaseName = this.interfaceNode.getShortName();
        if (func_def.getBaseName().equals(interfaceBaseName)) {
            this.interfaceScope.addProblem(new ConstructorInInterfaceProblem(func));
            return;
        }
        this.verifyFunctionModifiers(func);
        this.verifyFunctionNamespace(func, func_def);
        SemanticUtils.checkReturnValueHasNoTypeDeclaration(this.interfaceScope, func, func_def);
        if (func.hasBody()) {
            this.interfaceScope.addProblem(new InterfaceMethodWithBodyProblem(SemanticUtils.getFunctionProblemNode(func)));
        }
        ICompilerProject project = this.interfaceScope.getProject();
        this.interfaceScope.getMethodBodySemanticChecker().checkFunctionDecl(func);
        ITypeDefinition return_type = func_def.resolveReturnType(project);
        if (!SemanticUtils.isType(return_type)) {
            this.interfaceScope.getMethodBodySemanticChecker().addTypeProblem(func.getReturnTypeNode(), return_type, func_def.getReturnTypeAsDisplayString(), true);
        }
        if ((funcName = func_def.getMName(project)) != null) {
            this.interfaceScope.getMethodBodySemanticChecker().checkInterfaceFunctionForConflictingDefinitions(func, func_def);
        }
    }

    private void verifyFunctionNamespace(FunctionNode func, FunctionDefinition func_def) {
        INamespaceDecorationNode nsNode = func.getActualNamespaceNode();
        if (nsNode != null) {
            boolean isLanguateNS = false;
            if ("internal".equals(nsNode.getName())) {
                isLanguateNS = true;
            } else {
                INamespaceReference ns_ref = func_def.getNamespaceReference();
                if (ns_ref instanceof INamespaceDefinition.ILanguageNamespaceDefinition) {
                    isLanguateNS = true;
                }
            }
            if (isLanguateNS) {
                this.interfaceScope.addProblem(new BadAccessInterfaceMemberProblem(func));
            } else {
                this.interfaceScope.addProblem(new InterfaceNamespaceAttributeProblem(func));
            }
        }
    }

    protected void verifyFunctionModifiers(FunctionNode f) {
        ModifiersSet modifiersSet = f.getModifiers();
        if (modifiersSet == null) {
            return;
        }
        ASModifier[] modifiers = modifiersSet.getAllModifiers();
        IExpressionNode site = f.getNameExpressionNode();
        for (ASModifier modifier : modifiers) {
            if (modifier == ASModifier.STATIC) {
                this.interfaceScope.addProblem(new StaticOutsideClassProblem(site));
                continue;
            }
            if (modifier == ASModifier.OVERRIDE) {
                this.interfaceScope.addProblem(new InvalidOverrideProblem(site));
                continue;
            }
            if (modifier == ASModifier.FINAL) {
                this.interfaceScope.addProblem(new FinalOutsideClassProblem(site));
                continue;
            }
            if (modifier == ASModifier.NATIVE) {
                this.interfaceScope.addProblem(new NativeUsedInInterfaceProblem(site));
                continue;
            }
            if (modifier == ASModifier.VIRTUAL) {
                this.interfaceScope.addProblem(new VirtualOutsideClassProblem(site));
                continue;
            }
            if (modifier != ASModifier.DYNAMIC) continue;
        }
        this.interfaceScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(f);
    }

    @Override
    void processNamespaceIdentifierDirective(NamespaceIdentifierNode ns) {
        this.interfaceScope.addProblem(new NamespaceInInterfaceProblem(ns));
    }

    @Override
    void processImportDirective(ImportNode imp) {
        this.interfaceScope.getGenerator().generateInstructions(imp, 25, this.interfaceScope);
    }

    @Override
    void processDirective(IASNode n) {
        switch (n.getNodeID()) {
            case NamespaceID: {
                this.interfaceScope.addProblem(new NamespaceInInterfaceProblem(n));
                break;
            }
            default: {
                super.processDirective(n);
            }
        }
    }

    @Override
    void declareBindableVariable(VariableNode varNode) {
        this.interfaceScope.addProblem(new InterfaceBindablePropertyProblem(varNode));
    }
}

