/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.as.codegen;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.Label;
import com.adobe.flash.compiler.internal.as.codegen.Binding;
import com.adobe.flash.compiler.internal.as.codegen.CmcEmitter;
import com.adobe.flash.compiler.internal.as.codegen.ControlFlowContext;
import com.adobe.flash.compiler.internal.as.codegen.ControlFlowContextManager;
import java.util.Vector;

public final class ExceptionHandlingContext
extends ControlFlowContext {
    ControlFlowContextManager flowMgr;
    Label finallyBlock = null;
    Label finallyDoRethrow = null;
    Label finallyDoFallthrough = null;
    Binding finallyReturnStorage = null;
    Binding exceptionStorage = null;
    TryCatchFinallyState tryCatchFinallyState = TryCatchFinallyState.INITIAL;
    Vector<FinallyReturn> finallyReturns = null;
    boolean hasFinally = false;

    ExceptionHandlingContext(ControlFlowContextManager flow_mgr) {
        super(null);
        this.flowMgr = flow_mgr;
    }

    @Override
    InstructionList addExitPath(InstructionList exitBranch) {
        InstructionList result = exitBranch;
        if (this.hasFinallyBlock() && !this.isActiveFinally()) {
            result = this.addFinallyReturn(result);
        }
        if (this.isActiveCatchBlock()) {
            InstructionList catch_fixup = new InstructionList();
            catch_fixup.addInstruction(29);
            catch_fixup.addInstruction(this.getExceptionStorage().kill());
            catch_fixup.addAll(result);
            result = catch_fixup;
        }
        return result;
    }

    @Override
    void addExceptionHandlerEntry(InstructionList exceptionHandler) {
        if (this.isActiveCatchBlock()) {
            exceptionHandler.addInstruction(this.getExceptionStorage().getlocal());
            exceptionHandler.addInstruction(48);
        }
    }

    private InstructionList addFinallyReturn(InstructionList retblock) {
        assert (this.finallyReturns != null) : "Not a finally context.";
        Label retblock_label = new Label();
        retblock.labelFirst(retblock_label);
        this.finallyReturns.add(new FinallyReturn(retblock_label, retblock));
        InstructionList result = new InstructionList();
        CmcEmitter.pushNumericConstant(this.finallyReturns.size(), result);
        result.addInstruction(130);
        result.addInstruction(this.finallyReturnStorage.setlocal());
        result.addInstruction(16, this.finallyBlock);
        return result;
    }

    public Binding getExceptionStorage() {
        if (this.exceptionStorage == null) {
            this.exceptionStorage = this.flowMgr.currentScope.allocateTemp();
        }
        return this.exceptionStorage;
    }

    void startTryControlState() {
        assert (this.tryCatchFinallyState == TryCatchFinallyState.INITIAL);
        this.tryCatchFinallyState = TryCatchFinallyState.TRY;
    }

    void startFinallyControlState() {
        assert (this.tryCatchFinallyState == TryCatchFinallyState.TRY);
        this.tryCatchFinallyState = TryCatchFinallyState.FINALLY;
    }

    void endFinallyControlState() {
        assert (this.tryCatchFinallyState == TryCatchFinallyState.FINALLY);
        this.tryCatchFinallyState = TryCatchFinallyState.CATCH;
    }

    void startCatchControlState() {
        this.tryCatchFinallyState = TryCatchFinallyState.CATCH;
    }

    void endCatchControlState() {
        assert (TryCatchFinallyState.CATCH == this.tryCatchFinallyState) : "leaving catch, but control state is " + (Object)((Object)this.tryCatchFinallyState);
    }

    private boolean isActiveCatchBlock() {
        return TryCatchFinallyState.CATCH == this.tryCatchFinallyState;
    }

    private boolean isActiveFinally() {
        return TryCatchFinallyState.FINALLY == this.tryCatchFinallyState;
    }

    private boolean hasFinallyBlock() {
        return this.hasFinally;
    }

    void setHasFinallyBlock(boolean has_finally) {
        this.hasFinally = has_finally;
    }

    public static class FinallyReturn {
        Label finallyLabel;
        InstructionList finallyInsns;

        FinallyReturn(Label label, InstructionList list) {
            this.finallyLabel = label;
            this.finallyInsns = list;
        }

        Label getLabel() {
            return this.finallyLabel;
        }

        InstructionList getInstructions() {
            return this.finallyInsns;
        }
    }

    static enum TryCatchFinallyState {
        INITIAL,
        TRY,
        FINALLY,
        CATCH;

    }
}

