/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.as.codegen;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.Label;
import com.adobe.flash.compiler.exceptions.DuplicateLabelException;
import com.adobe.flash.compiler.exceptions.UnknownControlFlowTargetException;
import com.adobe.flash.compiler.internal.as.codegen.Binding;
import com.adobe.flash.compiler.internal.as.codegen.CmcEmitter;
import com.adobe.flash.compiler.internal.as.codegen.ControlFlowContext;
import com.adobe.flash.compiler.internal.as.codegen.ExceptionHandlingContext;
import com.adobe.flash.compiler.internal.as.codegen.LabelScopeControlFlowContext;
import com.adobe.flash.compiler.internal.as.codegen.LabeledStatementControlFlowContext;
import com.adobe.flash.compiler.internal.as.codegen.LexicalScope;
import com.adobe.flash.compiler.internal.as.codegen.LoopControlFlowContext;
import com.adobe.flash.compiler.internal.as.codegen.SwitchControlFlowContext;
import com.adobe.flash.compiler.internal.as.codegen.WithContext;
import com.adobe.flash.compiler.internal.tree.as.LabeledStatementNode;
import com.adobe.flash.compiler.internal.tree.as.SwitchNode;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.ICatchNode;
import com.adobe.flash.compiler.tree.as.ITryNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;

public class ControlFlowContextManager {
    final LexicalScope currentScope;
    public static final ControlFlowContextSearchCriteria FIND_ALL_CONTEXTS = new ControlFlowContextSearchCriteria(){

        @Override
        boolean match(ControlFlowContext c) {
            return true;
        }

        @Override
        Label getLabel(ControlFlowContext c) {
            return null;
        }

        @Override
        boolean innerToOuter() {
            return false;
        }
    };
    static ControlFlowContextSearchCriteria breakWithOutLabelCriteria = new ControlFlowContextSearchCriteria(){

        @Override
        boolean match(ControlFlowContext c) {
            return c.hasDefaultBreakLabel();
        }

        @Override
        Label getLabel(ControlFlowContext c) {
            assert (this.match(c));
            return c.getBreakLabel();
        }

        @Override
        boolean innerToOuter() {
            return true;
        }
    };
    static ControlFlowContextSearchCriteria continueWithOutLabelCriteria = new ControlFlowContextSearchCriteria(){

        @Override
        boolean match(ControlFlowContext c) {
            return c.hasDefaultContinueLabel();
        }

        @Override
        Label getLabel(ControlFlowContext c) {
            assert (this.match(c));
            return c.getContinueLabel();
        }

        @Override
        boolean innerToOuter() {
            return true;
        }
    };
    Vector<ControlFlowContext> activeFlowContexts = new Vector();
    public static final int CONTEXT_NOT_FOUND = -1;

    ControlFlowContextSearchCriteria breakWithLabelCriteria(final String label) {
        return new ControlFlowContextSearchCriteria(){

            @Override
            boolean match(ControlFlowContext c) {
                return c.hasBreakLabel(label);
            }

            @Override
            Label getLabel(ControlFlowContext c) {
                assert (this.match(c));
                return c.getBreakLabel();
            }

            @Override
            boolean innerToOuter() {
                return false;
            }
        };
    }

    ControlFlowContextSearchCriteria continueWithLabelCriteria(final String label) {
        return new ControlFlowContextSearchCriteria(){

            @Override
            boolean match(ControlFlowContext c) {
                return c.hasContinueLabel(label);
            }

            @Override
            Label getLabel(ControlFlowContext c) {
                assert (this.match(c));
                return c.getContinueLabel();
            }

            @Override
            boolean innerToOuter() {
                return false;
            }
        };
    }

    ControlFlowContextSearchCriteria gotoLabelCriteria(final String label, final boolean allowDuplicates) {
        return new ControlFlowContextSearchCriteria(){

            @Override
            boolean match(ControlFlowContext c) {
                return c.hasGotoLabel(label, allowDuplicates);
            }

            @Override
            Label getLabel(ControlFlowContext c) {
                assert (this.match(c));
                return c.getGotoLabel(label);
            }

            @Override
            boolean innerToOuter() {
                return true;
            }
        };
    }

    ControlFlowContextManager(LexicalScope current_scope) {
        this.currentScope = current_scope;
        IASNode initialControlFlowRegionNode = this.currentScope.getInitialControlFlowRegionNode();
        if (initialControlFlowRegionNode != null) {
            LabelScopeControlFlowContext rootContext = new LabelScopeControlFlowContext(initialControlFlowRegionNode);
            this.activeFlowContexts.add(rootContext);
        }
    }

    private int getTopControlFlowContextIndex() {
        int result;
        for (result = this.activeFlowContexts.size() - 1; result >= 0 && !(this.activeFlowContexts.elementAt(result) instanceof LoopControlFlowContext); --result) {
        }
        return result;
    }

    private LoopControlFlowContext peekActiveLoopControlFlowContext() {
        int idx = this.getTopControlFlowContextIndex();
        assert (idx >= 0) : "no non-finally flow context";
        return (LoopControlFlowContext)this.activeFlowContexts.elementAt(idx);
    }

    private Object popContext() {
        assert (!this.activeFlowContexts.isEmpty()) : "no active control-flow context";
        return this.activeFlowContexts.remove(this.activeFlowContexts.size() - 1);
    }

    private SwitchControlFlowContext popSwitchControlFlowContext() {
        return (SwitchControlFlowContext)this.popContext();
    }

    private LabeledStatementControlFlowContext popLabeledStatementControlFlowContext() {
        return (LabeledStatementControlFlowContext)this.popContext();
    }

    private LoopControlFlowContext popLoopControlFlowContext() {
        return (LoopControlFlowContext)this.popContext();
    }

    private ExceptionHandlingContext popExceptionHandlingContext() {
        this.popContext();
        return (ExceptionHandlingContext)this.popContext();
    }

    public void startLoopControlFlowContext(IASNode loopContents) {
        this.activeFlowContexts.add(new LoopControlFlowContext(loopContents));
    }

    public void startSwitchContext(SwitchNode node) {
        this.activeFlowContexts.add(new SwitchControlFlowContext(node));
    }

    public void startLabeledStatementControlFlowContext(LabeledStatementNode labeledStatement) throws DuplicateLabelException {
        String labelName = labeledStatement.getLabel();
        boolean is_duplicate = this.findControlFlowContextNoError(this.breakWithLabelCriteria(labelName)) != -1;
        this.activeFlowContexts.add(new LabeledStatementControlFlowContext(labeledStatement, labelName));
        if (is_duplicate) {
            throw new DuplicateLabelException((Object)labelName);
        }
    }

    private final int findControlFlowContextNoError(ControlFlowContextSearchCriteria criterion) {
        int nContexts = this.activeFlowContexts.size();
        if (nContexts == 0) {
            return -1;
        }
        if (criterion == FIND_ALL_CONTEXTS) {
            return 0;
        }
        if (criterion.innerToOuter()) {
            for (int i = nContexts - 1; i >= 0; --i) {
                ControlFlowContext context = this.activeFlowContexts.elementAt(i);
                if (!criterion.match(context)) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < nContexts; ++i) {
            ControlFlowContext context = this.activeFlowContexts.elementAt(i);
            if (!criterion.match(context)) continue;
            return i;
        }
        return -1;
    }

    private int findControlFlowContext(ControlFlowContextSearchCriteria criterion) throws UnknownControlFlowTargetException {
        int result = this.findControlFlowContextNoError(criterion);
        if (result == -1) {
            throw new UnknownControlFlowTargetException(criterion);
        }
        return result;
    }

    void startExceptionContext(ITryNode tryNode) {
        ExceptionHandlingContext finally_context = new ExceptionHandlingContext(this);
        finally_context.finallyReturns = new Vector();
        finally_context.finallyBlock = new Label();
        finally_context.finallyDoRethrow = new Label();
        finally_context.finallyDoFallthrough = new Label("finallyDoFallthrough");
        finally_context.finallyReturnStorage = this.currentScope.allocateTemp();
        this.activeFlowContexts.add(finally_context);
        finally_context.startTryControlState();
        this.activeFlowContexts.add(new LabelScopeControlFlowContext(tryNode.getStatementContentsNode()));
    }

    void startFinallyContext(IASNode finallyStatements) {
        this.getFinallyContext().startFinallyControlState();
        this.popContext();
        this.activeFlowContexts.add(new LabelScopeControlFlowContext(finallyStatements));
    }

    void endFinallyContext() {
        this.getFinallyContext().endFinallyControlState();
    }

    void startCatchContext(ICatchNode catchNode) {
        this.getFinallyContext().startCatchControlState();
        this.popContext();
        this.activeFlowContexts.add(new LabelScopeControlFlowContext(catchNode.getStatementContentsNode()));
    }

    void endCatchContext() {
        this.getFinallyContext().endCatchControlState();
    }

    public InstructionList getFinallySwitch() {
        Object[] finally_labels;
        InstructionList result = new InstructionList();
        ExceptionHandlingContext finally_context = this.getFinallyContext();
        int n_alternatives = this.getFinallyAlternativesSize();
        if (0 == n_alternatives) {
            finally_labels = new Label[]{finally_context.finallyDoFallthrough, finally_context.finallyDoRethrow};
        } else {
            finally_labels = new Label[n_alternatives + 2];
            finally_labels[0] = finally_context.finallyDoFallthrough;
            int i = 1;
            for (ExceptionHandlingContext.FinallyReturn ret : this.getFinallyContext().finallyReturns) {
                finally_labels[i++] = ret.getLabel();
            }
            finally_labels[i] = finally_context.finallyDoRethrow;
        }
        result.addInstruction(27, finally_labels);
        return result;
    }

    public InstructionList getScopeStackReinit() {
        InstructionList result = new InstructionList();
        assert (this.activeFlowContexts.size() >= 2);
        assert (this.activeFlowContexts.lastElement() instanceof LabelScopeControlFlowContext);
        for (int i = 0; i < this.activeFlowContexts.size() - 2; ++i) {
            ControlFlowContext context = this.activeFlowContexts.elementAt(i);
            context.addExceptionHandlerEntry(result);
        }
        return result;
    }

    InstructionList getNonLocalControlFlow(InstructionList original, ControlFlowContextSearchCriteria criterion) throws UnknownControlFlowTargetException {
        int criterion_index = this.findControlFlowContext(criterion);
        InstructionList result = original;
        for (int i = criterion_index; i < this.activeFlowContexts.size(); ++i) {
            ControlFlowContext context = this.activeFlowContexts.elementAt(i);
            result = context.addExitPath(result);
        }
        return result;
    }

    public ExceptionHandlingContext getFinallyContext() {
        assert (this.activeFlowContexts.size() >= 2);
        assert (this.activeFlowContexts.lastElement() instanceof LabelScopeControlFlowContext);
        ExceptionHandlingContext current_context = (ExceptionHandlingContext)this.activeFlowContexts.get(this.activeFlowContexts.size() - 2);
        return current_context;
    }

    public int getFinallyAlternativesSize() {
        return this.getFinallyContext().finallyReturns.size();
    }

    public InstructionList getFinallyFailSignal() {
        InstructionList result = new InstructionList();
        CmcEmitter.pushNumericConstant(this.getFinallyAlternativesSize() + 1, result);
        return result;
    }

    void finishExceptionContext() {
        this.popExceptionHandlingContext();
    }

    Label getGotoLabel(String label) {
        ControlFlowContextSearchCriteria criterion = this.gotoLabelCriteria(label, false);
        int context_idx = this.findControlFlowContextNoError(criterion);
        if (context_idx == -1) {
            return null;
        }
        ControlFlowContext ctx = this.activeFlowContexts.elementAt(context_idx);
        assert (ctx.hasGotoLabel(label, false));
        return ctx.getGotoLabel(label);
    }

    InstructionList getBranchTarget(ControlFlowContextSearchCriteria criterion) throws UnknownControlFlowTargetException {
        InstructionList result = new InstructionList();
        int context_idx = this.findControlFlowContext(criterion);
        ControlFlowContext ctx = this.activeFlowContexts.elementAt(context_idx);
        result.addInstruction(16, criterion.getLabel(ctx));
        return result;
    }

    Collection<LabeledStatementNode> getGotoLabels(String label) {
        ControlFlowContextSearchCriteria criterion = this.gotoLabelCriteria(label, true);
        int context_idx = this.findControlFlowContextNoError(criterion);
        if (context_idx == -1) {
            return Collections.emptyList();
        }
        LabelScopeControlFlowContext context = (LabelScopeControlFlowContext)this.activeFlowContexts.elementAt(context_idx);
        return context.getLabelNodes(label);
    }

    void finishLabeledStatementControlFlowContext(InstructionList insns) {
        LabeledStatementControlFlowContext context = this.popLabeledStatementControlFlowContext();
        if (context.hasActiveBreak()) {
            insns.labelNext(context.getBreakLabel());
        }
    }

    void finishSwitchControlFlowContext(InstructionList insns) {
        SwitchControlFlowContext context = this.popSwitchControlFlowContext();
        if (context.hasActiveBreak()) {
            insns.labelNext(context.getBreakLabel());
        }
    }

    void finishLoopControlFlowContext(InstructionList insns) {
        LoopControlFlowContext current_context = this.popLoopControlFlowContext();
        if (current_context.hasActiveBreak()) {
            insns.labelNext(current_context.getBreakLabel());
        }
    }

    void resolveContinueLabel(InstructionList continue_target) {
        LoopControlFlowContext context = this.peekActiveLoopControlFlowContext();
        if (context.hasActiveContinue()) {
            continue_target.labelFirst(context.getContinueLabel());
        }
    }

    void startWithContext(IASNode withContents) {
        WithContext with_context = new WithContext(withContents, this);
        this.activeFlowContexts.add(with_context);
    }

    void finishWithContext(InstructionList result) {
        WithContext with_context = (WithContext)this.activeFlowContexts.lastElement();
        with_context.finish(result);
        this.popContext();
    }

    Binding getWithStorage() {
        WithContext with_context = (WithContext)this.activeFlowContexts.lastElement();
        return with_context.getWithStorage();
    }

    boolean hasWithStorage() {
        WithContext with_context = (WithContext)this.activeFlowContexts.lastElement();
        return with_context.hasWithStorage();
    }

    boolean hasNontrivialFlowCharacteristics() {
        for (ControlFlowContext ctx : this.activeFlowContexts) {
            if (!(ctx instanceof WithContext) && !(ctx instanceof ExceptionHandlingContext)) continue;
            return true;
        }
        return false;
    }

    static abstract class ControlFlowContextSearchCriteria {
        ControlFlowContextSearchCriteria() {
        }

        abstract boolean match(ControlFlowContext var1);

        abstract Label getLabel(ControlFlowContext var1);

        abstract boolean innerToOuter();
    }
}

