/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.as.codegen;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.ClassInfo;
import com.adobe.flash.abc.semantics.InstanceInfo;
import com.adobe.flash.abc.semantics.MethodBodyInfo;
import com.adobe.flash.abc.semantics.MethodInfo;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.PooledValue;
import com.adobe.flash.abc.visitors.IABCVisitor;
import com.adobe.flash.abc.visitors.IClassVisitor;
import com.adobe.flash.abc.visitors.IMethodBodyVisitor;
import com.adobe.flash.abc.visitors.IMethodVisitor;
import com.adobe.flash.abc.visitors.ITraitVisitor;
import com.adobe.flash.abc.visitors.ITraitsVisitor;
import com.adobe.flash.compiler.common.ASModifier;
import com.adobe.flash.compiler.common.IMetaInfo;
import com.adobe.flash.compiler.common.ModifiersSet;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IAccessorDefinition;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IConstantDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IInterfaceDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTag;
import com.adobe.flash.compiler.exceptions.CodegenInterruptedException;
import com.adobe.flash.compiler.internal.as.codegen.BindableHelper;
import com.adobe.flash.compiler.internal.as.codegen.Binding;
import com.adobe.flash.compiler.internal.as.codegen.DirectiveProcessor;
import com.adobe.flash.compiler.internal.as.codegen.ICodeGenerator;
import com.adobe.flash.compiler.internal.as.codegen.LexicalScope;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.DefinitionBase;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.definitions.InterfaceDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.definitions.TypeDefinitionBase;
import com.adobe.flash.compiler.internal.definitions.VariableDefinition;
import com.adobe.flash.compiler.internal.definitions.metadata.MetaTag;
import com.adobe.flash.compiler.internal.definitions.metadata.ResourceBundleMetaTag;
import com.adobe.flash.compiler.internal.embedding.EmbedData;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.semantics.MethodBodySemanticChecker;
import com.adobe.flash.compiler.internal.semantics.SemanticUtils;
import com.adobe.flash.compiler.internal.tree.as.BaseDefinitionNode;
import com.adobe.flash.compiler.internal.tree.as.ClassNode;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.internal.tree.as.ImportNode;
import com.adobe.flash.compiler.internal.tree.as.NamespaceIdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.NamespaceNode;
import com.adobe.flash.compiler.internal.tree.as.VariableNode;
import com.adobe.flash.compiler.problems.CircularTypeReferenceProblem;
import com.adobe.flash.compiler.problems.ConstructorCannotHaveReturnTypeProblem;
import com.adobe.flash.compiler.problems.ConstructorIsGetterSetterProblem;
import com.adobe.flash.compiler.problems.ConstructorIsStaticProblem;
import com.adobe.flash.compiler.problems.ConstructorMustBePublicProblem;
import com.adobe.flash.compiler.problems.DuplicateClassDefinitionProblem;
import com.adobe.flash.compiler.problems.DynamicNotOnClassProblem;
import com.adobe.flash.compiler.problems.FinalOutsideClassProblem;
import com.adobe.flash.compiler.problems.ForwardReferenceToBaseClassProblem;
import com.adobe.flash.compiler.problems.FunctionNotMarkedOverrideProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.IncompatibleOverrideProblem;
import com.adobe.flash.compiler.problems.InvalidOverrideProblem;
import com.adobe.flash.compiler.problems.MultipleContructorDefinitionsProblem;
import com.adobe.flash.compiler.problems.NativeVariableProblem;
import com.adobe.flash.compiler.problems.OverrideFinalProblem;
import com.adobe.flash.compiler.problems.OverrideNotFoundProblem;
import com.adobe.flash.compiler.problems.StaticAndOverrideProblem;
import com.adobe.flash.compiler.problems.StaticNamespaceDefinitionProblem;
import com.adobe.flash.compiler.problems.VirtualOutsideClassProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.ICommonClassNode;
import com.adobe.flash.compiler.tree.as.IDefinitionNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.ILanguageIdentifierNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class ClassDirectiveProcessor
extends DirectiveProcessor {
    ClassDefinition classDefinition;
    LexicalScope classScope;
    LexicalScope classStaticScope;
    Name className;
    Name superclassName;
    ITraitsVisitor itraits;
    ITraitsVisitor ctraits;
    IClassVisitor cv;
    ClassInfo cinfo = new ClassInfo();
    InstanceInfo iinfo = new InstanceInfo();
    IASNode definitionSource;
    InstructionList cinitInsns = new InstructionList();
    InstructionList iinitInsns = new InstructionList();
    FunctionNode ctorFunction = null;
    IABCVisitor emitter;
    protected final Collection<VariableNode> staticVariableInitializers = new ArrayList<VariableNode>();
    private static final boolean GENERATE_STATIC_INITIALIZER = true;

    ClassDirectiveProcessor(ClassNode c, LexicalScope enclosing_scope, IABCVisitor emitter) {
        this(c, c.getDefinition(), enclosing_scope, emitter);
    }

    ClassDirectiveProcessor(ICommonClassNode node, ClassDefinition class_definition, LexicalScope enclosing_scope, IABCVisitor emitter) {
        super(enclosing_scope.getProblems());
        int i;
        int superClassOffset;
        int classOffset;
        this.emitter = emitter;
        this.definitionSource = node;
        assert (this.definitionSource != null) : "Class definition AST must be provided.";
        this.classScope = enclosing_scope.pushFrame();
        this.classStaticScope = enclosing_scope.pushFrame();
        if (node.getNodeID() == ASTNodeID.ClassID) {
            this.classScope.setInitialControlFlowRegionNode(((ClassNode)node).getScopedNode());
            this.classStaticScope.setInitialControlFlowRegionNode(((ClassNode)node).getScopedNode());
        }
        ICompilerProject project = this.classScope.getProject();
        this.classDefinition = class_definition;
        this.iinfo.name = this.className = this.classDefinition.getMName(project);
        switch (SemanticUtils.getMultiDefinitionType(this.classDefinition, project)) {
            case AMBIGUOUS: {
                this.classScope.addProblem(new DuplicateClassDefinitionProblem(node, class_definition.getBaseName()));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (node instanceof BaseDefinitionNode) {
            BaseDefinitionNode n = (BaseDefinitionNode)((Object)node);
            SemanticUtils.checkScopedToDefaultNamespaceProblem(this.classScope, n, this.classDefinition, null);
        }
        ClassDefinition superclassDefinition = SemanticUtils.resolveBaseClass(node, class_definition, project, this.classScope.getProblems());
        if (!this.classDefinition.isGeneratedEmbedClass() && this.classDefinition.getContainingFilePath().equals(superclassDefinition.getContainingFilePath()) && (classOffset = this.classDefinition.getAbsoluteStart()) < (superClassOffset = superclassDefinition.getAbsoluteEnd())) {
            this.classScope.addProblem(new ForwardReferenceToBaseClassProblem(node, superclassDefinition.getQualifiedName()));
        }
        this.iinfo.superName = this.superclassName = superclassDefinition.getMName(project);
        InterfaceDefinition[] interfaces = this.classDefinition.resolveImplementedInterfaces(project, this.classScope.getProblems());
        int n_interfaces = interfaces.length;
        ArrayList<Name> interface_names = new ArrayList<Name>(n_interfaces);
        for (int i2 = 0; i2 < n_interfaces; ++i2) {
            InterfaceDefinition idef = interfaces[i2];
            if (idef == null) continue;
            Name interfaceName = interfaces[i2].getMName(project);
            interface_names.add(interfaceName);
        }
        this.iinfo.interfaceNames = interface_names.toArray(new Name[interface_names.size()]);
        if (this.classDefinition.isFinal()) {
            this.iinfo.flags |= 2;
        }
        if (!this.classDefinition.isDynamic()) {
            this.iinfo.flags |= 1;
        }
        this.iinfo.protectedNs = ((NamespaceDefinition)((Object)this.classDefinition.getProtectedNamespaceReference())).getAETNamespace();
        this.cv = emitter.visitClass(this.iinfo, this.cinfo);
        this.cv.visit();
        this.itraits = this.cv.visitInstanceTraits();
        this.ctraits = this.cv.visitClassTraits();
        this.classScope.traitsVisitor = this.itraits;
        this.classStaticScope.traitsVisitor = this.ctraits;
        ArrayList<Name> ancestorClassNames = new ArrayList<Name>();
        boolean needsProtected = false;
        ClassDefinition c = null;
        IClassDefinition.IClassIterator classIterator = this.classDefinition.classIterator(project, true);
        while (classIterator.hasNext()) {
            c = (ClassDefinition)classIterator.next();
            needsProtected |= c.getOwnNeedsProtected();
            if (c == this.classDefinition) continue;
            ancestorClassNames.add(c.getMName(project));
        }
        if (classIterator.foundLoop()) {
            this.classScope.addProblem(new CircularTypeReferenceProblem(c, c.getQualifiedName()));
        }
        if (ancestorClassNames.isEmpty()) {
            ClassDefinition objectDefinition = (ClassDefinition)project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT);
            ancestorClassNames.add(objectDefinition.getMName(project));
        }
        if (needsProtected) {
            this.iinfo.flags |= 8;
        }
        InstructionList initInstructions = this.classScope.getInitInstructions();
        initInstructions.addInstruction(101, 0);
        for (i = ancestorClassNames.size() - 1; i >= 0; --i) {
            Name ancestorClassName = (Name)ancestorClassNames.get(i);
            initInstructions.addInstruction(96, ancestorClassName);
            if (i == 0) {
                initInstructions.addInstruction(42);
            }
            initInstructions.addInstruction(48);
        }
        initInstructions.addInstruction(88, this.cinfo);
        for (i = 0; i < ancestorClassNames.size(); ++i) {
            initInstructions.addInstruction(29);
        }
        initInstructions.addInstruction(104, this.className);
        this.implementedInterfaceSemanticChecks(class_definition);
        this.processResourceBundles(class_definition, project, this.classScope.getProblems());
    }

    protected void processResourceBundles(IClassDefinition class_definition, ICompilerProject project, Collection<ICompilerProblem> problems) {
        IMetaTag[] rbs = class_definition.getMetaTagsByName("ResourceBundle");
        if (rbs != null) {
            for (IMetaTag meta : rbs) {
                if (!(meta instanceof ResourceBundleMetaTag)) continue;
                try {
                    ((ResourceBundleMetaTag)meta).resolveDependencies(problems, project);
                }
                catch (InterruptedException ie) {
                    throw new CodegenInterruptedException(ie);
                }
            }
        }
    }

    void finishClassDefinition() {
        if (!this.staticVariableInitializers.isEmpty()) {
            InstructionList exisitingCinitInsns = null;
            if (!this.cinitInsns.isEmpty()) {
                exisitingCinitInsns = new InstructionList();
                exisitingCinitInsns.addAll(this.cinitInsns);
                this.cinitInsns = new InstructionList();
            }
            for (VariableNode var : this.staticVariableInitializers) {
                this.generateInstructions(var, true);
            }
            if (exisitingCinitInsns != null) {
                this.cinitInsns.addAll(exisitingCinitInsns);
            }
        }
        ITraitVisitor tv = this.classScope.getGlobalScope().traitsVisitor.visitClassTrait(4, this.className, 0, this.cinfo);
        IMetaInfo[] metaTags = this.classScope.getGlobalScope().getAllMetaTags(this.classDefinition);
        if (this.ctorFunction != null && !this.classDefinition.isPrivate()) {
            FunctionDefinition ctorDef = this.ctorFunction.getDefinition();
            MetaTag metaTag = MetaTag.createGotoDefinitionHelp(this.classDefinition, this.classDefinition.getContainingFilePath(), Integer.toString(ctorDef.getNameStart()), true);
            if (metaTag != null) {
                metaTags = MetaTag.addMetaTag(metaTags, metaTag);
            }
        }
        this.classScope.processMetadata(tv, metaTags);
        tv.visitEnd();
        this.generateBindableImpl();
        this.generateRequiredContingentDefinitions();
        this.addAnyEmbeddedAsset();
        this.classScope.callVisitEnds();
        this.classStaticScope.callVisitEnds();
        if (this.ctorFunction != null) {
            MethodInfo mi = this.classScope.getGenerator().generateFunction(this.ctorFunction, this.classScope, this.iinitInsns);
            if (mi != null) {
                this.iinfo.iInit = mi;
            }
        } else if (!this.iinitInsns.isEmpty()) {
            this.iinfo.iInit = new MethodInfo();
            MethodBodyInfo iinit = new MethodBodyInfo();
            iinit.setMethodInfo(this.iinfo.iInit);
            IMethodVisitor mv = this.emitter.visitMethod(this.iinfo.iInit);
            mv.visit();
            IMethodBodyVisitor mbv = mv.visitBody(iinit);
            InstructionList ctor_insns = new InstructionList();
            ctor_insns.addInstruction(208);
            ctor_insns.addInstruction(48);
            ctor_insns.addAll(this.iinitInsns);
            ctor_insns.addInstruction(208);
            ctor_insns.addInstruction(73, 0);
            ctor_insns.addInstruction(71);
            mbv.visit();
            mbv.visitInstructionList(ctor_insns);
            mbv.visitEnd();
            mv.visitEnd();
        }
        if (!this.cinitInsns.isEmpty()) {
            InstructionList cinit_insns = new InstructionList();
            cinit_insns.addInstruction(208);
            cinit_insns.addInstruction(48);
            this.classStaticScope.finishClassStaticInitializer(this.cinitInsns);
            cinit_insns.addAll(this.cinitInsns);
            cinit_insns.addInstruction(71);
            this.classStaticScope.methodBodyVisitor.visitInstructionList(cinit_insns);
            this.classStaticScope.methodBodyVisitor.visitEnd();
            this.classStaticScope.methodVisitor.visitEnd();
        } else assert (this.classStaticScope.methodBodyVisitor == null);
        this.itraits.visitEnd();
        this.ctraits.visitEnd();
        this.cv.visitEnd();
    }

    @Override
    public void declareBindableVariable(VariableNode varNode) {
        this.generateInstructions(varNode, varNode.getDefinition().isStatic());
    }

    public LexicalScope getInstanceScope() {
        return this.classScope;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDefinition;
    }

    protected void generateBindableImpl() {
        if (this.classDefinition.needsEventDispatcher(this.classScope.getProject())) {
            this.iinitInsns.addAll(BindableHelper.generateBindingEventDispatcherInit(this.itraits, false));
            BindableHelper.generateAddEventListener(this.classScope);
            BindableHelper.generateDispatchEvent(this.classScope);
            BindableHelper.generateHasEventListener(this.classScope);
            BindableHelper.generateRemoveEventListener(this.classScope);
            BindableHelper.generateWillTrigger(this.classScope);
        }
        if (this.classDefinition.needsStaticEventDispatcher(this.classScope.getProject())) {
            this.cinitInsns.addAll(BindableHelper.generateBindingEventDispatcherInit(this.ctraits, true));
            BindableHelper.generateStaticEventDispatcherGetter(this.classStaticScope);
        }
    }

    protected void generateRequiredContingentDefinitions() {
        List<IDefinition> definitons = this.classDefinition.getContingentDefinitions();
        for (IDefinition definition : definitons) {
            if (!definition.isContingentNeeded(this.classScope.getProject())) continue;
            assert (definition instanceof VariableDefinition) : "The code generator only supports contigent variable definitions";
            IDefinitionNode node = definition.getNode();
            this.declareVariable((VariableNode)node, (VariableDefinition)definition, definition.isStatic(), definition instanceof IConstantDefinition, LexicalScope.noInitializer);
        }
    }

    private void addAnyEmbeddedAsset() {
        ICompilerProject project = this.classScope.getProject();
        if (!(project instanceof CompilerProject)) {
            return;
        }
        EmbedData embedData = this.classDefinition.getEmbeddedAsset((CompilerProject)project, this.classScope.getProblems());
        if (embedData != null) {
            this.classScope.getGlobalScope().getEmbeds().add(embedData);
        }
    }

    @Override
    void declareFunction(FunctionNode func) {
        func.parseFunctionBody(this.classScope.getProblems());
        FunctionDefinition funcDef = func.getDefinition();
        boolean is_constructor = func.isConstructor();
        this.functionSemanticChecks(func);
        if (is_constructor) {
            if (this.ctorFunction == null) {
                this.ctorFunction = func;
            } else {
                String name = this.className.getBaseName();
                this.classScope.addProblem(new MultipleContructorDefinitionsProblem(func, name));
            }
        } else {
            LexicalScope ls = funcDef.isStatic() ? this.classStaticScope : this.classScope;
            MethodInfo mi = this.classScope.getGenerator().generateFunction(func, ls, null);
            if (mi != null) {
                Name funcName = funcDef.getMName(this.classScope.getProject());
                ITraitVisitor tv = ls.traitsVisitor.visitMethodTrait(ClassDirectiveProcessor.functionTraitKind(func, 1), funcName, 0, mi);
                if (funcName != null) {
                    this.classScope.getMethodBodySemanticChecker().checkFunctionForConflictingDefinitions(func, funcDef);
                }
                if (!funcDef.isStatic() && funcDef.getNamespaceReference() instanceof INamespaceDefinition.IProtectedNamespaceDefinition) {
                    this.iinfo.flags |= 8;
                }
                ls.processMetadata(tv, ls.getAllMetaTags(funcDef));
                if (func.hasModifier(ASModifier.FINAL)) {
                    tv.visitAttribute("final", Boolean.TRUE);
                }
                if (func.hasModifier(ASModifier.OVERRIDE)) {
                    tv.visitAttribute("override", Boolean.TRUE);
                }
                tv.visitEnd();
            }
        }
    }

    void functionSemanticChecks(FunctionNode node) {
        this.verifyFunctionModifiers(node);
        FunctionDefinition func = node.getDefinition();
        Collection<ICompilerProblem> problems = this.classScope.getProblems();
        boolean looks_like_ctor = func.isConstructor();
        if (!(looks_like_ctor |= func.getBaseName() != null && this.className != null && func.getBaseName().equals(this.className.getBaseName())) && func.getBaseName() != null) {
            SemanticUtils.checkScopedToDefaultNamespaceProblem(this.classScope, node, func, this.classDefinition.getQualifiedName());
        }
        if (looks_like_ctor) {
            IExpressionNode returnTypeExpression;
            if (node.getActualNamespaceNode() != null && node.getActualNamespaceNode().getName() != "public") {
                problems.add(new ConstructorMustBePublicProblem(node.getActualNamespaceNode()));
            }
            if (func.isStatic()) {
                problems.add(new ConstructorIsStaticProblem(node));
            }
            if ((returnTypeExpression = node.getReturnTypeNode()) != null) {
                ILanguageIdentifierNode.LanguageIdentifierKind kind;
                boolean returnTypeIsVoid = false;
                if (returnTypeExpression instanceof ILanguageIdentifierNode && (kind = ((ILanguageIdentifierNode)((Object)returnTypeExpression)).getKind()) == ILanguageIdentifierNode.LanguageIdentifierKind.VOID) {
                    returnTypeIsVoid = true;
                }
                if (!returnTypeIsVoid) {
                    ConstructorCannotHaveReturnTypeProblem problem = new ConstructorCannotHaveReturnTypeProblem(returnTypeExpression);
                    problems.add(problem);
                }
            }
            if (func instanceof IAccessorDefinition) {
                problems.add(new ConstructorIsGetterSetterProblem(node.getNameExpressionNode()));
            }
        } else if (!func.isStatic()) {
            FunctionDefinition override = func.resolveOverriddenFunction(this.classScope.getProject());
            if (func.isOverride()) {
                if (override == null) {
                    problems.add(new OverrideNotFoundProblem(node.getNameExpressionNode()));
                } else {
                    if (!func.hasCompatibleSignature(override, this.classScope.getProject())) {
                        problems.add(new IncompatibleOverrideProblem(node.getNameExpressionNode()));
                    }
                    if (override.isFinal()) {
                        problems.add(new OverrideFinalProblem(node.getNameExpressionNode()));
                    }
                }
            } else if (override != null) {
                problems.add(new FunctionNotMarkedOverrideProblem(node.getNameExpressionNode()));
            }
        }
    }

    void implementedInterfaceSemanticChecks(ClassDefinition cls) {
        Iterator<IInterfaceDefinition> it = cls.interfaceIterator(this.classScope.getProject());
        while (it.hasNext()) {
            IInterfaceDefinition interf = it.next();
            if (!(interf instanceof InterfaceDefinition)) continue;
            ((InterfaceDefinition)interf).validateClassImplementsAllMethods(this.classScope.getProject(), cls, this.classScope.getProblems());
        }
    }

    protected void verifyFunctionModifiers(FunctionNode f) {
        ModifiersSet modifiersSet = f.getModifiers();
        if (modifiersSet == null) {
            return;
        }
        IExpressionNode site = f.getNameExpressionNode();
        if (modifiersSet.hasModifier(ASModifier.STATIC)) {
            if (modifiersSet.hasModifier(ASModifier.FINAL)) {
                this.classScope.addProblem(new FinalOutsideClassProblem(site));
            }
            if (modifiersSet.hasModifier(ASModifier.OVERRIDE)) {
                this.classScope.addProblem(new StaticAndOverrideProblem(site));
            }
            if (modifiersSet.hasModifier(ASModifier.DYNAMIC)) {
                this.classScope.addProblem(new DynamicNotOnClassProblem(site));
            }
            if (modifiersSet.hasModifier(ASModifier.VIRTUAL)) {
                this.classScope.addProblem(new VirtualOutsideClassProblem(site));
            }
        }
        this.classScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(f);
    }

    protected void verifyVariableModifiers(VariableNode v) {
        ModifiersSet modifiersSet = v.getModifiers();
        if (modifiersSet == null) {
            return;
        }
        ASModifier[] modifiers = modifiersSet.getAllModifiers();
        IExpressionNode site = v.getNameExpressionNode();
        for (ASModifier modifier : modifiers) {
            if (modifier == ASModifier.NATIVE) {
                this.classScope.addProblem(new NativeVariableProblem(site));
                continue;
            }
            if (modifier == ASModifier.DYNAMIC) {
                this.classScope.addProblem(new DynamicNotOnClassProblem(site));
                continue;
            }
            if (modifier == ASModifier.FINAL) {
                this.classScope.addProblem(new FinalOutsideClassProblem(site));
                continue;
            }
            if (modifier == ASModifier.OVERRIDE) {
                this.classScope.addProblem(new InvalidOverrideProblem(site));
                continue;
            }
            if (modifier != ASModifier.VIRTUAL) continue;
            this.classScope.addProblem(new VirtualOutsideClassProblem(site));
        }
        this.classScope.getMethodBodySemanticChecker().checkForDuplicateModifiers(v);
    }

    @Override
    void declareVariable(VariableNode var) {
        Collection<ICompilerProblem> problems;
        this.verifyVariableModifiers(var);
        VariableDefinition varDef = (VariableDefinition)var.getDefinition();
        boolean is_static = var.hasModifier(ASModifier.STATIC);
        boolean is_const = SemanticUtils.isConst(var, this.classScope.getProject());
        ICompilerProject project = this.classScope.getProject();
        ICodeGenerator codeGenerator = this.classScope.getGenerator();
        ExpressionNodeBase assignedValueNode = var.getAssignedValueNode();
        ICodeGenerator.IConstantValue constantValue = codeGenerator.generateConstantValue(assignedValueNode, project);
        Object initializer = constantValue != null ? constantValue.getValue() : null;
        Collection<ICompilerProblem> collection = problems = constantValue != null ? constantValue.getProblems() : null;
        if (problems != null) {
            this.classScope.addProblems(problems);
        }
        MethodBodySemanticChecker checker = new MethodBodySemanticChecker(this.classScope);
        TypeDefinitionBase varType = varDef.resolveType(project);
        Object transformed_initializer = null;
        transformed_initializer = initializer != null && varType != null ? checker.checkInitialValue(var, new Binding(null, varType.getMName(this.classScope.getProject()), varType), new PooledValue(initializer)).getValue() : initializer;
        ITraitVisitor tv = this.declareVariable(var, varDef, is_static, is_const, transformed_initializer);
        if (is_static) {
            this.classStaticScope.processMetadata(tv, this.classStaticScope.getAllMetaTags(varDef));
        } else {
            this.classScope.processMetadata(tv, this.classScope.getAllMetaTags(varDef));
        }
        tv.visitEnd();
        if (transformed_initializer == null && var.getAssignedValueNode() != null) {
            if (is_static) {
                this.staticVariableInitializers.add(var);
            } else {
                this.generateInstructions(var, false);
            }
        } else {
            checker.checkClassField(var, is_static);
            for (int i = 0; i < var.getChildCount(); ++i) {
                IASNode candidate = var.getChild(i);
                if (!(candidate instanceof VariableNode)) continue;
                this.declareVariable((VariableNode)candidate);
            }
        }
    }

    ITraitVisitor declareVariable(VariableNode varNode, DefinitionBase varDef, boolean is_static, boolean is_const, Object initializer) {
        ICompilerProject project = this.classScope.getProject();
        Name var_name = varDef.getMName(project);
        TypeDefinitionBase typeDef = varDef.resolveType(project);
        Name var_type = typeDef != null ? typeDef.getMName(project) : null;
        int trait_kind = is_const ? 6 : 0;
        LexicalScope ls = is_static ? this.classStaticScope : this.classScope;
        ls.declareVariableName(var_name);
        ITraitVisitor tv = ls.traitsVisitor.visitSlotTrait(trait_kind, var_name, 0, var_type, initializer);
        if (!is_static && varDef.getNamespaceReference() instanceof INamespaceDefinition.IProtectedNamespaceDefinition) {
            this.iinfo.flags |= 8;
        }
        SemanticUtils.checkScopedToDefaultNamespaceProblem(this.classScope, varNode, varDef, this.className.getBaseName());
        return tv;
    }

    @Override
    void processNamespaceIdentifierDirective(NamespaceIdentifierNode ns) {
        super.traverse(ns);
    }

    @Override
    void processImportDirective(ImportNode imp) {
        this.classScope.getGenerator().generateInstructions(imp, 25, this.classScope);
    }

    @Override
    void processDirective(IASNode n) {
        switch (n.getNodeID()) {
            case StaticID: 
            case FinalID: 
            case OverrideID: {
                break;
            }
            case NamespaceID: {
                NamespaceNode ns = (NamespaceNode)n;
                if (ns.hasModifier(ASModifier.STATIC)) {
                    this.classScope.addProblem(new StaticNamespaceDefinitionProblem(ns));
                    break;
                }
                this.generateInstructions(n, true);
                break;
            }
            default: {
                this.generateInstructions(n, true);
            }
        }
    }

    private void generateInstructions(IASNode node, boolean isStatic) {
        boolean createNewCinit;
        boolean bl = createNewCinit = isStatic && this.cinfo.cInit == null;
        if (createNewCinit) {
            this.cinfo.cInit = new MethodInfo();
            MethodBodyInfo cinit_info = new MethodBodyInfo();
            cinit_info.setMethodInfo(this.cinfo.cInit);
            this.classStaticScope.setMethodInfo(this.cinfo.cInit);
            this.classStaticScope.methodVisitor = this.emitter.visitMethod(this.cinfo.cInit);
            this.classStaticScope.methodVisitor.visit();
            this.classStaticScope.methodBodyVisitor = this.classStaticScope.methodVisitor.visitBody(cinit_info);
            this.classStaticScope.methodBodyVisitor.visit();
        }
        InstructionList cgResult = null;
        LexicalScope ls = isStatic ? this.classStaticScope : this.classScope;
        ls.resetDebugInfo();
        cgResult = ls.getGenerator().generateInstructions(node, 25, ls);
        if ((cgResult == null || cgResult.isEmpty()) && createNewCinit) {
            this.cinfo.cInit = null;
            this.classStaticScope.resetMethodInfo();
            this.classStaticScope.methodVisitor = null;
            this.classStaticScope.methodBodyVisitor = null;
        }
        if (cgResult != null) {
            if (isStatic) {
                this.cinitInsns.addAll(cgResult);
            } else {
                this.iinitInsns.addAll(cgResult);
            }
        }
    }
}

