/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.as.codegen;

import com.adobe.flash.abc.semantics.Instruction;
import com.adobe.flash.abc.semantics.InstructionFactory;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.tree.as.IASNode;

public class Binding {
    private final IASNode node;
    private final SharedBindingInfo sharedBindingInfo;

    public Binding() {
        this(null, null, null);
    }

    public Binding(IASNode node, Name name, IDefinition def) {
        this.node = node;
        this.sharedBindingInfo = new SharedBindingInfo(name, def);
    }

    public Binding(IASNode node, Binding other) {
        this.node = node;
        this.sharedBindingInfo = other.sharedBindingInfo;
    }

    public Name getName() {
        return this.sharedBindingInfo.getName();
    }

    public IASNode getNode() {
        return this.node;
    }

    public IDefinition getDefinition() {
        return this.sharedBindingInfo.getDefinition();
    }

    public boolean isLocal() {
        return this.sharedBindingInfo.isLocal();
    }

    public void setIsLocal(boolean is_local) {
        this.sharedBindingInfo.setIsLocal(is_local);
    }

    public boolean localNumberIsSet() {
        return this.sharedBindingInfo.localNumberIsSet();
    }

    public int getLocalRegister() {
        return this.sharedBindingInfo.getLocalRegister();
    }

    void setLocalRegister(int local_num) {
        this.sharedBindingInfo.setLocalRegister(local_num);
    }

    public Instruction getlocal() {
        return this.sharedBindingInfo.getlocal();
    }

    public Instruction setlocal() {
        return this.sharedBindingInfo.setlocal();
    }

    public Instruction inclocal() {
        return this.sharedBindingInfo.inclocal();
    }

    public Instruction inclocal_i() {
        return this.sharedBindingInfo.inclocal_i();
    }

    public Instruction declocal() {
        return this.sharedBindingInfo.declocal();
    }

    public Instruction declocal_i() {
        return this.sharedBindingInfo.declocal_i();
    }

    public int getSlotId() {
        return this.sharedBindingInfo.getSlotId();
    }

    public boolean slotIdIsSet() {
        return this.sharedBindingInfo.slotIdIsSet();
    }

    public void setSlotId(int slotId) {
        this.sharedBindingInfo.setSlotId(slotId);
    }

    public Instruction kill() {
        return this.sharedBindingInfo.kill();
    }

    public String toString() {
        return this.sharedBindingInfo.toString();
    }

    public void setSuperQualified(boolean super_qualified) {
        this.sharedBindingInfo.setSuperQualified(super_qualified);
    }

    public boolean isSuperQualified() {
        return this.sharedBindingInfo.isSuperQualified();
    }

    public static class SharedBindingInfo {
        private final Name name;
        private final IDefinition definition;
        private boolean isLocalDef;
        private Integer localNumber;
        private int slotId = 0;
        private Instruction getlocalIns = null;
        private Instruction setlocalIns = null;
        private Instruction inclocalIns = null;
        private Instruction inclocaliIns = null;
        private Instruction declocalIns = null;
        private Instruction declocaliIns = null;
        private Instruction killIns = null;
        private boolean superQualified = false;

        public SharedBindingInfo(Name n, IDefinition d) {
            this.name = n;
            this.definition = d;
        }

        private Name getName() {
            return this.name;
        }

        private IDefinition getDefinition() {
            return this.definition;
        }

        private boolean isLocal() {
            return this.isLocalDef;
        }

        private void setIsLocal(boolean is_local) {
            this.isLocalDef = is_local;
        }

        private boolean localNumberIsSet() {
            return this.localNumber != null;
        }

        private int getLocalRegister() {
            assert (this.isLocalDef) : "not a local Binding:" + this;
            assert (this.localNumber != null) : "local register number no set:" + this;
            return this.localNumber;
        }

        private void setLocalRegister(int local_num) {
            assert (this.isLocalDef) : "not a local Binding:" + this;
            assert (this.localNumber == null) : "local already set:" + this;
            this.localNumber = local_num;
            if (this.getlocalIns != null) {
                this.getlocalIns.setImmediate(local_num);
            }
            if (this.setlocalIns != null) {
                this.setlocalIns.setImmediate(local_num);
            }
            if (this.inclocalIns != null) {
                this.inclocalIns.setImmediate(local_num);
            }
            if (this.inclocaliIns != null) {
                this.inclocaliIns.setImmediate(local_num);
            }
            if (this.declocalIns != null) {
                this.declocalIns.setImmediate(local_num);
            }
            if (this.declocaliIns != null) {
                this.declocaliIns.setImmediate(local_num);
            }
            if (this.killIns != null) {
                this.killIns.setImmediate(local_num);
            }
        }

        private Instruction getlocal() {
            assert (this.isLocalDef) : "not a local Binding:" + this;
            if (this.getlocalIns == null) {
                this.getlocalIns = InstructionFactory.getDeferredImmediateInstruction(98);
                if (this.localNumber != null) {
                    this.getlocalIns.setImmediate(this.localNumber);
                }
            }
            return this.getlocalIns;
        }

        private Instruction setlocal() {
            assert (this.isLocalDef) : "not a local Binding:" + this;
            if (this.setlocalIns == null) {
                this.setlocalIns = InstructionFactory.getDeferredImmediateInstruction(99);
                if (this.localNumber != null) {
                    this.setlocalIns.setImmediate(this.localNumber);
                }
            }
            return this.setlocalIns;
        }

        private Instruction inclocal() {
            assert (this.isLocalDef) : "not a local Binding:" + this;
            if (this.inclocalIns == null) {
                this.inclocalIns = InstructionFactory.getDeferredImmediateInstruction(146);
                if (this.localNumber != null) {
                    this.inclocalIns.setImmediate(this.localNumber);
                }
            }
            return this.inclocalIns;
        }

        private Instruction inclocal_i() {
            assert (this.isLocalDef) : "not a local Binding:" + this;
            if (this.inclocaliIns == null) {
                this.inclocaliIns = InstructionFactory.getDeferredImmediateInstruction(194);
                if (this.localNumber != null) {
                    this.inclocaliIns.setImmediate(this.localNumber);
                }
            }
            return this.inclocaliIns;
        }

        private Instruction declocal() {
            assert (this.isLocalDef) : "not a local Binding:" + this;
            if (this.declocalIns == null) {
                this.declocalIns = InstructionFactory.getDeferredImmediateInstruction(148);
                if (this.localNumber != null) {
                    this.declocalIns.setImmediate(this.localNumber);
                }
            }
            return this.declocalIns;
        }

        private Instruction declocal_i() {
            assert (this.isLocalDef) : "not a local Binding:" + this;
            if (this.declocaliIns == null) {
                this.declocaliIns = InstructionFactory.getDeferredImmediateInstruction(195);
                if (this.localNumber != null) {
                    this.declocaliIns.setImmediate(this.localNumber);
                }
            }
            return this.declocaliIns;
        }

        private int getSlotId() {
            return this.slotId;
        }

        private void setSlotId(int slotId) {
            assert (slotId != 0) : "setSlotId should only be used manually allocated slot ids";
            this.slotId = slotId;
        }

        private boolean slotIdIsSet() {
            return this.slotId != 0;
        }

        private Instruction kill() {
            assert (this.isLocalDef) : "not a local Binding:" + this;
            if (this.killIns == null) {
                this.killIns = InstructionFactory.getDeferredImmediateInstruction(8);
                if (this.localNumber != null) {
                    this.killIns.setImmediate(this.localNumber);
                }
            }
            return this.killIns;
        }

        private void setSuperQualified(boolean super_qualified) {
            this.superQualified = super_qualified;
        }

        private boolean isSuperQualified() {
            return this.superQualified;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Binding { name:");
            result.append(this.getName() != null ? this.getName() : "-null-");
            result.append(" def:");
            result.append(this.getDefinition() != null ? this.getDefinition() : "-null-");
            result.append(" local:");
            result.append(this.localNumber != null ? this.localNumber : "--");
            result.append("}");
            return result.toString();
        }
    }
}

