/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.abc;

import com.adobe.flash.abc.semantics.ClassInfo;
import com.adobe.flash.abc.semantics.MethodInfo;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.Nsset;
import com.adobe.flash.abc.semantics.PooledValue;
import com.adobe.flash.abc.semantics.Traits;
import com.adobe.flash.abc.visitors.ITraitVisitor;
import com.adobe.flash.abc.visitors.ITraitsVisitor;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.abc.ABCScopeBuilder;
import com.adobe.flash.compiler.internal.abc.CollectMetadataTraitVisitor;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.ConstantDefinition;
import com.adobe.flash.compiler.internal.definitions.DefinitionBase;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.definitions.GetterDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.definitions.ParameterDefinition;
import com.adobe.flash.compiler.internal.definitions.SetterDefinition;
import com.adobe.flash.compiler.internal.definitions.TypeDefinitionBase;
import com.adobe.flash.compiler.internal.definitions.VariableDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.FunctionScope;
import com.adobe.flash.compiler.scopes.IASScope;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Vector;

public class ScopedDefinitionTraitsVisitor
implements ITraitsVisitor {
    private static final IReference TYPE_ANY = ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.ANY_TYPE);
    private static final IReference TYPE_FUNCTION = ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.FUNCTION);
    private final ASScope scope;
    private final boolean isStatic;
    private final ABCScopeBuilder scopeBuilder;
    private final INamespaceReference interfNamespace;

    public ScopedDefinitionTraitsVisitor(ABCScopeBuilder owner, IASScope scope, boolean isStatic) {
        this(owner, scope, isStatic, null);
    }

    public ScopedDefinitionTraitsVisitor(ABCScopeBuilder owner, IASScope scope, boolean isStatic, INamespaceReference interfNamespace) {
        assert (scope instanceof ASScope);
        this.scopeBuilder = owner;
        this.scope = (ASScope)scope;
        this.isStatic = isStatic;
        this.interfNamespace = interfNamespace;
    }

    @Override
    public ITraitVisitor visitSlotTrait(int kind, Name name, int slot_id, Name slot_type, Object slot_value) {
        DefinitionBase def;
        String definitionName = ScopedDefinitionTraitsVisitor.getDefinitionName(name);
        switch (kind &= 0xF) {
            case 0: {
                def = new VariableDefinition(definitionName, slot_value);
                break;
            }
            case 6: {
                if (slot_value instanceof Namespace) {
                    def = NamespaceDefinition.createNamespaceDefinition(definitionName, (Namespace)slot_value);
                    break;
                }
                def = new ConstantDefinition(definitionName, slot_value);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid slot kind: " + kind);
            }
        }
        INamespaceReference namespaceReference = this.getNamespaceReference(name);
        def.setNamespaceReference(namespaceReference);
        if (this.isStatic) {
            def.setStatic();
        }
        def.setTypeReference(slot_type == null ? TYPE_ANY : this.scopeBuilder.getReference(slot_type));
        this.scope.addDefinition(def);
        return new CollectMetadataTraitVisitor(def);
    }

    @Override
    public ITraitVisitor visitMethodTrait(int kind, Name name, int disp_id, MethodInfo method) {
        FunctionDefinition methodDef;
        String definitionName = ScopedDefinitionTraitsVisitor.getDefinitionName(name);
        switch (kind &= 0xF) {
            case 1: {
                methodDef = new FunctionDefinition(definitionName);
                break;
            }
            case 2: {
                methodDef = new GetterDefinition(definitionName);
                break;
            }
            case 3: {
                methodDef = new SetterDefinition(definitionName);
                break;
            }
            case 5: {
                methodDef = new FunctionDefinition(definitionName);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid method kind:" + kind);
            }
        }
        INamespaceReference namespaceReference = this.getNamespaceReference(name);
        methodDef.setNamespaceReference(namespaceReference);
        int paramTypesSize = method.getParamTypes().size();
        ParameterDefinition[] params = new ParameterDefinition[paramTypesSize + (method.needsRest() ? 1 : 0)];
        if (params.length > 0) {
            FunctionScope methodScope = new FunctionScope(this.scope);
            methodScope.setContainingDefinition(methodDef);
            methodDef.setContainedScope(methodScope);
            Vector<PooledValue> defaultValues = method.getDefaultValues();
            int firstOptionalParam = paramTypesSize - defaultValues.size();
            for (int i = 0; i < paramTypesSize; ++i) {
                Name paramType = method.getParamTypes().get(i);
                String paramName = i < method.getParamNames().size() ? method.getParamNames().get(i) : "";
                params[i] = new ParameterDefinition(paramName);
                params[i].setTypeReference(paramType == null ? TYPE_ANY : this.scopeBuilder.getReference(paramType));
                if (i >= firstOptionalParam) {
                    Object defaultValue = defaultValues.get(i - firstOptionalParam).getValue();
                    params[i].setDefaultValue(defaultValue);
                }
                methodScope.addDefinition(params[i]);
            }
            if (method.needsRest()) {
                ParameterDefinition rest = new ParameterDefinition("");
                rest.setRest();
                rest.setTypeReference(ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.ARRAY));
                params[paramTypesSize] = rest;
            }
        }
        methodDef.setParameters(params);
        Name returnType = method.getReturnType();
        methodDef.setReturnTypeReference(returnType == null ? TYPE_ANY : this.scopeBuilder.getReference(returnType));
        switch (kind) {
            case 2: {
                methodDef.setTypeReference(methodDef.getReturnTypeReference());
                break;
            }
            case 3: {
                methodDef.setTypeReference(methodDef.getParameters()[0].getTypeReference());
                break;
            }
            case 1: 
            case 5: {
                methodDef.setTypeReference(TYPE_FUNCTION);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid method kind:" + kind);
            }
        }
        if (this.isStatic) {
            methodDef.setStatic();
        }
        this.scope.addDefinition(methodDef);
        if (kind == 5 || kind == 1) {
            methodDef.setIntrinsic(kind);
        }
        return new CollectMetadataTraitVisitor(methodDef);
    }

    @Override
    public ITraitVisitor visitClassTrait(int kind, Name name, int slot_id, ClassInfo clazz) {
        TypeDefinitionBase classDef = this.scopeBuilder.classDefinitions.get(clazz);
        assert (classDef != null) : "Null class def at #" + slot_id;
        this.scope.addDefinition(classDef);
        classDef.getContainedScope().setContainingScope(this.scope);
        if (classDef instanceof ClassDefinition) {
            FunctionDefinition ctor = (FunctionDefinition)((ClassDefinition)classDef).getConstructor();
            classDef.getContainedScope().addDefinition(ctor);
            ParameterDefinition[] params = ctor.getParameters();
            if (params.length > 0) {
                FunctionScope ctorScope = new FunctionScope(this.scope);
                ctorScope.setContainingDefinition(ctor);
                ctor.setContainedScope(ctorScope);
                for (ParameterDefinition param : params) {
                    ctorScope.addDefinition(param);
                }
            }
            ((ClassDefinition)classDef).setIntrinsic();
        }
        return new CollectMetadataTraitVisitor(classDef);
    }

    private static boolean legalDefinitionNsset(Nsset nsSet) {
        if (nsSet == null) {
            return false;
        }
        if (nsSet.length() == 1) {
            return true;
        }
        return Iterables.all((Iterable)nsSet, (Predicate)new Predicate<Namespace>(){

            public boolean apply(Namespace ns) {
                return ns.getApiVersion() != -1;
            }
        });
    }

    public static String getDefinitionName(Name name) {
        String baseName = name.getBaseName();
        Nsset nsSet = name.getQualifiers();
        if (!ScopedDefinitionTraitsVisitor.legalDefinitionNsset(nsSet)) {
            throw new IllegalStateException("Definition " + baseName + " can have only one qualifier or all qualifiers should be versioned namespaces");
        }
        return baseName;
    }

    private INamespaceReference getNamespaceReference(Name name) {
        Namespace namespace = (Namespace)Iterables.getFirst((Iterable)name.getQualifiers(), null);
        assert (namespace != null);
        INamespaceReference namespaceReference = (INamespaceReference)((Object)this.scopeBuilder.getNamespaceReferenceForNamespace(namespace));
        if (this.interfNamespace != null && this.interfNamespace.equals(namespaceReference)) {
            namespaceReference = this.interfNamespace;
        }
        return namespaceReference;
    }

    @Override
    public void visit() {
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public Traits getTraits() {
        return null;
    }
}

