/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.abc;

import com.adobe.flash.abc.ABCParser;
import com.adobe.flash.abc.semantics.ClassInfo;
import com.adobe.flash.abc.semantics.InstanceInfo;
import com.adobe.flash.abc.semantics.MethodInfo;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.Nsset;
import com.adobe.flash.abc.semantics.PooledValue;
import com.adobe.flash.abc.visitors.IClassVisitor;
import com.adobe.flash.abc.visitors.IMethodVisitor;
import com.adobe.flash.abc.visitors.IScriptVisitor;
import com.adobe.flash.abc.visitors.NilABCVisitor;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.abc.ScopedDefinitionTraitsVisitor;
import com.adobe.flash.compiler.internal.abc.ScriptDefinitionBuilder;
import com.adobe.flash.compiler.internal.abc.TypeDefinitionBuilder;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.DefinitionBase;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.definitions.InterfaceDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.definitions.ParameterDefinition;
import com.adobe.flash.compiler.internal.definitions.TypeDefinitionBase;
import com.adobe.flash.compiler.internal.scopes.ASFileScope;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.scopes.IFileScopeProvider;
import com.adobe.flash.compiler.workspaces.IWorkspace;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ABCScopeBuilder
extends NilABCVisitor {
    private static final IReference TYPE_ANY = ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.ANY_TYPE);
    private static final IReference TYPE_FUNCTION = ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.FUNCTION);
    private final IFileScopeProvider fileScopeProvider;
    private final ABCParser abcParser;
    private final List<IASScope> scopes;
    protected final Map<ClassInfo, TypeDefinitionBase> classDefinitions;
    private final Map<Namespace, INamespaceDefinition> namespacesMap;
    private final Map<Name, IReference> nameMap;
    private final IWorkspace workspace;
    protected final String path;

    IReference getReference(Name name) {
        if (name == null) {
            return null;
        }
        IReference ref = this.nameMap.get(name);
        if (ref != null) {
            return ref;
        }
        switch (name.getKind()) {
            case 7: {
                INamespaceDefinition ns = this.getNamespaceReferenceForNamespace(name.getSingleQualifier());
                ref = ReferenceFactory.resolvedQualifierQualifiedReference(this.workspace, ns, name.getBaseName());
                break;
            }
            case 9: {
                Nsset set = name.getQualifiers();
                if (set.length() != 1) {
                    HashSet<INamespaceDefinition> ns_set = new HashSet<INamespaceDefinition>(set.length());
                    for (Namespace n : set) {
                        ns_set.add(this.getNamespaceReferenceForNamespace(n));
                    }
                    ref = ReferenceFactory.multinameReference(this.workspace, ns_set, name.getBaseName());
                    break;
                }
                INamespaceDefinition singleNS = this.getNamespaceReferenceForNamespace(name.getSingleQualifier());
                ref = ReferenceFactory.resolvedQualifierQualifiedReference(this.workspace, singleNS, name.getBaseName());
                break;
            }
            case 29: {
                assert (name.getTypeNameBase().getBaseName().equals("Vector")) : "Vector is currently the only supported parameterized type!";
                IReference parameterizedTypeReference = this.getReference(name.getTypeNameBase());
                IReference parameterTypeReference = this.getReference(name.getTypeNameParameter());
                ref = ReferenceFactory.parameterizedReference(this.workspace, parameterizedTypeReference, parameterTypeReference);
                break;
            }
            default: {
                assert (false) : "Unsupported multiname type: " + name.getKind();
                break;
            }
        }
        this.nameMap.put(name, ref);
        return ref;
    }

    static String getQName(Name name) {
        String packageName;
        String baseName;
        block2: {
            if (name == null) {
                return null;
            }
            baseName = name.getBaseName();
            packageName = null;
            Nsset qualifiers = name.getQualifiers();
            if (qualifiers == null) break block2;
            for (Namespace namespace : qualifiers) {
                if ((namespace.getKind() == 22 || namespace.getKind() == 23) && (packageName = namespace.getName()).length() > 0) break;
            }
        }
        return packageName != null && packageName.length() > 0 ? packageName + '.' + baseName : baseName;
    }

    private IReference[] getReferences(Name[] names) {
        IReference[] refs = null;
        int n = names.length;
        if (n != 0) {
            refs = new IReference[n];
            for (int i = 0; i < n; ++i) {
                refs[i] = this.getReference(names[i]);
            }
        }
        return refs;
    }

    public ABCScopeBuilder(IWorkspace workspace, byte[] abcData, String path, IFileScopeProvider fileScopeProvider) {
        Preconditions.checkNotNull((Object)workspace, (Object)"Workspace can't be null.");
        Preconditions.checkNotNull((Object)abcData, (Object)"ABC data can't be null.");
        Preconditions.checkNotNull((Object)path, (Object)"File path can't be null.");
        Preconditions.checkNotNull((Object)fileScopeProvider, (Object)"File scope provider can't be null.");
        this.scopes = new ArrayList<IASScope>();
        this.classDefinitions = new HashMap<ClassInfo, TypeDefinitionBase>();
        this.abcParser = new ABCParser(abcData);
        this.namespacesMap = new HashMap<Namespace, INamespaceDefinition>();
        this.nameMap = new HashMap<Name, IReference>();
        this.workspace = workspace;
        this.path = path;
        this.fileScopeProvider = fileScopeProvider;
    }

    public INamespaceDefinition getNamespaceReferenceForNamespace(Namespace ns) {
        INamespaceDefinition result = this.namespacesMap.get(ns);
        if (result != null) {
            return result;
        }
        Namespace nonVersionedNS = ns.getApiVersion() == -1 ? ns : new Namespace(ns.getKind(), ns.getName());
        result = NamespaceDefinition.createNamespaceDefinition(nonVersionedNS);
        assert (result != null);
        this.namespacesMap.put(ns, result);
        return result;
    }

    public List<IASScope> build() throws IOException {
        this.abcParser.parseABC(this);
        return this.scopes;
    }

    @Override
    public IScriptVisitor visitScript() {
        ASFileScope fileScope = this.fileScopeProvider.createFileScope(this.workspace, this.path);
        assert (fileScope != null) : "IFileScopeProvider shouldn't create null objects.";
        this.scopes.add(fileScope);
        return new ScriptDefinitionBuilder(this, fileScope);
    }

    @Override
    public IClassVisitor visitClass(InstanceInfo iinfo, ClassInfo cinfo) {
        TypeDefinitionBase typeDefinition;
        boolean isInterface;
        boolean isSealed = (iinfo.flags & 1) != 0;
        boolean isFinal = (iinfo.flags & 2) != 0;
        boolean bl = isInterface = (iinfo.flags & 4) != 0;
        assert (iinfo.name.getKind() == 7);
        String typeName = iinfo.name.getBaseName();
        Namespace namespace = iinfo.name.getSingleQualifier();
        String namespaceName = namespace.getName();
        int namespaceKind = namespace.getKind();
        INamespaceReference namespaceRef = null;
        namespaceRef = namespaceName.length() != 0 && (namespaceKind == 22 || namespaceKind == 23) ? ((Workspace)this.workspace).getPackageNamespaceDefinitionCache().get(namespaceName, namespaceKind == 23) : NamespaceDefinition.createNamespaceDefinition(namespace);
        if (isInterface) {
            InterfaceDefinition interfaceDefinition = new InterfaceDefinition(typeName);
            IReference[] extendedInterfaces = this.getReferences(iinfo.interfaceNames);
            interfaceDefinition.setExtendedInterfaceReferences(extendedInterfaces);
            this.setupCastFunction(iinfo, interfaceDefinition);
            typeDefinition = interfaceDefinition;
        } else {
            String protectedNSURI;
            if (iinfo.hasProtectedNs()) {
                protectedNSURI = iinfo.protectedNs.getName();
            } else {
                String classNSURI = namespace.getName();
                protectedNSURI = (classNSURI.isEmpty() ? "" : classNSURI + ":") + typeName;
            }
            INamespaceDefinition.IProtectedNamespaceDefinition protectedNSDefinition = NamespaceDefinition.createProtectedNamespaceDefinition(protectedNSURI);
            ClassDefinition classDefinition = new ClassDefinition(typeName, namespaceRef, protectedNSDefinition);
            IReference baseClass = this.getReference(iinfo.superName);
            classDefinition.setBaseClassReference(baseClass);
            IReference[] implementedInterfaces = this.getReferences(iinfo.interfaceNames);
            classDefinition.setImplementedInterfaceReferences(implementedInterfaces);
            this.setupConstructor(iinfo, classDefinition);
            typeDefinition = classDefinition;
        }
        INamespaceDefinition namespaceReference = this.getNamespaceReferenceForNamespace(namespace);
        ((DefinitionBase)typeDefinition).setNamespaceReference((INamespaceReference)((Object)namespaceReference));
        if (!isSealed) {
            typeDefinition.setDynamic();
        }
        if (isFinal) {
            typeDefinition.setFinal();
        }
        TypeDefinitionBuilder visitor = new TypeDefinitionBuilder(this, typeDefinition);
        this.classDefinitions.put(cinfo, typeDefinition);
        return visitor;
    }

    @Override
    public IMethodVisitor visitMethod(MethodInfo minfo) {
        return null;
    }

    private void setupConstructor(InstanceInfo iinfo, ClassDefinition classDefinition) {
        String ctorName = ScopedDefinitionTraitsVisitor.getDefinitionName(iinfo.name);
        FunctionDefinition ctor = new FunctionDefinition(ctorName);
        ctor.setNamespaceReference(NamespaceDefinition.getCodeModelImplicitDefinitionNamespace());
        ctor.setTypeReference(TYPE_FUNCTION);
        ctor.setReturnTypeReference(null);
        MethodInfo mInfo = iinfo.iInit;
        int paramTypesSize = mInfo.getParamTypes().size();
        ParameterDefinition[] params = new ParameterDefinition[paramTypesSize + (mInfo.needsRest() ? 1 : 0)];
        if (params.length > 0) {
            Vector<PooledValue> defaultValues = mInfo.getDefaultValues();
            int firstOptionalParam = paramTypesSize - defaultValues.size();
            for (int i = 0; i < paramTypesSize; ++i) {
                Name paramType = mInfo.getParamTypes().get(i);
                String paramName = i < mInfo.getParamNames().size() ? mInfo.getParamNames().get(i) : "";
                params[i] = new ParameterDefinition(paramName);
                params[i].setTypeReference(paramType == null ? TYPE_ANY : this.getReference(paramType));
                if (i < firstOptionalParam) continue;
                Object defaultValue = defaultValues.get(i - firstOptionalParam).getValue();
                params[i].setDefaultValue(defaultValue);
            }
            if (mInfo.needsRest()) {
                ParameterDefinition rest = new ParameterDefinition("");
                rest.setRest();
                rest.setTypeReference(ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.ARRAY));
                params[paramTypesSize] = rest;
            }
        }
        ctor.setParameters(params);
        ctor.setAsConstructor(classDefinition);
        ctor.setImplicit();
    }

    private void setupCastFunction(InstanceInfo iinfo, InterfaceDefinition interfaceDefinition) {
        String castName = ScopedDefinitionTraitsVisitor.getDefinitionName(iinfo.name);
        FunctionDefinition castFunc = new FunctionDefinition(castName);
        castFunc.setNamespaceReference(NamespaceDefinition.getCodeModelImplicitDefinitionNamespace());
        castFunc.setReturnTypeReference(ReferenceFactory.resolvedReference(interfaceDefinition));
        castFunc.setCastFunction();
        castFunc.setImplicit();
    }
}

