/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.fxg;

public final class FXGVersion {
    private static final double k_1_0 = 1.0;
    private static final double k_2_0 = 2.0;
    public static final FXGVersion v1_0 = new FXGVersion(1.0);
    public static final FXGVersion v2_0 = new FXGVersion(2.0);
    private final double version;

    private FXGVersion(double version) throws FXGVersionException {
        if (Double.isNaN(version) || version < 1.0) {
            throw new FXGVersionException(String.valueOf(version));
        }
        this.version = version;
    }

    public static FXGVersion newInstance(double version) throws FXGVersionException {
        return new FXGVersion(version);
    }

    public String asString() {
        return String.valueOf(this.version);
    }

    public boolean equalTo(FXGVersion version) {
        return this.compareTo(version) == 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FXGVersion)) {
            return false;
        }
        return this.equalTo((FXGVersion)object);
    }

    public int hashCode() {
        return Long.valueOf(Double.doubleToLongBits(this.version)).hashCode();
    }

    public boolean greaterThan(FXGVersion version) {
        return this.compareTo(version) > 0;
    }

    private int compareTo(FXGVersion version) {
        double compareVersion;
        if (version == null) {
            throw new RuntimeException("Cannot compare FXGVersion to a null value.");
        }
        if (version == this) {
            return 0;
        }
        double thisVersion = this.asDouble();
        if (thisVersion < (compareVersion = version.asDouble())) {
            return -1;
        }
        if (thisVersion > compareVersion) {
            return 1;
        }
        return 0;
    }

    public double asDouble() {
        return this.version;
    }

    public long getMajorVersion() {
        return (long)this.version;
    }

    public class FXGVersionException
    extends RuntimeException {
        private static final long serialVersionUID = 9034248618973261847L;
        private final String version;

        public FXGVersionException(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

