/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.config;

import com.adobe.flash.compiler.config.ApplicationDomainTarget;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class RSLSettings {
    private static final String SIGNED_RSL_URL_EXTENSION = "swz";
    private static final String SIGNED_RSL_URL_DOT_EXTENSION = ".swz";
    private File libraryFile;
    private List<RSLAndPolicyFileURLPair> rslURLs;
    private ApplicationDomainTarget applicationDomain;
    private boolean verifyDigest;
    private boolean forceLoad;

    public static boolean isSignedRSL(String url) {
        if (url == null) {
            return false;
        }
        return url.endsWith(SIGNED_RSL_URL_DOT_EXTENSION);
    }

    RSLSettings(IFileSpecification libraryFile) {
        if (libraryFile == null) {
            throw new NullPointerException("libraryFile may not be null");
        }
        this.libraryFile = new File(libraryFile.getPath());
        this.rslURLs = new ArrayList<RSLAndPolicyFileURLPair>();
        this.setApplicationDomain(ApplicationDomainTarget.DEFAULT);
        this.setVerifyDigest(true);
    }

    public RSLSettings(File libraryFile) {
        if (libraryFile == null) {
            throw new NullPointerException("libraryFile may not be null");
        }
        this.libraryFile = libraryFile;
        this.rslURLs = new ArrayList<RSLAndPolicyFileURLPair>();
        this.setApplicationDomain(ApplicationDomainTarget.DEFAULT);
        this.setVerifyDigest(true);
    }

    public boolean isForceLoad() {
        return this.forceLoad;
    }

    public void setForceLoad(boolean forceLoad) {
        this.forceLoad = forceLoad;
    }

    public List<RSLAndPolicyFileURLPair> getRSLURLs() {
        return this.rslURLs;
    }

    public void addRSLURLAndPolicyFileURL(String rslURL, String policyFileURL) {
        if (rslURL == null) {
            throw new NullPointerException("rslURL may not be null");
        }
        this.rslURLs.add(new RSLAndPolicyFileURLPair(rslURL, policyFileURL));
    }

    public File getLibraryFile() {
        return this.libraryFile;
    }

    public void setApplicationDomain(ApplicationDomainTarget applicationDomain) {
        this.applicationDomain = applicationDomain;
    }

    public ApplicationDomainTarget getApplicationDomain() {
        return this.applicationDomain;
    }

    public void setVerifyDigest(boolean verifyDigest) {
        this.verifyDigest = verifyDigest;
    }

    public boolean getVerifyDigest() {
        return this.verifyDigest;
    }

    public static class RSLAndPolicyFileURLPair {
        private String rslURL;
        private String policyFileURL;

        public RSLAndPolicyFileURLPair(String rslURL, String policyFileURL) {
            this.rslURL = rslURL;
            this.policyFileURL = policyFileURL;
        }

        public String getRSLURL() {
            return this.rslURL;
        }

        public String getPolicyFileURL() {
            return this.policyFileURL;
        }
    }
}

