/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.config;

import com.adobe.flash.compiler.common.IPathResolver;
import com.adobe.flash.compiler.common.VersionInfo;
import com.adobe.flash.compiler.config.ApplicationDomainTarget;
import com.adobe.flash.compiler.config.ConfigurationBuffer;
import com.adobe.flash.compiler.config.ConfigurationInfo;
import com.adobe.flash.compiler.config.ConfigurationValue;
import com.adobe.flash.compiler.exceptions.ConfigurationException;
import com.adobe.flash.compiler.filespecs.FileSpecification;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.config.FileConfigurator;
import com.adobe.flash.compiler.internal.config.FrameInfo;
import com.adobe.flash.compiler.internal.config.LoadExternsParser;
import com.adobe.flash.compiler.internal.config.QNameNormalization;
import com.adobe.flash.compiler.internal.config.RSLArgumentNameGenerator;
import com.adobe.flash.compiler.internal.config.RuntimeSharedLibraryPathInfo;
import com.adobe.flash.compiler.internal.config.annotations.ArgumentNameGenerator;
import com.adobe.flash.compiler.internal.config.annotations.Arguments;
import com.adobe.flash.compiler.internal.config.annotations.Config;
import com.adobe.flash.compiler.internal.config.annotations.DefaultArgumentValue;
import com.adobe.flash.compiler.internal.config.annotations.DeprecatedConfig;
import com.adobe.flash.compiler.internal.config.annotations.FlexOnly;
import com.adobe.flash.compiler.internal.config.annotations.InfiniteArguments;
import com.adobe.flash.compiler.internal.config.annotations.Mapping;
import com.adobe.flash.compiler.internal.config.annotations.SoftPrerequisites;
import com.adobe.flash.compiler.internal.config.localization.LocalizationManager;
import com.adobe.flash.compiler.mxml.MXMLNamespaceMapping;
import com.adobe.flash.compiler.problems.ConfigurationProblem;
import com.adobe.flash.compiler.problems.DeprecatedConfigurationOptionProblem;
import com.adobe.flash.compiler.problems.FlexOnlyConfigurationOptionNotSupported;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.RemovedConfigurationOptionProblem;
import com.adobe.flash.swc.catalog.XMLFormatter;
import com.adobe.flash.utils.FileUtils;
import com.adobe.flash.utils.FilenameNormalization;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class Configuration {
    private static final int DEFAULT_HEIGHT_MAX = 4096;
    private static final int DEFAULT_HEIGHT_MIN = 1;
    private static final int DEFAULT_WIDTH_MAX = 4096;
    private static final int DEFAULT_WIDTH_MIN = 1;
    public static final String DEFAULT_OUTPUT_DIRECTORY_TOKEN = "com.adobe.flex.default.output.directory";
    public static final String SWC_AIRGLOBAL = "airglobal.swc";
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    private static final List<String> compcOnlyOptions = new ArrayList<String>(9);
    private static Map<String, String> aliases;
    private IPathResolver pathResolver;
    private String mainDefinition;
    private boolean enableAdvancedTelemetry = false;
    private String telemetryPassword;
    private String debugPassword;
    private int backgroundColor = 5272190;
    private int frameRate = 24;
    private int scriptLimit = 60;
    private int scriptRecursionLimit = 1000;
    private boolean scriptLimitsSet = false;
    private int defaultWidth = 500;
    private int defaultHeight = 375;
    private final Set<String> externs = new LinkedHashSet<String>();
    private final Set<String> includes = new LinkedHashSet<String>();
    private String linkReportFileName = null;
    private String sizeReportFileName = null;
    private String metadata = null;
    private static final String RDF_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String DC_URI = "http://purl.org/dc/elements/1.1";
    private String rbListFileName = null;
    private List<String> includeResourceBundles = new ArrayList<String>();
    private List<String> rslList = new LinkedList<String>();
    private boolean useNetwork = true;
    private List<RuntimeSharedLibraryPathInfo> rslPathInfoList;
    private boolean staticLinkRsl = true;
    private String staticLinkRslSource;
    private boolean verifyDigests = true;
    private boolean removeUnusedRSLs = false;
    private boolean includeInheritanceDependenciesOnly = false;
    private int majorVersionTarget = 11;
    private int minorVersionTarget = 1;
    private int revisionTarget = 0;
    public static final int TARGET_PLAYER_MAJOR_VERSION_MIN = 10;
    public static final int TARGET_PLAYER_MINOR_VERSION_MIN = 1;
    private static final Map<String, Integer> targetPlayerToSWFVersionMap;
    private final int UNSET_SWF_VERSION = -1;
    private final int DEFAULT_SWF_VERSION = 14;
    private final int MINIMUM_SWF_VERSION = 10;
    private int swfVersion = -1;
    private boolean useDirectBlit = true;
    private boolean useGpu = true;
    private Locale toolsLocale = null;
    private boolean accessible = false;
    private String actionscriptFileEncoding = null;
    private boolean adjustOpDebugLine = true;
    private boolean allowSourcePathOverlap = false;
    private Map<String, String> configVars;
    private boolean useConservativeAlgorithm = false;
    private String contextRoot = null;
    private boolean generateDebugTags = false;
    private String defaultsCssUrl;
    private boolean doc = false;
    private final List<String> externalLibraryPath = new ArrayList<String>();
    private boolean compilingForAIR = false;
    private String generatedDir = null;
    private boolean headlessServer;
    private final List<String> includeLibraries = new ArrayList<String>();
    private boolean keepAllTypeSelectors;
    private Set<String> as3metadata = null;
    private boolean enableRuntimeDesignLayers = true;
    private boolean enableSwcVersionFiltering = true;
    private final List<String> libraryPath = new ArrayList<String>();
    private boolean reportMissingCompilerLibraries = true;
    private final List<String> locales = new ArrayList<String>();
    private boolean metadataExport;
    private boolean omitTraceStatements = true;
    private boolean optimize = false;
    private String preloader = null;
    private File servicesConfigFile;
    private boolean ascWarnings;
    private boolean showBindingWarnings = true;
    private boolean showDependencyWarnings = false;
    private boolean reportInvalidStylesAsWarnings = false;
    private boolean reportMissingRequiredSkinPartsAsWarnings = false;
    private boolean showInvalidCSSPropertyWarnings = true;
    private boolean showDeprecationWarnings = false;
    private boolean showUnusedTypeSelectorWarnings = true;
    private boolean showMultipleDefinitionWarnings = true;
    private final List<String> unexpandedSourcePath = new ArrayList<String>();
    private final List<String> sourcePath = new ArrayList<String>();
    private ConfigurationValue sourcePathContext = null;
    private boolean strict;
    private boolean suppressWarningsInIncremental = false;
    private List<String> themeFiles = null;
    private Deque<String> defaultsCSSFiles = new ArrayDeque<String>();
    private List<IFileSpecification> themeCssFiles = new LinkedList<IFileSpecification>();
    private boolean verboseStacktraces;
    private boolean warn_array_tostring_changes = false;
    private boolean warn_assignment_within_conditional = true;
    private boolean warn_bad_array_cast = true;
    private boolean warn_bad_bool_assignment = true;
    private boolean warn_bad_date_cast = true;
    private boolean warn_bad_es3_type_method = true;
    private boolean warn_bad_es3_type_prop = true;
    private boolean warn_bad_nan_comparison = true;
    private boolean warn_bad_null_assignment = true;
    private boolean warn_bad_null_comparison = true;
    private boolean warn_bad_undefined_comparison = true;
    private boolean warn_boolean_constructor_with_no_args = false;
    private boolean warn_changes_in_resolve = false;
    private boolean warn_class_is_sealed = true;
    private boolean warn_const_not_initialized = true;
    private boolean warn_constructor_returns_value = false;
    private boolean warn_deprecated_event_handler_error = false;
    private boolean warn_deprecated_function_error = true;
    private boolean warn_deprecated_property_error = true;
    private boolean warn_duplicate_argument_names = true;
    private boolean warn_duplicate_variable_def = true;
    private boolean warn_for_var_in_changes = false;
    private boolean warn_import_hides_class = true;
    private boolean warn_instance_of_changes = true;
    private boolean warn_internal_error = true;
    private boolean warn_level_not_supported = true;
    private boolean warn_missing_namespace_decl = true;
    private boolean warn_negative_uint_literal = true;
    private boolean warn_no_constructor = false;
    private boolean warn_no_explicit_super_call_in_constructor = false;
    private boolean warn_no_type_decl = true;
    private boolean warn_number_from_string_changes = false;
    private boolean warn_scoping_change_in_this = false;
    private boolean warn_slow_text_field_addition = true;
    private boolean warn_unlikely_function_value = true;
    private boolean warn_xml_class_has_changed = false;
    private boolean generateAbstractSyntaxTree = true;
    private boolean isolateStyles = true;
    private boolean useCompression = true;
    private static final String LOCALE_TOKEN = "{locale}";
    private static final String TARGET_PLAYER_MAJOR_VERSION_TOKEN = "{targetPlayerMajorVersion}";
    private static final String TARGET_PLAYER_MINOR_VERSION_TOKEN = "{targetPlayerMinorVersion}";
    private static final String TARGET_PLAYER_MAJOR_VERSION_TOKEN_REGEX_ESCAPED;
    private static final String TARGET_PLAYER_MINOR_VERSION_TOKEN_REGEX_ESCAPED;
    public static final String STRICT = "compiler.strict";
    public static final String AS3 = "compiler.as3";
    public static final String ES = "compiler.es";
    private Map<String, String> localeDependentSources = new HashMap<String, String>();
    private List<MXMLNamespaceMapping> manifestMappings;
    private final Set<String> contributors = new TreeSet<String>();
    private final Set<String> creators = new TreeSet<String>();
    public String date = null;
    private final Map<String, String> localizedDescriptions = new LinkedHashMap<String, String>();
    public final Set<String> langs = new TreeSet<String>();
    private final Set<String> publishers = new TreeSet<String>();
    private final Map<String, String> localizedTitles = new LinkedHashMap<String, String>();
    private Set<String> forceRsls;
    private HashMap<String, ApplicationDomainTarget> applicationDomains;
    public static final int MXML_VERSION_4_6 = 0x4060000;
    public static final int MXML_VERSION_4_5 = 0x4050000;
    public static final int MXML_VERSION_4_0 = 0x4000000;
    public static final int MXML_VERSION_3_0 = 0x3000000;
    public static final int MXML_VERSION_2_0_1 = 0x2000001;
    public static final int MXML_VERSION_2_0 = 0x2000000;
    public static final int MXML_CURRENT_VERSION = 0x4060000;
    public static final int MXML_EARLIEST_MAJOR_VERSION = 3;
    public static final int MXML_LATEST_MAJOR_VERSION = 4;
    public static final int MXML_LATEST_MINOR_VERSION = 6;
    private int mxml_major = 4;
    private int mxml_minor = 6;
    private int mxml_revision;
    private int mxmlMinMajor = 3;
    private int mxmlMinMinor;
    private int mxmlMinRevision;
    private boolean isMinimumSupportedVersionConfigured = false;
    private boolean mobile = false;
    private List<FrameInfo> frameList = new LinkedList<FrameInfo>();
    private boolean as3 = true;
    private boolean es = false;
    private boolean outputSwcAsDirectory = false;
    private final List<String> includeClasses = new ArrayList<String>();
    public final Map<String, String> includeFilesNamePath = new LinkedHashMap<String, String>();
    private boolean includeLookupOnly = false;
    private final List<String> includeNamespaces = new ArrayList<String>();
    private final List<String> includeSources = new ArrayList<String>();
    private final List<String> includeStyleSheets = new ArrayList<String>();
    private File dependencyGraphOutput;
    private String output;
    private String dumpConfigFile = null;
    private boolean warnings = true;
    private Collection<Class<ICompilerProblem>> errorClasses;
    private Collection<Class<ICompilerProblem>> warningClasses;
    private Collection<Class<ICompilerProblem>> ignoreClasses;
    private boolean legacyMessageFormat = true;
    private boolean createTargetWithErrors = false;
    private boolean isFlex = false;
    private List<String> fileSpecs = new ArrayList<String>();
    private String configFile = null;
    private boolean verbose = false;
    private boolean dumpAst;
    private boolean enableInlining = false;
    private boolean removeDeadCode = false;
    private Collection<ICompilerProblem> configurationProblems = new ArrayList<ICompilerProblem>();
    private boolean warnOnFlexOnlyOptionUsage = false;

    public void validate(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        this.processDeprecatedAndRemovedOptions(configurationBuffer);
        this.validateDumpConfig(configurationBuffer);
    }

    public static void validateNoCompcOnlyOptions(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        for (String option : compcOnlyOptions) {
            List<ConfigurationValue> values = configurationBuffer.getVar(option);
            if (values == null || values.size() <= 0) continue;
            throw new ConfigurationException.UnknownVariable(values.get(0).getVar(), values.get(0).getSource(), values.get(0).getLine());
        }
    }

    protected String getOutputPath(ConfigurationValue cv, String fileName) {
        File file;
        String result = fileName;
        if (fileName != null && !FileUtils.isAbsolute(file = new File(fileName))) {
            String directory = cv.getBuffer().getToken(DEFAULT_OUTPUT_DIRECTORY_TOKEN);
            if (directory == null) {
                directory = cv.getContext();
            }
            if (directory != null) {
                result = FileUtils.addPathComponents(directory, fileName, File.separatorChar);
            }
        }
        return this.pathResolver.resolve(result).getAbsolutePath();
    }

    public static Map<String, String> getAliases() {
        if (aliases == null) {
            aliases = new HashMap<String, String>();
            aliases.put("l", "compiler.library-path");
            aliases.put("el", "compiler.external-library-path");
            aliases.put("sp", "compiler.source-path");
            aliases.put("rsl", "runtime-shared-libraries");
            aliases.put("keep", "compiler.keep-generated-actionscript");
            aliases.put("o", "output");
            aliases.put("rslp", "runtime-shared-library-path");
            aliases.put("static-rsls", "static-link-runtime-shared-libraries");
        }
        return aliases;
    }

    public void setPathResolver(IPathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    public String getMainDefinition() {
        return this.mainDefinition;
    }

    public void setMainDefinition(String mainDefinition) {
        assert (mainDefinition != null) : "main definition can't be null";
        assert (!"".equals(mainDefinition)) : "main definition can't be empty";
        this.mainDefinition = mainDefinition;
    }

    public boolean isAdvancedTelemetryEnabled() {
        return this.enableAdvancedTelemetry;
    }

    @Config
    @Mapping(value={"advanced-telemetry"})
    public void setEnableAdvancedTelemetry(ConfigurationValue cv, boolean enableAdvancedTelemetry) {
        this.enableAdvancedTelemetry = enableAdvancedTelemetry;
    }

    public String getAdvancedTelemetryPassword() {
        return this.telemetryPassword;
    }

    @Config(advanced=true)
    @Mapping(value={"advanced-telemetry-password"})
    public void setAdvancedTelemetryPassword(ConfigurationValue cv, String telemetryPassword) {
        this.telemetryPassword = telemetryPassword;
    }

    @Config(removed=true)
    @Mapping(value={"benchmark"})
    public void setBenchmark(ConfigurationValue cv, boolean b) {
    }

    public String getDebugPassword() {
        return this.debugPassword;
    }

    @Config(advanced=true)
    @Mapping(value={"debug-password"})
    @DefaultArgumentValue(value={""})
    public void setDebugPassword(ConfigurationValue cv, String debugPassword) {
        this.debugPassword = debugPassword;
    }

    public int getDefaultBackgroundColor() {
        return this.backgroundColor;
    }

    @Config(advanced=true)
    @Mapping(value={"default-background-color"})
    public void setDefaultBackgroundColor(ConfigurationValue cv, int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getDefaultFrameRate() {
        return this.frameRate;
    }

    @Config(advanced=true)
    @Mapping(value={"default-frame-rate"})
    public void setDefaultFrameRate(ConfigurationValue cv, int rate) throws ConfigurationException {
        if (rate <= 0) {
            throw new ConfigurationException.GreaterThanZero(cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.frameRate = rate;
    }

    public int getScriptTimeLimit() {
        return this.scriptLimit;
    }

    public int getScriptRecursionLimit() {
        return this.scriptRecursionLimit;
    }

    public boolean scriptLimitsSet() {
        return this.scriptLimitsSet;
    }

    @Config(advanced=true)
    @Mapping(value={"default-script-limits"})
    @Arguments(value={"max-recursion-depth", "max-execution-time"})
    public void setDefaultScriptLimits(ConfigurationValue cv, int scriptLimit, int scriptRecursionLimit) throws ConfigurationException {
        if (scriptLimit <= 0) {
            throw new ConfigurationException.GreaterThanZero(cv.getVar(), cv.getSource(), cv.getLine());
        }
        if (scriptRecursionLimit <= 0) {
            throw new ConfigurationException.GreaterThanZero(cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.scriptLimitsSet = true;
        this.scriptLimit = scriptRecursionLimit;
        this.scriptRecursionLimit = scriptLimit;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    @Config(advanced=true)
    @Arguments(value={"width", "height"})
    @Mapping(value={"default-size"})
    public void setDefaultSize(ConfigurationValue cv, int width, int height) throws ConfigurationException {
        if (width < 1 || width > 4096 || height < 1 || height > 4096) {
            throw new ConfigurationException.IllegalDimensions(width, height, cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.defaultWidth = width;
        this.defaultHeight = height;
    }

    public Set<String> getExterns() {
        return this.externs;
    }

    @Config(advanced=true, allowMultiple=true)
    @Mapping(value={"externs"})
    @Arguments(value={"symbol"})
    @InfiniteArguments
    public void setExterns(ConfigurationValue cfgval, List<String> vals) {
        this.externs.addAll(QNameNormalization.normalize(vals));
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    @Config(allowMultiple=true, advanced=true)
    @Mapping(value={"includes"})
    @Arguments(value={"symbol"})
    @InfiniteArguments
    public void setIncludes(ConfigurationValue cfgval, List<String> vals) {
        this.includes.addAll(QNameNormalization.normalize(vals));
    }

    @Config(allowMultiple=true, advanced=true, removed=true)
    @Mapping(value={"framework"})
    public void setFramework(ConfigurationValue cfgval, String value) {
    }

    public File getLinkReport() {
        return this.linkReportFileName != null ? new File(this.linkReportFileName) : null;
    }

    @Config(advanced=true)
    @Mapping(value={"link-report"})
    @Arguments(value={"filename"})
    public void setLinkReport(ConfigurationValue cv, String filename) {
        this.linkReportFileName = this.getOutputPath(cv, filename);
    }

    public File getSizeReport() {
        return this.sizeReportFileName != null ? new File(this.sizeReportFileName) : null;
    }

    @Config(advanced=true)
    @Mapping(value={"size-report"})
    @Arguments(value={"filename"})
    public void setSizeReport(ConfigurationValue cv, String filename) {
        this.sizeReportFileName = this.getOutputPath(cv, filename);
    }

    @Config(allowMultiple=true, advanced=true)
    @Mapping(value={"load-externs"})
    @Arguments(value={"filename"})
    public void setLoadExterns(ConfigurationValue cfgval, String filename) throws ConfigurationException {
        String path = this.resolvePathStrict(filename, cfgval);
        FileSpecification f = new FileSpecification(path);
        List<String> externsFromFile = LoadExternsParser.collectExterns(cfgval, f);
        this.externs.addAll(externsFromFile);
    }

    public String getRawMetadata() {
        if (this.metadata != null) {
            return this.metadata;
        }
        return this.generateMetadata();
    }

    private final String generateMetadata() {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        assert (xmlOutputFactory != null) : "Expect XMLOutputFactory implementation.";
        StringWriter stringWriter = new StringWriter();
        XMLFormatter xmlWriter = null;
        try {
            xmlWriter = new XMLFormatter(xmlOutputFactory.createXMLStreamWriter(stringWriter));
            xmlWriter.writeStartDocument();
            xmlWriter.writeStartElement("rdf", "RDF", RDF_URI);
            xmlWriter.setPrefix("rdf", RDF_URI);
            xmlWriter.writeNamespace("rdf", RDF_URI);
            xmlWriter.writeStartElement(RDF_URI, "Description");
            xmlWriter.setPrefix("dc", DC_URI);
            xmlWriter.setPrefix("asc", "http://ns.adobe.com/asc/2012");
            xmlWriter.writeNamespace("dc", DC_URI);
            xmlWriter.writeNamespace("asc", "http://ns.adobe.com/asc/2012");
            xmlWriter.writeStartElement(DC_URI, "format");
            xmlWriter.writeCharacters("application/x-shockwave-flash");
            xmlWriter.writeEndElement();
            if (this.isFlex()) {
                this.writeMap(xmlWriter, DC_URI, "description", this.localizedDescriptions);
                this.writeMap(xmlWriter, DC_URI, "title", this.localizedTitles);
                this.writeCollection(xmlWriter, DC_URI, "publisher", this.publishers);
                this.writeCollection(xmlWriter, DC_URI, "creator", this.creators);
                this.writeCollection(xmlWriter, DC_URI, "contributor", this.contributors);
                this.writeCollection(xmlWriter, DC_URI, "language", this.langs);
                this.writeDate(xmlWriter);
            }
            this.writeCompiledBy(xmlWriter);
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            return "";
        }
        return stringWriter.toString();
    }

    private void writeCompiledBy(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEmptyElement("http://ns.adobe.com/asc/2012", "compiler");
        writer.writeAttribute("name", VersionInfo.getCompilerName());
        writer.writeAttribute("version", VersionInfo.getCompilerVersion());
        writer.writeAttribute("build", VersionInfo.getCompilerBuild());
        writer.writeEndElement();
    }

    private void writeDate(XMLStreamWriter writer) throws XMLStreamException {
        if (this.date == null) {
            this.date = DateFormat.getDateInstance().format(new Date());
        }
        writer.writeStartElement(DC_URI, "date");
        writer.writeCharacters(this.date);
        writer.writeEndElement();
    }

    private void writeMap(XMLStreamWriter writer, String namespaceURI, String localName, Map<String, String> mapData) throws XMLStreamException {
        if (mapData.size() > 0) {
            writer.writeStartElement(namespaceURI, localName);
            if (mapData.size() == 1 && mapData.get("x-default") != null) {
                String data = mapData.get("x-default");
                writer.writeCharacters(data);
            } else {
                writer.writeStartElement(RDF_URI, "Alt");
                for (String key : mapData.keySet()) {
                    String value = mapData.get(key);
                    writer.writeStartElement(RDF_URI, "li");
                    writer.writeAttribute("xml", "", "lang", key);
                    writer.writeCharacters(value);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeCollection(XMLStreamWriter writer, String namespaceURI, String localName, Collection<String> values) throws XMLStreamException {
        if (values.isEmpty()) {
            return;
        }
        writer.writeStartElement(namespaceURI, localName);
        if (values.size() > 1) {
            writer.writeStartElement(RDF_URI, "Bag");
        }
        for (String value : values) {
            writer.writeCharacters(value);
        }
        if (values.size() > 1) {
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Config(advanced=true)
    @Mapping(value={"raw-metadata"})
    @Arguments(value={"text"})
    public void setRawMetadata(ConfigurationValue cv, String xml) throws ConfigurationException {
        if (this.metadata != null) {
            throw new ConfigurationException.BadMetadataCombo(cv.getVar(), cv.getSource(), cv.getLine());
        }
        this.metadata = xml;
    }

    public String getResourceBundleList() {
        return this.rbListFileName;
    }

    public List<String> getIncludeResourceBundles() {
        return this.includeResourceBundles;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"include-resource-bundles"})
    @Arguments(value={"bundle"})
    @FlexOnly
    public void setIncludeResourceBundles(ConfigurationValue cv, List<String> values) {
        this.includeResourceBundles.addAll(values);
    }

    @Config(advanced=true)
    @Mapping(value={"resource-bundle-list"})
    @Arguments(value={"filename"})
    @FlexOnly
    public void setResourceBundleList(ConfigurationValue cv, String filename) {
        this.rbListFileName = this.getOutputPath(cv, filename);
    }

    public List<String> getRuntimeSharedLibraries() {
        return this.rslList;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"runtime-shared-libraries"})
    @Arguments(value={"url"})
    @InfiniteArguments
    @FlexOnly
    public void setRuntimeSharedLibraries(ConfigurationValue cfgval, List<String> urls) throws ConfigurationException {
        this.rslList.addAll(urls);
    }

    public boolean getUseNetwork() {
        return this.useNetwork;
    }

    @Config
    @Mapping(value={"use-network"})
    public void setUseNetwork(ConfigurationValue cv, boolean b) {
        this.useNetwork = b;
    }

    public List<RuntimeSharedLibraryPathInfo> getRslPathInfo() {
        if (this.rslPathInfoList == null) {
            return Collections.emptyList();
        }
        return this.rslPathInfoList;
    }

    public List<File> getRslExcludedLibraries() {
        if (this.rslPathInfoList == null || this.getStaticLinkRsl()) {
            return Collections.emptyList();
        }
        return Lists.transform(this.rslPathInfoList, (Function)new Function<RuntimeSharedLibraryPathInfo, File>(){

            public File apply(RuntimeSharedLibraryPathInfo info) {
                return info.getSWCFile();
            }
        });
    }

    @Config(allowMultiple=true)
    @Mapping(value={"runtime-shared-library-path"})
    @SoftPrerequisites(value={"static-link-runtime-shared-libraries"})
    @ArgumentNameGenerator(value=RSLArgumentNameGenerator.class)
    @InfiniteArguments
    @FlexOnly
    public void setRuntimeSharedLibraryPath(ConfigurationValue cfgval, List<String> urls) throws ConfigurationException {
        if (urls.isEmpty()) {
            return;
        }
        if ("command line".equals(cfgval.getSource())) {
            this.setOverrideStaticLinkRsl(false);
        }
        if (this.getStaticLinkRsl()) {
            return;
        }
        if (urls.size() < 2) {
            throw new ConfigurationException.MissingArgument("rsl-url", "runtime-shared-library-path", cfgval.getSource(), cfgval.getLine());
        }
        RuntimeSharedLibraryPathInfo info = new RuntimeSharedLibraryPathInfo();
        String include = this.resolvePathStrict(urls.get(0), cfgval, true);
        info.setSWCPath(urls.get(0));
        info.setSWCFile(new File(include));
        for (int i = 1; i < urls.size(); ++i) {
            String url = urls.get(i);
            if ((i + 1) % 2 == 0) {
                if ("".equals(url.length())) {
                    throw new ConfigurationException.MissingArgument("rsl-url", "runtime-shared-library-path", cfgval.getSource(), cfgval.getLine());
                }
                info.addRSLURL(url);
                continue;
            }
            info.addPolicyFileURL(url);
        }
        if (urls.size() % 2 == 0) {
            info.addPolicyFileURL("");
        }
        if (this.rslPathInfoList == null) {
            this.rslPathInfoList = new ArrayList<RuntimeSharedLibraryPathInfo>();
        }
        this.rslPathInfoList.add(info);
    }

    public boolean getStaticLinkRsl() {
        return this.staticLinkRsl;
    }

    protected void setOverrideStaticLinkRsl(boolean staticLinkRsl) {
        if ("command line".equals(this.staticLinkRslSource)) {
            return;
        }
        this.staticLinkRsl = staticLinkRsl;
    }

    @Config
    @Mapping(value={"static-link-runtime-shared-libraries"})
    @FlexOnly
    public void setStaticLinkRuntimeSharedLibraries(ConfigurationValue cv, boolean b) {
        this.staticLinkRsl = b;
        this.staticLinkRslSource = cv.getSource();
    }

    public boolean getVerifyDigests() {
        return this.verifyDigests;
    }

    @Config(advanced=true)
    @FlexOnly
    public void setVerifyDigests(ConfigurationValue cv, boolean b) {
        this.verifyDigests = b;
    }

    public boolean getRemoveUnusedRsls() {
        return this.removeUnusedRSLs;
    }

    @Config(advanced=true)
    @FlexOnly
    public void setRemoveUnusedRsls(ConfigurationValue cv, boolean b) {
        this.removeUnusedRSLs = b;
    }

    public boolean getIncludeInheritanceDependenciesOnly() {
        return this.includeInheritanceDependenciesOnly;
    }

    @Config(advanced=true)
    public void setIncludeInheritanceDependenciesOnly(ConfigurationValue cv, boolean b) {
        this.includeInheritanceDependenciesOnly = b;
    }

    public int getTargetPlayerMajorVersion() {
        return this.majorVersionTarget;
    }

    public int getTargetPlayerMinorVersion() {
        return this.minorVersionTarget;
    }

    public int getTargetPlayerRevision() {
        return this.revisionTarget;
    }

    @Config
    @Arguments(value={"version"})
    public void setTargetPlayer(ConfigurationValue cv, String version) throws ConfigurationException {
        if (version == null || version.equals("")) {
            return;
        }
        String[] results = (String[])Iterables.toArray((Iterable)Splitter.on((String)".").omitEmptyStrings().trimResults().split((CharSequence)version), String.class);
        if (results.length < 1 || results.length > 3) {
            throw new ConfigurationException.BadVersion(version, "target-player");
        }
        String majorVersion = results[0];
        String minorVersion = results.length > 1 ? results[1] : "0";
        String revision = results.length > 2 ? results[2] : "0";
        try {
            this.majorVersionTarget = Integer.parseInt(majorVersion);
            this.minorVersionTarget = Integer.parseInt(minorVersion);
            this.revisionTarget = Integer.parseInt(revision);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException.BadVersion(version, "target-player");
        }
        if (this.majorVersionTarget < 10 || this.majorVersionTarget == 10 && this.minorVersionTarget < 1) {
            throw new ConfigurationException.BadVersion(version, "target-player");
        }
    }

    private static Map<String, Integer> getSwfVersionMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(10);
        map.put("10.0", 10);
        map.put("10.1", 10);
        map.put("10.2", 11);
        map.put("10.3", 12);
        map.put("11.0", 13);
        map.put("11.1", 14);
        map.put("11.2", 15);
        map.put("11.3", 16);
        map.put("11.4", 17);
        map.put("11.5", 18);
        map.put("11.6", 19);
        map.put("11.7", 20);
        map.put("11.8", 21);
        map.put("11.9", 22);
        map.put("12.0", 23);
        map.put("13.0", 24);
        map.put("14.0", 25);
        map.put("15.0", 26);
        map.put("16.0", 27);
        map.put("17.0", 28);
        return map;
    }

    private int lookupSwfVersion() {
        int swfVersion = 14;
        Integer lookupVersion = targetPlayerToSWFVersionMap.get(Integer.toString(this.getTargetPlayerMajorVersion()) + "." + Integer.toString(this.getTargetPlayerMinorVersion()));
        if (lookupVersion != null) {
            swfVersion = lookupVersion;
        }
        return swfVersion;
    }

    public int getSwfVersion() {
        if (this.swfVersion == -1) {
            this.swfVersion = this.lookupSwfVersion();
        }
        return this.swfVersion;
    }

    @Config
    @Mapping(value={"swf-version"})
    public void setSwfVersion(ConfigurationValue cv, int version) throws ConfigurationException {
        if (version < 10) {
            throw new ConfigurationException.BadVersion(Integer.toString(version), "swf-version");
        }
        this.swfVersion = version;
    }

    public boolean getUseDirectBlit() {
        return this.useDirectBlit;
    }

    @Config
    public void setUseDirectBlit(ConfigurationValue cv, boolean value) {
        this.useDirectBlit = value;
    }

    public boolean getUseGpu() {
        return this.useGpu;
    }

    @Config
    public void setUseGpu(ConfigurationValue cv, boolean value) {
        this.useGpu = value;
    }

    public Locale getToolsLocale() {
        return this.toolsLocale;
    }

    @Config
    @Mapping(value={"tools-locale"})
    public void setToolsLocale(ConfigurationValue cv, String toolsLocale) throws ConfigurationException {
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].toString().equals(toolsLocale)) continue;
            this.toolsLocale = locales[i];
            LocalizationManager.get().setLocale(locales[i]);
            return;
        }
        throw new ConfigurationException.ToolsLocaleNotAvailable(cv.getVar(), cv.getSource(), cv.getLine());
    }

    public boolean getCompilerAccessible() {
        return this.accessible;
    }

    @Config
    @Mapping(value={"compiler", "accessible"})
    @FlexOnly
    public void setCompilerAccessible(ConfigurationValue cv, boolean accessible) {
        this.accessible = accessible;
    }

    public String getCompilerActionscriptFileEncoding() {
        return this.actionscriptFileEncoding;
    }

    @Config
    @Mapping(value={"compiler", "actionscript-file-encoding"})
    public void setCompilerActionscriptFileEncoding(ConfigurationValue cv, String encoding) {
        this.actionscriptFileEncoding = encoding;
    }

    public boolean getAdjustOpDebugLine() {
        return this.adjustOpDebugLine;
    }

    @Config(advanced=true, hidden=true)
    public void setCompilerAdjustOpdebugline(ConfigurationValue cv, boolean b) {
        this.adjustOpDebugLine = b;
    }

    public boolean getAllowSourcePathOverlap() {
        return this.allowSourcePathOverlap;
    }

    @Config(advanced=true)
    public void setCompilerAllowSourcePathOverlap(ConfigurationValue cv, boolean b) {
        this.allowSourcePathOverlap = b;
    }

    public Map<String, String> getCompilerDefine() {
        return this.configVars;
    }

    @Config(advanced=true, allowMultiple=true)
    @Arguments(value={"name", "value"})
    public void setCompilerDefine(ConfigurationValue cv, String name, String value) throws ConfigurationException {
        if (this.configVars == null) {
            this.configVars = new LinkedHashMap<String, String>();
        }
        this.configVars.put(name, value);
    }

    public boolean useConservativeAlgorithm() {
        return this.useConservativeAlgorithm;
    }

    @Config(advanced=true, hidden=true)
    @Mapping(value={"compiler", "conservative"})
    public void setCompilerConservative(ConfigurationValue cv, boolean c) {
        this.useConservativeAlgorithm = c;
    }

    public String getCompilerContextRoot() {
        return this.contextRoot;
    }

    @Config
    @Mapping(value={"compiler", "context-root"})
    @Arguments(value={"context-path"})
    @FlexOnly
    public void setCompilerContextRoot(ConfigurationValue cv, String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public boolean isDebuggingEnabled() {
        return this.generateDebugTags;
    }

    protected void setDebug(boolean value) {
        this.generateDebugTags = value;
    }

    @Config
    @Mapping(value={"compiler", "debug"})
    public void setCompilerDebug(ConfigurationValue cv, boolean generateDebugTags) {
        this.generateDebugTags = generateDebugTags;
    }

    public String getCompilerDefaultsCssUrl() {
        return this.defaultsCssUrl;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "defaults-css-url"})
    @FlexOnly
    public void setCompilerDefaultsCssUrl(ConfigurationValue cv, String defaultsCssUrlPath) throws ConfigurationException.CannotOpen {
        this.defaultsCssUrl = this.resolvePathStrict(defaultsCssUrlPath, cv);
    }

    public boolean getCompilerDoc() {
        return this.doc;
    }

    @Config(advanced=true, hidden=true)
    @Mapping(value={"compiler", "doc"})
    public void setCompilerDoc(ConfigurationValue cv, boolean doc) {
        this.doc = doc;
    }

    public List<String> getCompilerExternalLibraryPath() {
        return this.externalLibraryPath;
    }

    public boolean getCompilingForAIR() {
        return this.compilingForAIR;
    }

    @Config(allowMultiple=true, isPath=true)
    @Mapping(value={"compiler", "external-library-path"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setCompilerExternalLibraryPath(ConfigurationValue cv, String[] pathlist) throws ConfigurationException {
        ImmutableList pathElements = ImmutableList.copyOf((Object[])pathlist);
        ImmutableList<String> resolvedPaths = this.expandTokens((Iterable<String>)pathElements, this.locales, cv, !this.reportMissingCompilerLibraries);
        this.externalLibraryPath.addAll((Collection<String>)resolvedPaths);
        this.compilingForAIR = Configuration.containsAIRLibraries((ImmutableList<String>)pathElements);
    }

    private static boolean containsAIRLibraries(ImmutableList<String> libraryPaths) {
        for (String path : libraryPaths) {
            if (!path.equals(SWC_AIRGLOBAL) && !path.endsWith("/airglobal.swc") && !path.endsWith("\\airglobal.swc")) continue;
            return true;
        }
        return false;
    }

    public String getCompilerGeneratedDirectory() {
        return this.generatedDir;
    }

    public void setCompilerGeneratedDirectory(String generatedDir) {
        this.generatedDir = generatedDir;
    }

    public boolean isHeadlessServer() {
        return this.headlessServer;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "headless-server"})
    @FlexOnly
    public void setCompilerHeadlessServer(ConfigurationValue cv, boolean headlessServer) {
        this.headlessServer = headlessServer;
    }

    public List<String> getCompilerIncludeLibraries() {
        return this.includeLibraries;
    }

    @Config(allowMultiple=true, isPath=true)
    @Mapping(value={"compiler", "include-libraries"})
    @Arguments(value={"library"})
    @InfiniteArguments
    public void setCompilerIncludeLibraries(ConfigurationValue cv, String[] pathlist) throws ConfigurationException.CannotOpen {
        ImmutableList<String> resolvedPaths = this.expandTokens(Arrays.asList(pathlist), this.locales, cv, !this.reportMissingCompilerLibraries);
        this.includeLibraries.addAll((Collection<String>)resolvedPaths);
    }

    @Config(removed=true)
    @Mapping(value={"compiler", "incremental"})
    public void setCompilerIncremental(ConfigurationValue cv, boolean b) {
    }

    public boolean keepAllTypeSelectors() {
        return this.keepAllTypeSelectors;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "keep-all-type-selectors"})
    @FlexOnly
    public void setCompilerKeepAllTypeSelectors(ConfigurationValue cv, boolean keepAllTypeSelectors) {
        this.keepAllTypeSelectors = keepAllTypeSelectors;
    }

    public Set<String> getCompilerKeepAs3Metadata() {
        return this.as3metadata == null ? Collections.emptySet() : this.as3metadata;
    }

    @Config(advanced=true, allowMultiple=true)
    @Mapping(value={"compiler", "keep-as3-metadata"})
    @Arguments(value={"name"})
    @InfiniteArguments
    public void setCompilerKeepAs3Metadata(ConfigurationValue cv, List<String> values) {
        if (this.as3metadata == null) {
            this.as3metadata = new HashSet<String>();
        }
        this.as3metadata.addAll(values);
    }

    @Config(removed=true)
    @Mapping(value={"compiler", "keep-generated-actionscript"})
    public void setCompilerKeepGeneratedActionscript(ConfigurationValue cv, boolean keep) {
    }

    @Config(removed=true)
    @Mapping(value={"compiler", "keep-generated-signatures"})
    public void setCompilerKeepGeneratedSignatures(ConfigurationValue cv, boolean keep) {
    }

    public boolean getEnableRuntimeDesignLayers() {
        return this.enableRuntimeDesignLayers;
    }

    @Config
    @Mapping(value={"compiler", "enable-runtime-design-layers"})
    @FlexOnly
    public void setCompilerEnableRuntimeDesignLayers(ConfigurationValue cv, boolean enable) {
        this.enableRuntimeDesignLayers = enable;
    }

    public boolean getEnableSwcVersionFiltering() {
        return this.enableSwcVersionFiltering;
    }

    @Config(advanced=true, hidden=true)
    @Mapping(value={"compiler", "enable-swc-version-filtering"})
    public void setCompilerEnableSwcVersionFiltering(ConfigurationValue cv, boolean enable) {
        this.enableSwcVersionFiltering = enable;
    }

    public void setReportMissingCompilerLibraries(boolean reportMissingCompilerLibraries) {
        this.reportMissingCompilerLibraries = reportMissingCompilerLibraries;
    }

    public List<String> getCompilerLibraryPath() {
        return this.libraryPath;
    }

    @Config(allowMultiple=true, isPath=true)
    @Mapping(value={"compiler", "library-path"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    @SoftPrerequisites(value={"locale"})
    public void setCompilerLibraryPath(ConfigurationValue cv, String[] pathlist) throws ConfigurationException.CannotOpen {
        ImmutableList<String> resolvedPaths = this.expandTokens(Arrays.asList(pathlist), this.locales, cv, !this.reportMissingCompilerLibraries);
        this.libraryPath.addAll((Collection<String>)resolvedPaths);
    }

    public List<String> getCompilerLocales() {
        return this.locales;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"compiler", "locale"})
    @Arguments(value={"locale-element"})
    @InfiniteArguments
    @FlexOnly
    public void setCompilerLocale(ConfigurationValue cv, String[] newLocales) {
        this.locales.addAll(Arrays.asList(newLocales));
    }

    public boolean metadataExport() {
        return this.metadataExport;
    }

    public void setCompilerMetadataExport(boolean metadataExport) {
        this.metadataExport = metadataExport;
    }

    public String getCompilerCompatibilityVersionString() {
        return this.getCompilerMxmlCompatibilityVersionString();
    }

    public int getCompilerCompatibilityVersion() {
        return this.getCompilerMxmlCompatibilityVersion();
    }

    public String getCompilerMinimumSupportedVersionString() {
        return this.getCompilerMxmlMinimumSupportedVersionString();
    }

    public int getCompilerMinimumSupportedVersion() {
        return this.getCompilerMxmlMinimumSupportedVersion();
    }

    @Config
    @Mapping(value={"compiler", "minimum-supported-version"})
    @FlexOnly
    public void setCompilerMinimumSupportedVersion(ConfigurationValue cv, String version) throws ConfigurationException {
        this.setCompilerMxmlMinimumSupportedVersion(cv, version);
    }

    @Config(advanced=true, removed=true)
    @Mapping(value={"compiler", "mxml", "qualified-type-selectors"})
    public void setCompilerMxmlQualifiedTypeSelectors(ConfigurationValue cv, boolean b) {
    }

    public boolean omitTraceStatements() {
        return this.omitTraceStatements;
    }

    @Config
    @Mapping(value={"compiler", "omit-trace-statements"})
    public void setCompilerOmitTraceStatements(ConfigurationValue cv, boolean b) {
        this.omitTraceStatements = b;
    }

    public boolean optimize() {
        return this.optimize;
    }

    public boolean getCompilerOptimize() {
        return this.optimize;
    }

    @Config
    @Mapping(value={"compiler", "optimize"})
    public void setCompilerOptimize(ConfigurationValue cv, boolean b) {
        this.optimize = b;
    }

    public String getPreloader() {
        if (this.preloader != null) {
            return this.preloader;
        }
        if (this.getCompilerMxmlCompatibilityVersion() < 0x4000000) {
            return "mx.preloaders.DownloadProgressBar";
        }
        return "mx.preloaders.SparkDownloadProgressBar";
    }

    public String getCompilerPreloader() {
        return this.preloader;
    }

    @Config
    @Mapping(value={"compiler", "preloader"})
    @FlexOnly
    public void setCompilerPreloader(ConfigurationValue cv, String value) {
        this.preloader = value;
    }

    public File getCompilerServices() {
        return this.servicesConfigFile;
    }

    @Config
    @Mapping(value={"compiler", "services"})
    @Arguments(value={"filename"})
    @FlexOnly
    public void setCompilerServices(ConfigurationValue cv, String servicesPath) throws ConfigurationException {
        try {
            this.servicesConfigFile = new File(this.resolvePathStrict(servicesPath, cv));
        }
        catch (Throwable t) {
            throw new ConfigurationException.CannotOpen(servicesPath, cv.getVar(), cv.getSource(), cv.getLine());
        }
    }

    public boolean warnings() {
        return this.ascWarnings;
    }

    @Config
    @Mapping(value={"compiler", "show-actionscript-warnings"})
    public void setCompilerShowActionscriptWarnings(ConfigurationValue cv, boolean ascWarnings) {
        this.ascWarnings = ascWarnings;
    }

    public boolean showBindingWarnings() {
        return this.showBindingWarnings;
    }

    @Config
    @Mapping(value={"compiler", "show-binding-warnings"})
    public void setCompilerShowBindingWarnings(ConfigurationValue cv, boolean show) {
        this.showBindingWarnings = show;
    }

    @Config
    @Mapping(value={"compiler", "show-multiple-definition-warnings"})
    public void setCompilerShowMultipleDefinitionWarnings(ConfigurationValue cv, boolean show) {
        this.showMultipleDefinitionWarnings = show;
    }

    public boolean showDependencyWarnings() {
        return this.showDependencyWarnings;
    }

    @Config(advanced=true, hidden=true)
    @Mapping(value={"compiler", "show-dependency-warnings"})
    public void setCompilerShowDependencyWarnings(ConfigurationValue cv, boolean show) {
        this.showDependencyWarnings = show;
    }

    public boolean getReportInvalidStylesAsWarnings() {
        return this.reportInvalidStylesAsWarnings;
    }

    @Config
    @Mapping(value={"compiler", "report-invalid-styles-as-warnings"})
    @FlexOnly
    public void setCompilerReportInvalidStylesAsWarnings(ConfigurationValue cv, boolean show) {
        this.reportInvalidStylesAsWarnings = show;
    }

    public boolean reportMissingRequiredSkinPartsAsWarnings() {
        return this.reportMissingRequiredSkinPartsAsWarnings;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "report-missing-required-skin-parts-as-warnings"})
    @FlexOnly
    public void setCompilerReportMissingRequiredSkinPartsAsWarnings(ConfigurationValue cv, boolean b) {
        this.reportMissingRequiredSkinPartsAsWarnings = b;
    }

    public boolean getShowInvalidCSSPropertyWarnings() {
        return this.showInvalidCSSPropertyWarnings;
    }

    @Config
    @Mapping(value={"compiler", "show-invalid-css-property-warnings"})
    @FlexOnly
    public void setShowInvalidCssPropertyWarnings(ConfigurationValue cv, boolean show) {
        this.showInvalidCSSPropertyWarnings = show;
    }

    public boolean showDeprecationWarnings() {
        return this.showDeprecationWarnings;
    }

    @Config(advanced=true, hidden=true)
    @Mapping(value={"compiler", "show-deprecation-warnings"})
    public void setCompilerShowDeprecationWarnings(ConfigurationValue cv, boolean show) {
        this.showDeprecationWarnings = show;
    }

    @Config
    @Mapping(value={"compiler", "show-shadowed-device-font-warnings"})
    @FlexOnly
    public void setCompilerShowShadowedDeviceFontWarnings(ConfigurationValue cv, boolean show) {
    }

    public boolean showUnusedTypeSelectorWarnings() {
        return this.showUnusedTypeSelectorWarnings;
    }

    public boolean showMultipleDefinitionWarnings() {
        return this.showMultipleDefinitionWarnings;
    }

    @Config
    @Mapping(value={"compiler", "show-unused-type-selector-warnings"})
    @FlexOnly
    public void setCompilerShowUnusedTypeSelectorWarnings(ConfigurationValue cv, boolean show) {
        this.showUnusedTypeSelectorWarnings = show;
    }

    public List<String> getCompilerSourcePath() {
        return this.sourcePath;
    }

    public ImmutableList<String> getCompilerResourceBundlePathForLocale(String locale) throws ConfigurationException.CannotOpen {
        assert (this.locales.contains(locale)) : "Locale is not configured: " + locale;
        return this.expandTokens(this.unexpandedSourcePath, (Iterable<String>)ImmutableSet.of((Object)locale), this.sourcePathContext, !this.reportMissingCompilerLibraries);
    }

    @Config(allowMultiple=true)
    @Arguments(value={"path-element"})
    @SoftPrerequisites(value={"locale"})
    public void setCompilerSourcePath(ConfigurationValue cv, String[] paths) throws ConfigurationException {
        List<String> pathList = Arrays.asList(paths);
        this.unexpandedSourcePath.addAll(pathList);
        ImmutableList<String> resolvedSourcePaths = this.expandTokens(pathList, this.locales, cv);
        Configuration.assertThatAllPathsAreDirectories(resolvedSourcePaths, cv);
        this.sourcePath.addAll((Collection<String>)resolvedSourcePaths);
        this.sourcePathContext = cv;
    }

    public static void assertThatAllPathsAreDirectories(List<String> paths, ConfigurationValue cv) throws ConfigurationException.NotDirectory {
        assert (paths != null) : "Expected path list.";
        assert (cv != null) : "Expected ConfigurationValue as context.";
        for (String path : paths) {
            File file = new File(path);
            if (file.isDirectory()) continue;
            throw new ConfigurationException.NotDirectory(path, cv.getVar(), cv.getSource(), cv.getLine());
        }
    }

    public static ConfigurationInfo getCompilerSourcePathInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            @Override
            public boolean allowMultiple() {
                return true;
            }

            @Override
            public boolean isPath() {
                return true;
            }
        };
    }

    public boolean strict() {
        return this.strict;
    }

    @Config
    @Mapping(value={"compiler", "strict"})
    public void setCompilerStrict(ConfigurationValue cv, boolean strict) {
        this.strict = strict;
    }

    public boolean suppressWarningsInIncremental() {
        return this.suppressWarningsInIncremental;
    }

    public void setCompilerSuppressWarningsInIncremental(boolean b) {
        this.suppressWarningsInIncremental = b;
    }

    public List<String> getCompilerThemeFiles() {
        boolean hasOnlyOneThemeFile;
        if (this.themeFiles == null) {
            return EMPTY_STRING_LIST;
        }
        boolean isVersion3OrEarlier = this.getCompilerMxmlCompatibilityVersion() <= 0x3000000;
        boolean bl = hasOnlyOneThemeFile = this.themeFiles.size() == 1;
        if (isVersion3OrEarlier && hasOnlyOneThemeFile) {
            String path = FilenameUtils.normalize((String)this.themeFiles.get(0), (boolean)true);
            String sparkPath = "/themes/Spark/spark.css";
            if (path.endsWith("/themes/Spark/spark.css")) {
                int index = path.indexOf("/themes/Spark/spark.css");
                String haloPath = path.substring(0, index) + "/themes/Halo/halo.swc";
                this.themeFiles.set(0, FilenameNormalization.normalize(haloPath));
            }
        }
        return this.themeFiles;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"compiler", "theme"})
    @Arguments(value={"filename"})
    @InfiniteArguments
    @FlexOnly
    public void setCompilerTheme(ConfigurationValue cv, List<String> paths) throws ConfigurationException.CannotOpen {
        ImmutableList<String> resolved = this.resolvePathsStrict((ImmutableList<String>)ImmutableList.copyOf(paths), cv);
        if (this.themeFiles == null) {
            this.themeFiles = new ArrayList<String>();
        }
        this.themeFiles.addAll((Collection<String>)resolved);
    }

    public Deque<String> getDefaultsCSSFiles() {
        return this.defaultsCSSFiles;
    }

    @Config(allowMultiple=true, advanced=true)
    @Mapping(value={"compiler", "defaults-css-files"})
    @Arguments(value={"filename"})
    @InfiniteArguments
    @FlexOnly
    public void setDefaultsCSSFiles(ConfigurationValue cv, List<String> paths) throws ConfigurationException.CannotOpen {
        ImmutableList<String> resolved = this.resolvePathsStrict((ImmutableList<String>)ImmutableList.copyOf(paths), cv);
        for (String path : resolved) {
            this.defaultsCSSFiles.addFirst(path);
        }
    }

    public List<IFileSpecification> getCompilerThemeCssFiles() {
        return this.themeCssFiles;
    }

    public void addThemeCssFiles(List<IFileSpecification> files) {
        this.themeCssFiles.addAll(files);
    }

    @Config(removed=true)
    @Mapping(value={"compiler", "use-resource-bundle-metadata"})
    public void setCompilerUseResourceBundleMetadata(ConfigurationValue cv, boolean b) {
    }

    public boolean debug() {
        return this.verboseStacktraces;
    }

    @Config
    @Mapping(value={"compiler", "verbose-stacktraces"})
    public void setCompilerVerboseStacktraces(ConfigurationValue cv, boolean verboseStacktraces) {
        this.verboseStacktraces = this.generateDebugTags ? true : verboseStacktraces;
    }

    public boolean warn_array_tostring_changes() {
        return this.warn_array_tostring_changes;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-array-tostring-changes"})
    public void setCompilerWarnArrayTostringChanges(ConfigurationValue cv, boolean b) {
        if (b != this.warn_array_tostring_changes) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_assignment_within_conditional() {
        return this.warn_assignment_within_conditional;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-assignment-within-conditional"})
    public void setCompilerWarnAssignmentWithinConditional(ConfigurationValue cv, boolean b) {
        this.warn_assignment_within_conditional = b;
    }

    public boolean warn_bad_array_cast() {
        return this.warn_bad_array_cast;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-bad-array-cast"})
    public void setCompilerWarnBadArrayCast(ConfigurationValue cv, boolean b) {
        this.warn_bad_array_cast = b;
    }

    public boolean warn_bad_bool_assignment() {
        return this.warn_bad_bool_assignment;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-bad-bool-assignment"})
    public void setCompilerWarnBadBoolAssignment(ConfigurationValue cv, boolean b) {
        if (b != this.warn_bad_bool_assignment) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_bad_date_cast() {
        return this.warn_bad_date_cast;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-bad-date-cast"})
    public void setCompilerWarnBadDateCast(ConfigurationValue cv, boolean b) {
        this.warn_bad_date_cast = b;
    }

    public boolean warn_bad_es3_type_method() {
        return this.warn_bad_es3_type_method;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-bad-es3-type-method"})
    public void setCompilerWarnBadEs3TypeMethod(ConfigurationValue cv, boolean b) {
        if (b != this.warn_bad_es3_type_method) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_bad_es3_type_prop() {
        return this.warn_bad_es3_type_prop;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-bad-es3-type-prop"})
    public void setCompilerWarnBadEs3TypeProp(ConfigurationValue cv, boolean b) {
        if (b != this.warn_bad_es3_type_prop) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_bad_nan_comparison() {
        return this.warn_bad_nan_comparison;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-bad-nan-comparison"})
    public void setCompilerWarnBadNanComparison(ConfigurationValue cv, boolean b) {
        this.warn_bad_nan_comparison = b;
    }

    public boolean warn_bad_null_assignment() {
        return this.warn_bad_null_assignment;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-bad-null-assignment"})
    public void setCompilerWarnBadNullAssignment(ConfigurationValue cv, boolean b) {
        this.warn_bad_null_assignment = b;
    }

    public boolean warn_bad_null_comparison() {
        return this.warn_bad_null_comparison;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-bad-null-comparison"})
    public void setCompilerWarnBadNullComparison(ConfigurationValue cv, boolean b) {
        if (b != this.warn_bad_null_comparison) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_bad_undefined_comparison() {
        return this.warn_bad_undefined_comparison;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-bad-undefined-comparison"})
    public void setCompilerWarnBadUndefinedComparison(ConfigurationValue cv, boolean b) {
        this.warn_bad_undefined_comparison = b;
    }

    public boolean warn_boolean_constructor_with_no_args() {
        return this.warn_boolean_constructor_with_no_args;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-boolean-constructor-with-no-args"})
    public void setCompilerWarnBooleanConstructorWithNoArgs(ConfigurationValue cv, boolean b) {
        if (b != this.warn_boolean_constructor_with_no_args) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_changes_in_resolve() {
        return this.warn_changes_in_resolve;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-changes-in-resolve"})
    public void setCompilerWarnChangesInResolve(ConfigurationValue cv, boolean b) {
        if (b != this.warn_changes_in_resolve) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_class_is_sealed() {
        return this.warn_class_is_sealed;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-class-is-sealed"})
    public void setCompilerWarnClassIsSealed(ConfigurationValue cv, boolean b) {
        if (b != this.warn_class_is_sealed) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_const_not_initialized() {
        return this.warn_const_not_initialized;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-const-not-initialized"})
    public void setCompilerWarnConstNotInitialized(ConfigurationValue cv, boolean b) {
        this.warn_const_not_initialized = b;
    }

    public boolean warn_constructor_returns_value() {
        return this.warn_constructor_returns_value;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-constructor-returns-value"})
    public void setCompilerWarnConstructorReturnsValue(ConfigurationValue cv, boolean b) {
        if (b != this.warn_constructor_returns_value) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_deprecated_event_handler_error() {
        return this.warn_deprecated_event_handler_error;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-deprecated-event-handler-error"})
    public void setCompilerWarnDeprecatedEventHandlerError(ConfigurationValue cv, boolean b) {
        if (b != this.warn_deprecated_event_handler_error) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_deprecated_function_error() {
        return this.warn_deprecated_function_error;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-deprecated-function-error"})
    public void setCompilerWarnDeprecatedFunctionError(ConfigurationValue cv, boolean b) {
        if (b != this.warn_deprecated_function_error) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_deprecated_property_error() {
        return this.warn_deprecated_property_error;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-deprecated-property-error"})
    public void setCompilerWarnDeprecatedPropertyError(ConfigurationValue cv, boolean b) {
        if (b != this.warn_deprecated_property_error) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_duplicate_argument_names() {
        return this.warn_duplicate_argument_names;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-duplicate-argument-names"})
    public void setCompilerWarnDuplicateArgumentNames(ConfigurationValue cv, boolean b) {
        if (b != this.warn_duplicate_argument_names) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_duplicate_variable_def() {
        return this.warn_duplicate_variable_def;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-duplicate-variable-def"})
    public void csetCompilerWarnDuplicateVariableDef(ConfigurationValue cv, boolean b) {
        this.warn_duplicate_variable_def = b;
    }

    public boolean warn_for_var_in_changes() {
        return this.warn_for_var_in_changes;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-for-var-in-changes"})
    public void setCompilerWarnForVarInChanges(ConfigurationValue cv, boolean b) {
        if (b != this.warn_for_var_in_changes) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_import_hides_class() {
        return this.warn_import_hides_class;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-import-hides-class"})
    public void setCompilerWarnImportHidesClass(ConfigurationValue cv, boolean b) {
        if (b != this.warn_import_hides_class) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_instance_of_changes() {
        return this.warn_instance_of_changes;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-instance-of-changes"})
    public void setCompilerWarnInstanceOfChanges(ConfigurationValue cv, boolean b) {
        this.warn_instance_of_changes = b;
    }

    public boolean warn_internal_error() {
        return this.warn_internal_error;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-internal-error"})
    public void setCompilerWarnInternalError(ConfigurationValue cv, boolean b) {
        if (b != this.warn_internal_error) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_level_not_supported() {
        return this.warn_level_not_supported;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-level-not-supported"})
    public void setCompilerWarnLevelNotSupported(ConfigurationValue cv, boolean b) {
        if (b != this.warn_level_not_supported) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_missing_namespace_decl() {
        return this.warn_missing_namespace_decl;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-missing-namespace-decl"})
    public void setCompilerWarnMissingNamespaceDecl(ConfigurationValue cv, boolean b) {
        this.warn_missing_namespace_decl = b;
    }

    public boolean warn_negative_uint_literal() {
        return this.warn_negative_uint_literal;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-negative-uint-literal"})
    public void setCompilerWarnNegativeUintLiteral(ConfigurationValue cv, boolean b) {
        if (b != this.warn_negative_uint_literal) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_no_constructor() {
        return this.warn_no_constructor;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-no-constructor"})
    public void setCompilerWarnNoConstructor(ConfigurationValue cv, boolean b) {
        if (b != this.warn_no_constructor) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_no_explicit_super_call_in_constructor() {
        return this.warn_no_explicit_super_call_in_constructor;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-no-explicit-super-call-in-constructor"})
    public void setCompilerWarnNoExplicitSuperCallInConstructor(ConfigurationValue cv, boolean b) {
        if (b != this.warn_no_explicit_super_call_in_constructor) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_no_type_decl() {
        return this.warn_no_type_decl;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-no-type-decl"})
    public void setCompilerWarnNoTypeDecl(ConfigurationValue cv, boolean b) {
        this.warn_no_type_decl = b;
    }

    public boolean warn_number_from_string_changes() {
        return this.warn_number_from_string_changes;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-number-from-string-changes"})
    public void setCompilerWarnNumberFromStringChanges(ConfigurationValue cv, boolean b) {
        if (b != this.warn_number_from_string_changes) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_scoping_change_in_this() {
        return this.warn_scoping_change_in_this;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-scoping-change-in-this"})
    public void setCompilerWarnScopingChangeInThis(ConfigurationValue cv, boolean b) {
        if (b != this.warn_scoping_change_in_this) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_slow_text_field_addition() {
        return this.warn_slow_text_field_addition;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-slow-text-field-addition"})
    public void setCompilerWarnSlowTextFieldAddition(ConfigurationValue cv, boolean b) {
        if (b != this.warn_slow_text_field_addition) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_unlikely_function_value() {
        return this.warn_unlikely_function_value;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-unlikely-function-value"})
    public void setCompilerWarnUnlikelyFunctionValue(ConfigurationValue cv, boolean b) {
        if (b != this.warn_unlikely_function_value) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    public boolean warn_xml_class_has_changed() {
        return this.warn_xml_class_has_changed;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "warn-xml-class-has-changed"})
    public void setCompilerWarnXmlClassHasChanged(ConfigurationValue cv, boolean b) {
        if (b != this.warn_xml_class_has_changed) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    @Config(hidden=true)
    @Mapping(value={"compiler", "generate-abstract-syntax-tree"})
    public void setCompilerGenerateAbstractSyntaxTree(ConfigurationValue cv, boolean b) {
        this.generateAbstractSyntaxTree = b;
    }

    public boolean getCompilerGenerateAbstractSyntaxTree() {
        return this.generateAbstractSyntaxTree;
    }

    public boolean getCompilerIsolateStyles() {
        return this.isolateStyles && this.getCompilerCompatibilityVersion() >= 0x4000000;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "isolate-styles"})
    @FlexOnly
    public void setCompilerIsolateStyles(ConfigurationValue cv, boolean isolateStyles) {
        this.isolateStyles = isolateStyles;
    }

    @Config
    @Mapping(value={"compiler", "compress"})
    public void setCompress(ConfigurationValue cv, boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public ImmutableList<String> expandTokens(Iterable<String> pathElements, Iterable<String> locales, ConfigurationValue configurationValue) {
        return this.expandTokens(pathElements, locales, configurationValue, false);
    }

    protected ImmutableList<String> expandTokens(Iterable<String> pathElements, Iterable<String> locales, ConfigurationValue configurationValue, boolean returnMissingFiles) {
        assert (pathElements != null) : "Expected path list.";
        assert (locales != null) : "Expected locales.";
        assert (configurationValue != null) : "Expected ConfigurationValue as a context.";
        String targetPlayerMajorVersion = String.valueOf(this.getTargetPlayerMajorVersion());
        String targetPlayerMinorVersion = String.valueOf(this.getTargetPlayerMinorVersion());
        ImmutableList.Builder resolvedPaths = new ImmutableList.Builder();
        for (String pathElement : pathElements) {
            String playerExpandedPath = pathElement.replaceAll(TARGET_PLAYER_MAJOR_VERSION_TOKEN_REGEX_ESCAPED, targetPlayerMajorVersion).replaceAll(TARGET_PLAYER_MINOR_VERSION_TOKEN_REGEX_ESCAPED, targetPlayerMinorVersion);
            try {
                if (playerExpandedPath.contains(LOCALE_TOKEN)) {
                    for (String locale : locales) {
                        String expandedPath = playerExpandedPath.replace(LOCALE_TOKEN, locale);
                        String resolvedPath = this.resolvePathStrict(expandedPath, configurationValue);
                        resolvedPaths.add((Object)resolvedPath);
                        this.localeDependentSources.put(resolvedPath, locale);
                    }
                    continue;
                }
                String resolvedPath = this.resolvePathStrict(playerExpandedPath, configurationValue, returnMissingFiles);
                resolvedPaths.add((Object)resolvedPath);
            }
            catch (ConfigurationException.CannotOpen e) {
                this.configurationProblems.add(new ConfigurationProblem(e));
            }
        }
        return resolvedPaths.build();
    }

    public Map<String, String> getLocaleDependentSources() {
        return this.localeDependentSources;
    }

    private String resolvePathStrict(String path, ConfigurationValue cv) throws ConfigurationException.CannotOpen {
        return this.resolvePathStrict(path, cv, false);
    }

    private String resolvePathStrict(String path, ConfigurationValue cv, boolean returnMissingFiles) throws ConfigurationException.CannotOpen {
        ImmutableList singletonPath = ImmutableList.of((Object)path);
        ImmutableList<String> results = this.resolvePathsStrict((ImmutableList<String>)singletonPath, cv, returnMissingFiles);
        return (String)results.get(0);
    }

    private ImmutableList<String> resolvePathsStrict(ImmutableList<String> paths, ConfigurationValue cv) throws ConfigurationException.CannotOpen {
        return this.resolvePathsStrict(paths, cv, false);
    }

    private ImmutableList<String> resolvePathsStrict(ImmutableList<String> paths, ConfigurationValue cv, boolean returnMissingFiles) throws ConfigurationException.CannotOpen {
        assert (paths != null) : "Expected paths";
        assert (cv != null) : "Require ConfigurationValue as context.";
        ImmutableList.Builder resolvedPathsBuilder = new ImmutableList.Builder();
        for (String processedPath : paths) {
            boolean isAbsolute;
            if (cv.getContext() != null && !(isAbsolute = new File(processedPath).isAbsolute())) {
                processedPath = new File(cv.getContext(), processedPath).getAbsolutePath();
            }
            File fileSpec = this.pathResolver.resolve(processedPath);
            if (!returnMissingFiles && !fileSpec.exists()) {
                throw new ConfigurationException.CannotOpen(FilenameNormalization.normalize(processedPath), cv.getVar(), cv.getSource(), cv.getLine());
            }
            resolvedPathsBuilder.add((Object)fileSpec.getAbsolutePath());
        }
        return resolvedPathsBuilder.build();
    }

    @Config(allowMultiple=true, removed=true)
    @Mapping(value={"compiler", "extensions", "extension"})
    @Arguments(value={"extension", "parameters"})
    @InfiniteArguments
    public void setExtension(ConfigurationValue cv, String[] pathlist) throws ConfigurationException.CannotOpen {
    }

    @Config
    @Mapping(value={"compiler", "fonts", "advanced-anti-aliasing"})
    @FlexOnly
    public void setCompilerFontsAdvancedAntiAliasing(ConfigurationValue cv, boolean val) {
    }

    @Config(allowMultiple=true, advanced=true)
    @Mapping(value={"compiler", "fonts", "languages", "language-range"})
    @Arguments(value={"lang", "range"})
    @FlexOnly
    public void setCompilerFontsLanguagesLanguageRange(ConfigurationValue cv, String lang, String range) {
    }

    @Config
    @Mapping(value={"compiler", "fonts", "local-fonts-snapshot"})
    @FlexOnly
    public void setCompilerFontsLocalFontsSnapshot(ConfigurationValue cv, String localFontsSnapshotPath) throws ConfigurationException.CannotOpen {
    }

    @Config
    @Mapping(value={"compiler", "fonts", "local-font-paths"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    @FlexOnly
    public void setCompilerFontsLocalFontPaths(ConfigurationValue cv, List<String> list) throws ConfigurationException.CannotOpen {
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "fonts", "managers"})
    @Arguments(value={"manager-class"})
    @InfiniteArguments
    @FlexOnly
    public void setCompilerFontsManagers(ConfigurationValue cv, List<String> list) {
    }

    @Config
    @Mapping(value={"compiler", "fonts", "max-cached-fonts"})
    @FlexOnly
    public void setCompilerFontsMaxCachedFonts(ConfigurationValue cv, String val) {
    }

    @Config
    @Mapping(value={"compiler", "fonts", "max-glyphs-per-face"})
    @FlexOnly
    public void setCompilerFontsMaxGlyphsPerFace(ConfigurationValue cv, String val) {
    }

    public List<MXMLNamespaceMapping> getCompilerNamespacesManifestMappings() {
        return this.manifestMappings;
    }

    @Config(allowMultiple=true)
    @Mapping(value={"compiler", "namespaces", "namespace"})
    @Arguments(value={"uri", "manifest"})
    @InfiniteArguments
    @FlexOnly
    public void setCompilerNamespacesNamespace(ConfigurationValue cfgval, List<String> args) throws ConfigurationException {
        if (args == null) {
            throw new ConfigurationException.CannotOpen(null, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        if (args.isEmpty()) {
            return;
        }
        if (args.size() < 2) {
            throw new ConfigurationException.NamespaceMissingManifest("namespace", cfgval.getSource(), cfgval.getLine());
        }
        if (args.size() % 2 != 0) {
            throw new ConfigurationException.IncorrectArgumentCount(args.size() + 1, args.size(), cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
        }
        if (this.manifestMappings == null) {
            this.manifestMappings = new ArrayList<MXMLNamespaceMapping>();
        }
        for (int i = 0; i < args.size() - 1; i += 2) {
            String uri = args.get(i);
            String manifestFile = args.get(i + 1);
            String path = this.resolvePathStrict(manifestFile, cfgval);
            this.manifestMappings.add(new MXMLNamespaceMapping(uri, path));
        }
    }

    @Config(allowMultiple=true)
    @Mapping(value={"metadata", "contributor"})
    @Arguments(value={"name"})
    public void setMetadataContributor(ConfigurationValue cv, String name) {
        this.contributors.add(name);
    }

    @Config(allowMultiple=true)
    @Mapping(value={"metadata", "creator"})
    @Arguments(value={"name"})
    public void setMetadataCreator(ConfigurationValue cv, String name) {
        this.creators.add(name);
    }

    @Config
    @Mapping(value={"metadata", "date"})
    @Arguments(value={"text"})
    public void setMetadataDate(ConfigurationValue cv, String text) {
        this.date = text;
    }

    @Config
    @Mapping(value={"metadata", "description"})
    @Arguments(value={"text"})
    public void setMetadataDescription(ConfigurationValue cv, String text) {
        this.localizedDescriptions.put("x-default", text);
    }

    @Config(allowMultiple=true)
    @Mapping(value={"metadata", "language"})
    @Arguments(value={"code"})
    public void setMetadataLanguage(ConfigurationValue cv, String code) {
        this.langs.add(code);
    }

    @Config(allowMultiple=true)
    @Mapping(value={"metadata", "localized-description"})
    @Arguments(value={"text", "lang"})
    public void setMetadataLocalizedDescription(ConfigurationValue cv, String text, String lang) {
        this.localizedDescriptions.put(lang, text);
    }

    @Config(allowMultiple=true)
    @Mapping(value={"metadata", "localized-title"})
    @Arguments(value={"title", "lang"})
    public void setMetadataLocalizedTitle(ConfigurationValue cv, String title, String lang) {
        this.localizedTitles.put(lang, title);
    }

    @Config(allowMultiple=true)
    @Mapping(value={"metadata", "publisher"})
    @Arguments(value={"name"})
    public void setMetadataPublisher(ConfigurationValue cv, String name) {
        this.publishers.add(name);
    }

    @Config
    @Mapping(value={"metadata", "title"})
    @Arguments(value={"text"})
    public void setMetadataTitle(ConfigurationValue cv, String title) {
        this.localizedTitles.put("x-default", title);
    }

    public Set<String> getForceRsls() {
        if (this.forceRsls == null) {
            return Collections.emptySet();
        }
        return this.forceRsls;
    }

    @Config(advanced=true, allowMultiple=true)
    @Mapping(value={"runtime-shared-library-settings", "force-rsls"})
    @SoftPrerequisites(value={"runtime-shared-library-path"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    @FlexOnly
    public void setForceRsls(ConfigurationValue cfgval, String[] args) throws ConfigurationException {
        if (this.forceRsls == null) {
            this.forceRsls = new HashSet<String>();
        }
        for (String arg : args) {
            String swcPath = this.resolvePathStrict(arg, cfgval);
            if (!this.doesSwcHaveRSLInfo(swcPath)) {
                throw new ConfigurationException.SwcDoesNotHaveRslData(swcPath, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
            }
            this.forceRsls.add(swcPath);
        }
    }

    public ApplicationDomainTarget getApplicationDomain(String swcPath) {
        if (this.applicationDomains == null || swcPath == null) {
            return ApplicationDomainTarget.DEFAULT;
        }
        for (Map.Entry<String, ApplicationDomainTarget> entry : this.applicationDomains.entrySet()) {
            if (!entry.getKey().equals(swcPath)) continue;
            return entry.getValue();
        }
        return ApplicationDomainTarget.DEFAULT;
    }

    @Config(advanced=true, allowMultiple=true)
    @SoftPrerequisites(value={"runtime-shared-library-path"})
    @Mapping(value={"runtime-shared-library-settings", "application-domain"})
    @Arguments(value={"path-element", "application-domain-target"})
    @InfiniteArguments
    @FlexOnly
    public void setApplicationDomain(ConfigurationValue cfgval, String[] args) throws ConfigurationException {
        if (this.getStaticLinkRsl()) {
            return;
        }
        if (this.applicationDomains == null) {
            this.applicationDomains = new HashMap();
        }
        for (int i = 0; i < args.length; ++i) {
            String arg;
            String swcPath;
            if (!this.doesSwcHaveRSLInfo(swcPath = this.resolvePathStrict(arg = args[i++], cfgval))) {
                throw new ConfigurationException.SwcDoesNotHaveRslData(swcPath, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
            }
            arg = args[i];
            ApplicationDomainTarget adTarget = this.getApplicationDomainTarget(arg);
            if (adTarget == null) {
                throw new ConfigurationException.BadApplicationDomainValue(swcPath, arg, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
            }
            this.applicationDomains.put(swcPath, adTarget);
        }
    }

    private ApplicationDomainTarget getApplicationDomainTarget(String arg) {
        for (ApplicationDomainTarget appDomain : ApplicationDomainTarget.values()) {
            if (!appDomain.getApplicationDomainValue().equals(arg)) continue;
            return appDomain;
        }
        return null;
    }

    private boolean doesSwcHaveRSLInfo(String swcPath) {
        if (swcPath == null) {
            return false;
        }
        List<RuntimeSharedLibraryPathInfo> rslInfoList = this.getRslPathInfo();
        for (RuntimeSharedLibraryPathInfo rslInfo : rslInfoList) {
            if (!swcPath.equals(rslInfo.getSWCFile().getPath())) continue;
            return true;
        }
        return false;
    }

    public int getCompilerMxmlMajorCompatibilityVersion() {
        return this.mxml_major;
    }

    public int getCompilerMxmlMinorCompatibilityVersion() {
        return this.mxml_minor;
    }

    public int getCompilerMxmlRevisionCompatibilityVersion() {
        return this.mxml_revision;
    }

    public String getCompilerMxmlCompatibilityVersionString() {
        return this.mxml_major == 0 && this.mxml_minor == 0 && this.mxml_revision == 0 ? null : this.mxml_major + "." + this.mxml_minor + "." + this.mxml_revision;
    }

    public int getCompilerMxmlCompatibilityVersion() {
        int version = (this.mxml_major << 24) + (this.mxml_minor << 16) + this.mxml_revision;
        return version != 0 ? version : 0x4060000;
    }

    @Config
    @Mapping(value={"compiler", "mxml", "compatibility-version"})
    @Arguments(value={"version"})
    @FlexOnly
    public void setCompilerMxmlCompatibilityVersion(ConfigurationValue cv, String version) throws ConfigurationException {
        if (version == null) {
            return;
        }
        String[] results = version.split("\\.");
        if (results.length == 0) {
            throw new ConfigurationException.BadVersion(version, "compatibility-version");
        }
        this.mxml_minor = 0;
        this.mxml_revision = 0;
        for (int i = 0; i < results.length; ++i) {
            int versionNum = 0;
            try {
                versionNum = Integer.parseInt(results[i]);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException.BadVersion(version, "compatibility-version");
            }
            if (i == 0) {
                if (versionNum >= 3 && versionNum <= 4) {
                    this.mxml_major = versionNum;
                    continue;
                }
                throw new ConfigurationException.BadVersion(version, "compatibility-version");
            }
            if (versionNum >= 0) {
                if (i == 1) {
                    this.mxml_minor = versionNum;
                    continue;
                }
                this.mxml_revision = versionNum;
                continue;
            }
            throw new ConfigurationException.BadVersion(version, "compatibility-version");
        }
    }

    public String getCompilerMxmlMinimumSupportedVersionString() {
        return this.mxmlMinMajor == 0 && this.mxmlMinMinor == 0 && this.mxmlMinRevision == 0 ? null : this.mxmlMinMajor + "." + this.mxmlMinMinor + "." + this.mxmlMinRevision;
    }

    public int getCompilerMxmlMinimumSupportedVersion() {
        int version = (this.mxmlMinMajor << 24) + (this.mxmlMinMinor << 16) + this.mxmlMinRevision;
        return version != 0 ? version : 0x3000000;
    }

    public void setCompilerMxmlMinimumSupportedVersion(int version) {
        this.mxmlMinMajor = version >> 24 & 0xFF;
        this.mxmlMinMinor = version >> 16 & 0xFF;
        this.mxmlMinRevision = version & 0xFF;
    }

    @Config
    @Mapping(value={"compiler", "mxml", "minimum-supported-version"})
    @FlexOnly
    public void setCompilerMxmlMinimumSupportedVersion(ConfigurationValue cv, String version) throws ConfigurationException {
        if (version == null) {
            return;
        }
        String[] results = version.split("\\.");
        if (results.length == 0) {
            throw new ConfigurationException.BadVersion(version, "minimum-supported-version");
        }
        for (int i = 0; i < results.length; ++i) {
            int versionNum = 0;
            try {
                versionNum = Integer.parseInt(results[i]);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException.BadVersion(version, "minimum-supported-version");
            }
            if (i == 0) {
                if (versionNum >= 3 && versionNum <= 4) {
                    this.mxmlMinMajor = versionNum;
                    continue;
                }
                throw new ConfigurationException.BadVersion(version, "minimum-supported-version");
            }
            if (versionNum >= 0) {
                if (i == 1) {
                    this.mxmlMinMinor = versionNum;
                    continue;
                }
                this.mxmlMinRevision = versionNum;
                continue;
            }
            throw new ConfigurationException.BadVersion(version, "minimum-supported-version");
        }
        this.isMinimumSupportedVersionConfigured = true;
    }

    public boolean isCompilerMxmlMinimumSupportedVersionConfigured() {
        return this.isMinimumSupportedVersionConfigured;
    }

    public boolean getMobile() {
        return this.mobile;
    }

    @Config
    @Mapping(value={"compiler", "mobile"})
    public void setMobile(ConfigurationValue cv, boolean b) {
        this.mobile = b;
    }

    @Config(allowMultiple=true, displayed=false, removed=true)
    @Mapping(value={"licenses", "license"})
    @Arguments(value={"product", "serial-number"})
    public void setLicensesLicense(ConfigurationValue cfgval, String product, String serialNumber) throws ConfigurationException {
    }

    public List<FrameInfo> getFrameList() {
        return this.frameList;
    }

    @Config(advanced=true, allowMultiple=true)
    @Mapping(value={"frames", "frame"})
    @Arguments(value={"label", "classname"})
    @InfiniteArguments
    public void setFramesFrame(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        FrameInfo info = new FrameInfo();
        if (args.size() < 2) {
            throw new ConfigurationException.BadFrameParameters(cv.getVar(), cv.getSource(), cv.getLine());
        }
        for (String next : args) {
            if (info.getLabel() == null) {
                info.setLabel(next);
                continue;
            }
            info.getFrameClasses().add(next);
        }
        this.frameList.add(info);
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "as3"})
    @DeprecatedConfig
    public void setAS3(ConfigurationValue cv, boolean b) {
        if (b != this.as3) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "es"})
    @DeprecatedConfig
    public void setES(ConfigurationValue cv, boolean b) {
        if (b != this.es) {
            this.addRemovedConfigurationOptionProblem(cv);
        }
    }

    @Config(compcOnly=true, removed=true)
    @Mapping(value={"compute-digest"})
    public void setComputeDigest(ConfigurationValue cv, boolean value) {
    }

    @Config(compcOnly=true)
    @Mapping(value={"directory"})
    public void setOutputSwcAsDirectory(ConfigurationValue cv, boolean value) {
        this.outputSwcAsDirectory = value;
    }

    public boolean getOutputSwcAsDirectory() {
        return this.outputSwcAsDirectory;
    }

    @Config(compcOnly=true, allowMultiple=true)
    @Arguments(value={"class"})
    @Mapping(value={"include-classes"})
    public void setIncludeClasses(ConfigurationValue cv, List<String> values) {
        this.includeClasses.addAll(values);
    }

    public List<String> getIncludeClasses() {
        return this.includeClasses;
    }

    @Config(compcOnly=true, allowMultiple=true)
    @Mapping(value={"include-file"})
    @Arguments(value={"name", "path"})
    public void setIncludeFiles(ConfigurationValue cv, List<String> values) throws ConfigurationException.IncorrectArgumentCount, ConfigurationException.CannotOpen, ConfigurationException.RedundantFile {
        int size = values.size();
        if (size % 2 != 0) {
            throw new ConfigurationException.IncorrectArgumentCount(size + 1, size, cv.getVar(), cv.getSource(), cv.getLine());
        }
        for (int nameIndex = 0; nameIndex < size - 1; nameIndex += 2) {
            String name = values.get(nameIndex);
            String path = this.resolvePathStrict(values.get(nameIndex + 1), cv);
            if (this.includeFilesNamePath.containsKey(name)) {
                throw new ConfigurationException.RedundantFile(name, cv.getVar(), cv.getSource(), cv.getLine());
            }
            this.includeFilesNamePath.put(name, path);
        }
    }

    public Map<String, String> getIncludeFiles() {
        return this.includeFilesNamePath;
    }

    @Config(compcOnly=true, advanced=true)
    @Mapping(value={"include-lookup-only"})
    @FlexOnly
    public void setIncludeLookupOnly(ConfigurationValue cv, boolean value) {
        this.includeLookupOnly = value;
    }

    public boolean getIncludeLookupOnly() {
        return this.includeLookupOnly;
    }

    @Config(compcOnly=true, allowMultiple=true)
    @Mapping(value={"include-namespaces"})
    @Arguments(value={"uri"})
    @FlexOnly
    public void setIncludeNamespaces(ConfigurationValue cv, List<String> values) {
        this.includeNamespaces.addAll(values);
    }

    public List<String> getIncludeNamespaces() {
        return this.includeNamespaces;
    }

    @Config(compcOnly=true, allowMultiple=true)
    @Mapping(value={"include-sources"})
    @Arguments(value={"path-element"})
    public void setIncludeSources(ConfigurationValue cv, List<String> values) throws ConfigurationException.NotAFile {
        this.fillListWithResolvedPaths(values, this.includeSources, cv);
    }

    public List<String> getIncludeSources() {
        return this.includeSources;
    }

    private void fillListWithResolvedPaths(List<String> source, List<String> target, ConfigurationValue cv) throws ConfigurationException.NotAFile {
        for (String path : source) {
            try {
                String resolvedPath = this.resolvePathStrict(path, cv);
                target.add(resolvedPath);
            }
            catch (ConfigurationException.CannotOpen e) {
                throw new ConfigurationException.NotAFile(path, cv.getVar(), cv.getSource(), cv.getLine());
            }
        }
    }

    @Config(compcOnly=true, allowMultiple=true)
    @Mapping(value={"include-stylesheet"})
    @Arguments(value={"name", "path"})
    @FlexOnly
    public void setIncludeStyleSheets(ConfigurationValue cv, List<String> values) throws ConfigurationException.NotAFile {
        this.fillListWithResolvedPaths(values, this.includeStyleSheets, cv);
    }

    public List<String> getIncludeStyleSheets() {
        return this.includeStyleSheets;
    }

    @Config(advanced=true)
    @Mapping(value={"dependency-graph"})
    @Arguments(value={"filename"})
    public void setDependencyGraphOutput(ConfigurationValue cv, String fileName) {
        this.dependencyGraphOutput = new File(this.getOutputPath(cv, fileName));
    }

    public File getDependencyGraphOutput() {
        return this.dependencyGraphOutput;
    }

    public String getOutput() {
        return this.output;
    }

    @Config
    @Arguments(value={"filename"})
    public void setOutput(ConfigurationValue val, String output) throws ConfigurationException {
        this.output = this.getOutputPath(val, output);
    }

    public String getDumpConfig() {
        return this.dumpConfigFile;
    }

    @Config(advanced=true, displayed=false)
    @Arguments(value={"filename"})
    @Mapping(value={"dump-config"})
    public void setDumpConfig(ConfigurationValue cv, String filename) {
        this.dumpConfigFile = this.getOutputPath(cv, filename);
    }

    public boolean getWarnings() {
        return this.warnings;
    }

    @Config
    @Mapping(value={"warnings"})
    public void setWarnings(ConfigurationValue cv, boolean b) {
        this.warnings = b;
    }

    public Collection<Class<ICompilerProblem>> getErrorProblems() {
        return this.errorClasses != null ? this.errorClasses : Collections.emptyList();
    }

    @Config(allowMultiple=true)
    @Arguments(value={"class"})
    @InfiniteArguments
    public void setErrorProblems(ConfigurationValue cv, List<String> classNames) throws ConfigurationException {
        if (this.errorClasses == null) {
            this.errorClasses = new HashSet<Class<ICompilerProblem>>();
        }
        for (String className : classNames) {
            Class<ICompilerProblem> resolvedClass = this.resolveProblemClassName(className);
            if (resolvedClass == null) {
                throw new ConfigurationException.CompilerProblemClassNotFound(className, cv.getVar(), cv.getSource(), cv.getLine());
            }
            this.errorClasses.add(resolvedClass);
        }
    }

    public Collection<Class<ICompilerProblem>> getWarningProblems() {
        return this.warningClasses != null ? this.warningClasses : Collections.emptyList();
    }

    @Config(allowMultiple=true)
    @Arguments(value={"class"})
    @InfiniteArguments
    public void setWarningProblems(ConfigurationValue cv, List<String> classNames) throws ConfigurationException {
        if (this.warningClasses == null) {
            this.warningClasses = new HashSet<Class<ICompilerProblem>>();
        }
        for (String className : classNames) {
            Class<ICompilerProblem> resolvedClass = this.resolveProblemClassName(className);
            if (resolvedClass == null) {
                throw new ConfigurationException.CompilerProblemClassNotFound(className, cv.getVar(), cv.getSource(), cv.getLine());
            }
            this.warningClasses.add(resolvedClass);
        }
    }

    public Collection<Class<ICompilerProblem>> getIgnoreProblems() {
        return this.ignoreClasses != null ? this.ignoreClasses : Collections.emptyList();
    }

    @Config(allowMultiple=true)
    @Arguments(value={"class"})
    @InfiniteArguments
    public void setIgnoreProblems(ConfigurationValue cv, List<String> classNames) throws ConfigurationException {
        if (this.ignoreClasses == null) {
            this.ignoreClasses = new HashSet<Class<ICompilerProblem>>();
        }
        for (String className : classNames) {
            Class<ICompilerProblem> resolvedClass = this.resolveProblemClassName(className);
            if (resolvedClass == null) {
                throw new ConfigurationException.CompilerProblemClassNotFound(className, cv.getVar(), cv.getSource(), cv.getLine());
            }
            this.ignoreClasses.add(resolvedClass);
        }
    }

    public boolean useLegacyMessageFormat() {
        return this.legacyMessageFormat;
    }

    @Config(hidden=true)
    public void setLegacyMessageFormat(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.legacyMessageFormat = value;
    }

    public boolean getCreateTargetWithErrors() {
        return this.createTargetWithErrors;
    }

    @Config(hidden=true)
    public void setCreateTargetWithErrors(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.createTargetWithErrors = value;
    }

    public boolean isFlex() {
        return this.isFlex;
    }

    @Config(hidden=true)
    public void setFlex(ConfigurationValue cv, boolean value) throws ConfigurationException {
        this.isFlex = value;
    }

    private Class<ICompilerProblem> resolveProblemClassName(String className) {
        if (className == null) {
            return null;
        }
        Class<ICompilerProblem> resolvedClass = null;
        try {
            resolvedClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (ICompilerProblem.class.isAssignableFrom(resolvedClass)) {
            return resolvedClass;
        }
        return null;
    }

    public String getTargetFile() {
        if (this.fileSpecs.isEmpty()) {
            return null;
        }
        return (String)Iterables.getLast(this.fileSpecs);
    }

    public String getTargetFileDirectory() {
        String targetFile = this.getTargetFile();
        if (targetFile == null) {
            return null;
        }
        String normalizedTargetFile = FilenameNormalization.normalize(targetFile);
        return FilenameUtils.getFullPathNoEndSeparator((String)normalizedTargetFile);
    }

    public void setTargetFile(String mainFile) {
        this.fileSpecs.clear();
        this.fileSpecs.add(mainFile);
    }

    public List<String> getFileSpecs() {
        return this.fileSpecs;
    }

    @Config(allowMultiple=true, hidden=true)
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setFileSpecs(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.fileSpecs.addAll(args);
    }

    @Config(displayed=false, greedy=true)
    @Arguments(value={"keyword"})
    @InfiniteArguments
    public void setHelp(ConfigurationValue cv, String[] keywords) {
    }

    public String getLoadConfig() {
        return this.configFile;
    }

    @Config(allowMultiple=true)
    @Arguments(value={"filename"})
    public void setLoadConfig(ConfigurationValue cv, String filename) throws ConfigurationException {
        this.configFile = this.resolvePathStrict(filename, cv);
    }

    @Config
    public void setVersion(ConfigurationValue cv, boolean value) {
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Config(hidden=true)
    public void setVerbose(ConfigurationValue cfgval, boolean b) {
        this.verbose = b;
    }

    public boolean isDumpAst() {
        return this.dumpAst;
    }

    @Config(hidden=true)
    public void setDumpAst(ConfigurationValue cfgval, boolean b) {
        this.dumpAst = b;
    }

    public boolean isInliningEnabled() {
        return this.enableInlining;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "inline"})
    public void setEnableInlining(ConfigurationValue cfgval, boolean b) {
        this.enableInlining = b;
    }

    public boolean getRemoveDeadCode() {
        return this.removeDeadCode;
    }

    @Config(advanced=true)
    @Mapping(value={"compiler", "remove-dead-code"})
    public void setRemoveDeadCode(ConfigurationValue cfgval, boolean b) {
        this.removeDeadCode = b;
    }

    void validateDumpConfig(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        if (this.dumpConfigFile != null) {
            String text = FileConfigurator.formatBuffer(configurationBuffer, "flex-config", LocalizationManager.get(), "flex2.configuration");
            try {
                FileWriter writer = new FileWriter(this.dumpConfigFile);
                IOUtils.write((String)text, (Writer)writer);
                IOUtils.closeQuietly((Writer)writer);
            }
            catch (IOException e) {
                throw new ConfigurationException.IOError(this.dumpConfigFile);
            }
        }
    }

    public Collection<ICompilerProblem> getConfigurationProblems() {
        return this.configurationProblems;
    }

    public boolean getWarnOnFlexOnlyOptionUsage() {
        return this.warnOnFlexOnlyOptionUsage;
    }

    public void setWarnOnFlexOnlyOptionUsage(boolean value) {
        this.warnOnFlexOnlyOptionUsage = value;
    }

    private void processDeprecatedAndRemovedOptions(ConfigurationBuffer configurationBuffer) {
        for (String var : configurationBuffer.getVars()) {
            ConfigurationInfo info = configurationBuffer.getInfo(var);
            List<ConfigurationValue> values = configurationBuffer.getVar(var);
            if (values == null) continue;
            for (ConfigurationValue cv : values) {
                if (info.isRemoved()) {
                    this.addRemovedConfigurationOptionProblem(cv);
                    continue;
                }
                if (info.isDeprecated() && configurationBuffer.getVar(var) != null) {
                    String replacement = info.getDeprecatedReplacement();
                    String since = info.getDeprecatedSince();
                    DeprecatedConfigurationOptionProblem problem = new DeprecatedConfigurationOptionProblem(var, replacement, since, cv.getSource(), cv.getLine());
                    this.configurationProblems.add(problem);
                    continue;
                }
                if (!this.warnOnFlexOnlyOptionUsage || !info.isFlexOnly()) continue;
                FlexOnlyConfigurationOptionNotSupported problem = new FlexOnlyConfigurationOptionNotSupported(var, cv.getSource(), cv.getLine());
                this.configurationProblems.add(problem);
            }
        }
    }

    private void addRemovedConfigurationOptionProblem(ConfigurationValue cv) {
        RemovedConfigurationOptionProblem problem = new RemovedConfigurationOptionProblem(cv.getVar(), cv.getSource(), cv.getLine());
        this.configurationProblems.add(problem);
    }

    static {
        compcOnlyOptions.add("directory");
        compcOnlyOptions.add("include-classes");
        compcOnlyOptions.add("include-file");
        compcOnlyOptions.add("include-lookup-only");
        compcOnlyOptions.add("include-namespaces");
        compcOnlyOptions.add("include-sources");
        compcOnlyOptions.add("include-stylesheet");
        compcOnlyOptions.add("include-inheritance-dependencies-only");
        aliases = null;
        targetPlayerToSWFVersionMap = Configuration.getSwfVersionMap();
        TARGET_PLAYER_MAJOR_VERSION_TOKEN_REGEX_ESCAPED = Pattern.quote(TARGET_PLAYER_MAJOR_VERSION_TOKEN);
        TARGET_PLAYER_MINOR_VERSION_TOKEN_REGEX_ESCAPED = Pattern.quote(TARGET_PLAYER_MINOR_VERSION_TOKEN);
    }
}

