/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.common;

import com.adobe.flash.utils.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionInfo {
    public static final String FLEX_MAJOR_VERSION = "4";
    public static final String FLEX_MINOR_VERSION = "7";
    public static final String FLEX_NANO_VERSION = "0";
    public static final String LIB_VERSION_1_0 = "1.0";
    public static final String LIB_VERSION_1_1 = "1.1";
    public static final String LIB_VERSION_1_2 = "1.2";
    public static final String LIB_MAJOR_VERSION = "1";
    public static final String LIB_MINOR_VERSION = "2";
    public static final String COMPILER_ELEMENT = "compiler";
    public static final String COMPILER_NAME_ATTRIBUTE = "name";
    public static final String COMPILER_VERSION_ATTRIBUTE = "version";
    public static final String COMPILER_BUILD_ATTRIBUTE = "build";
    public static final String COMPILER_NAMESPACE_URI = "http://ns.adobe.com/asc/2012";
    public static final String COMPILER_NAMESPACE_PREFIX = "asc";
    static String BUILD_MESSAGE;
    static String BUILD_NUMBER_STRING;
    static String FLEX_VERSION_NUMBER;
    static String LIB_VERSION_NUMBER;
    static boolean useFlexMessageFormat;

    public static String buildMessage() {
        if (BUILD_MESSAGE == null) {
            try {
                VersionInfo.getBuild();
                if (useFlexMessageFormat) {
                    String buildNum = BUILD_NUMBER_STRING;
                    BUILD_MESSAGE = "Version 4.7.0 build " + buildNum;
                } else {
                    BUILD_MESSAGE = "Version " + VersionInfo.getCompilerVersion() + " build " + VersionInfo.getCompilerBuild();
                }
            }
            catch (Throwable t) {
                if (Trace.error) {
                    t.printStackTrace();
                }
                BUILD_MESSAGE = "build information unavailable";
            }
        }
        return BUILD_MESSAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBuild() {
        if (BUILD_NUMBER_STRING == null) {
            BUILD_NUMBER_STRING = "";
            InputStream in = null;
            try {
                Properties p = new Properties();
                in = VersionInfo.class.getResourceAsStream("version.properties");
                String build = "";
                if (in != null) {
                    p.load(in);
                    build = p.getProperty(COMPILER_BUILD_ATTRIBUTE);
                    useFlexMessageFormat = true;
                } else {
                    build = VersionInfo.class.getPackage().getImplementationVersion();
                }
                if (build != null && !build.equals("")) {
                    int dot_index = build.lastIndexOf(".");
                    if (dot_index != -1) {
                        build = build.substring(dot_index + 1);
                    }
                    BUILD_NUMBER_STRING = build;
                }
            }
            catch (Throwable t) {
                if (Trace.error) {
                    t.printStackTrace();
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return BUILD_NUMBER_STRING;
    }

    public static long getBuildLong() {
        long buildNum = 0L;
        try {
            buildNum = Long.parseLong(VersionInfo.getBuild());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return buildNum;
    }

    public static String getFlexVersion() {
        if (FLEX_VERSION_NUMBER == null) {
            FLEX_VERSION_NUMBER = "4.7.0";
        }
        return FLEX_VERSION_NUMBER;
    }

    public static String getLibVersion() {
        if (LIB_VERSION_NUMBER == null) {
            LIB_VERSION_NUMBER = LIB_VERSION_1_2;
        }
        return LIB_VERSION_NUMBER;
    }

    public static String getCompilerName() {
        String title = VersionInfo.class.getPackage().getImplementationTitle();
        return title != null ? title : "";
    }

    public static String getCompilerVersion() {
        int dot_index;
        String version = VersionInfo.class.getPackage().getImplementationVersion();
        if (version != null && !version.equals("") && (dot_index = version.lastIndexOf(".")) != -1) {
            version = version.substring(0, dot_index);
        }
        return version != null ? version : "";
    }

    public static String getCompilerBuild() {
        int dot_index;
        String build = VersionInfo.class.getPackage().getImplementationVersion();
        if (build != null && !build.equals("") && (dot_index = build.lastIndexOf(".")) != -1) {
            build = build.substring(dot_index + 1);
        }
        return build != null ? build : "";
    }

    public static boolean IsNewerLibVersion(String swcLibVersion, boolean compareMajorVersion) {
        return VersionInfo.compareVersions(swcLibVersion, VersionInfo.getLibVersion(), compareMajorVersion) > 0;
    }

    public static int compareVersions(String version1, String version2, boolean compareMajorVersion) {
        double v2;
        double v1;
        block8: {
            block7: {
                v1 = 0.0;
                v2 = 0.0;
                try {
                    v1 = Double.parseDouble(version1);
                }
                catch (NumberFormatException ex) {
                    if (!Trace.error) break block7;
                    ex.printStackTrace();
                }
            }
            try {
                v2 = Double.parseDouble(version2);
            }
            catch (NumberFormatException ex) {
                if (!Trace.error) break block8;
                ex.printStackTrace();
            }
        }
        if (compareMajorVersion) {
            v1 = Math.floor(v1);
            v2 = Math.floor(v2);
        }
        if (v1 == v2) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }
}

