/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.common;

import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.utils.FilenameNormalization;

public class SourceLocation
implements ISourceLocation {
    private String sourcePath;
    private int start;
    private int end;
    private int line;
    private int column;

    public SourceLocation(String sourcePath, int start, int end, int line, int column) {
        this.sourcePath = sourcePath;
        this.start = start;
        this.end = end;
        this.line = line;
        this.column = column;
    }

    public SourceLocation(ISourceLocation location) {
        this(location.getSourcePath(), location.getStart(), location.getEnd(), location.getLine(), location.getColumn());
    }

    public SourceLocation() {
        this(null, -1, -1, -1, -1);
    }

    public final void setSourceLocation(ISourceLocation src) {
        assert (src != null) : "source location can't be null";
        this.start = src.getStart();
        this.end = src.getEnd();
        this.line = src.getLine();
        this.column = src.getColumn();
        this.sourcePath = src.getSourcePath();
    }

    @Override
    public int getStart() {
        assert (this.start >= 0 || this.start == -1) : "Invalid value for start: " + this.start;
        return this.start;
    }

    @Override
    public int getAbsoluteStart() {
        assert (this.start >= 0 || this.start == -1) : "Invalid value for start: " + this.start;
        return this.start;
    }

    @Override
    public int getAbsoluteEnd() {
        assert (this.end >= 0 || this.end == -1) : "Invalid value for end: " + this.end;
        return this.end;
    }

    public void setStart(int start) {
        if (start != -1) {
            this.start = start;
        }
    }

    @Override
    public int getEnd() {
        assert (this.end >= 0 || this.end == -1) : "Invalid value for end: " + this.end;
        return this.end;
    }

    public void setEnd(int end) {
        if (end != -1) {
            this.end = end;
        }
    }

    @Override
    public int getLine() {
        assert (this.line >= 0 || this.line == -1) : "Invalid value for line: " + this.line;
        return this.line;
    }

    public void setLine(int line) {
        if (line != -1) {
            this.line = line;
        }
    }

    @Override
    public int getColumn() {
        assert (this.column >= 0 || this.column == -1) : "Invalid value for column: " + this.column;
        return this.column;
    }

    public void setColumn(int column) {
        if (column != -1) {
            this.column = column;
        }
    }

    @Override
    public final String getSourcePath() {
        assert (this.sourcePath == null || this.sourcePath.isEmpty() || this.sourcePath.contains(".swc:") || FilenameNormalization.isNormalized(this.sourcePath)) : "Invalid value for sourcePath: " + this.sourcePath;
        return this.sourcePath;
    }

    public final void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLineColumnString());
        sb.append(this.getOffsetsString());
        sb.append(this.getSourcePathString());
        return sb.toString();
    }

    protected String getLineColumnString() {
        StringBuilder sb = new StringBuilder();
        int line = this.getLine();
        if (line != -1) {
            sb.append(line);
        } else {
            sb.append('?');
        }
        sb.append(':');
        int column = this.getColumn();
        if (column != -1) {
            sb.append(column);
        } else {
            sb.append('?');
        }
        sb.append(' ');
        return sb.toString();
    }

    protected String getSourcePathString() {
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        String sourcePath = this.getSourcePath();
        if (sourcePath != null) {
            sb.append(sourcePath);
        } else {
            sb.append('?');
        }
        return sb.toString();
    }

    protected String getOffsetsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("loc: ");
        int start = this.getStart();
        if (start != -1) {
            sb.append(start);
        } else {
            sb.append('?');
        }
        sb.append('-');
        int end = this.getEnd();
        if (end != -1) {
            sb.append(end);
        } else {
            sb.append('?');
        }
        sb.append(' ');
        sb.append("abs: ");
        int absoluteStart = this.getAbsoluteStart();
        if (absoluteStart != -1) {
            sb.append(absoluteStart);
        } else {
            sb.append('?');
        }
        sb.append('-');
        int absoluteEnd = this.getAbsoluteEnd();
        if (absoluteEnd != -1) {
            sb.append(absoluteEnd);
        } else {
            sb.append('?');
        }
        return sb.toString();
    }

    public final void span(ISourceLocation start, ISourceLocation end) {
        this.setSourcePath(start.getSourcePath());
        this.setStart(start.getStart());
        this.setEnd(end.getEnd());
        this.setLine(start.getLine());
        this.setColumn(start.getColumn());
    }

    public final void span(ISourceLocation location) {
        if (location != null) {
            this.setSourceLocation(location);
        }
    }
}

