/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.common;

import com.adobe.flash.compiler.common.MutablePrefixMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class PrefixMap
implements Cloneable {
    protected HashMap<String, Set<String>> namespaceToPrefixMap = new HashMap();
    protected HashSet<String> prefixes = new HashSet();

    public PrefixMap() {
    }

    public PrefixMap(PrefixMap map) {
        this.namespaceToPrefixMap = new HashMap<String, Set<String>>(map.namespaceToPrefixMap);
        this.prefixes = new HashSet<String>(map.prefixes);
    }

    public PrefixMap clone() {
        PrefixMap result = new PrefixMap();
        result.namespaceToPrefixMap = new HashMap();
        for (String next : this.namespaceToPrefixMap.keySet()) {
            Set<String> set = this.namespaceToPrefixMap.get(next);
            if (set == null) continue;
            LinkedHashSet<String> prefixSet = new LinkedHashSet<String>();
            for (String prefix : set) {
                prefixSet.add(prefix);
            }
            result.namespaceToPrefixMap.put(next, prefixSet);
        }
        result.prefixes = new HashSet<String>(this.prefixes);
        return result;
    }

    public MutablePrefixMap toMutable() {
        return new MutablePrefixMap(this.clone());
    }

    public String getNamespaceForPrefix(String prefix) {
        for (String next : this.namespaceToPrefixMap.keySet()) {
            Set<String> set = this.namespaceToPrefixMap.get(next);
            if (set == null || !set.contains(prefix)) continue;
            return next;
        }
        return null;
    }

    public boolean containsPrefix(String prefix) {
        return this.prefixes.contains(prefix);
    }

    public boolean containsNamespace(String namespace) {
        return this.namespaceToPrefixMap.containsKey(namespace);
    }

    public String[] getAllPrefixes() {
        return this.prefixes.toArray(new String[0]);
    }

    public String[] getAllNamespaces() {
        return this.namespaceToPrefixMap.keySet().toArray(new String[0]);
    }

    public String[] getPrefixesForNamespace(String uri) {
        Set<String> set = this.namespaceToPrefixMap.get(uri);
        if (set != null) {
            return set.toArray(new String[0]);
        }
        return new String[0];
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrefixMap) {
            PrefixMap right = (PrefixMap)obj;
            if (right.namespaceToPrefixMap.size() != this.namespaceToPrefixMap.size()) {
                return false;
            }
            if (right.prefixes.size() != this.prefixes.size()) {
                return false;
            }
            Iterator<String> prefixItr = right.prefixes.iterator();
            while (prefixItr.hasNext()) {
                if (this.prefixes.contains(prefixItr.next())) continue;
                return false;
            }
            for (String next : right.namespaceToPrefixMap.keySet()) {
                Set<String> set = this.namespaceToPrefixMap.get(next);
                Set<String> rSet = right.namespaceToPrefixMap.get(next);
                if (set == null) {
                    return false;
                }
                Iterator<String> pItr = rSet.iterator();
                while (pItr.hasNext()) {
                    if (set.contains(pItr.next())) continue;
                    return false;
                }
            }
            return true;
        }
        return super.equals(obj);
    }
}

