/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.common;

import com.adobe.flash.compiler.common.PrefixMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class MutablePrefixMap
extends PrefixMap {
    public MutablePrefixMap() {
    }

    public MutablePrefixMap(PrefixMap map) {
        PrefixMap clone = map.clone();
        this.namespaceToPrefixMap = new HashMap<String, Set<String>>(clone.namespaceToPrefixMap);
        this.prefixes = new HashSet<String>(clone.prefixes);
    }

    public MutablePrefixMap(String ns, String prefix) {
        this.add(ns, prefix);
    }

    public PrefixMap toImmutable() {
        PrefixMap map = new PrefixMap();
        map.namespaceToPrefixMap = new HashMap(this.namespaceToPrefixMap);
        map.prefixes = new HashSet(this.prefixes);
        return map;
    }

    public void add(String prefix, String uri) {
        this.add(prefix, uri, false);
    }

    public void add(String prefix, String uri, boolean onlyIfUnique) {
        LinkedHashSet<String> list = (LinkedHashSet<String>)this.namespaceToPrefixMap.get(uri);
        if (list == null) {
            list = new LinkedHashSet<String>(1);
            this.namespaceToPrefixMap.put(uri, list);
        }
        if (onlyIfUnique) {
            if (!list.contains(prefix)) {
                list.add(prefix);
                this.prefixes.add(prefix);
            }
        } else {
            list.add(prefix);
            this.prefixes.add(prefix);
        }
    }

    public void addAll(PrefixMap map, boolean onlyIfUnique) {
        for (String ns : map.namespaceToPrefixMap.keySet()) {
            Iterator<String> sItr = map.namespaceToPrefixMap.get(ns).iterator();
            while (sItr.hasNext()) {
                this.add(sItr.next(), ns, onlyIfUnique);
            }
        }
    }

    public void addAll(PrefixMap map) {
        for (String ns : map.namespaceToPrefixMap.keySet()) {
            Iterator<String> sItr = map.namespaceToPrefixMap.get(ns).iterator();
            while (sItr.hasNext()) {
                this.add(sItr.next(), ns);
            }
        }
    }

    public void remove(String prefix) {
        for (String next : this.namespaceToPrefixMap.keySet()) {
            Set set = (Set)this.namespaceToPrefixMap.get(next);
            if (set == null) continue;
            set.remove(prefix);
        }
        this.prefixes.remove(prefix);
    }
}

