/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.common;

import com.adobe.flash.compiler.common.ASModifier;
import com.adobe.flash.compiler.internal.tree.as.ModifierNode;
import java.util.ArrayList;

public class ModifiersSet {
    private short bits = 0;
    private int start = -1;

    public void addModifier(ASModifier modifier) {
        this.bits = (short)(this.bits | modifier.getMaskValue());
    }

    public void addModifier(ModifierNode modifier) {
        if (modifier.getModifier() != null) {
            this.bits = (short)(this.bits | modifier.getModifier().getMaskValue());
            if ((this.start == -1 || modifier.getAbsoluteStart() < this.start) && modifier.getAbsoluteStart() > 0) {
                this.start = modifier.getAbsoluteStart();
            }
        }
    }

    public int getStart() {
        return this.start;
    }

    public boolean hasModifiers() {
        return Integer.bitCount(this.bits) > 0;
    }

    public ASModifier[] getAllModifiers() {
        ArrayList<ASModifier> retVal = new ArrayList<ASModifier>(ASModifier.MODIFIERS.length);
        if (this.hasModifiers()) {
            for (int i = 0; i < ASModifier.MODIFIERS.length; ++i) {
                if ((this.bits & ASModifier.MODIFIERS[i].getMaskValue()) != ASModifier.MODIFIERS[i].getMaskValue()) continue;
                retVal.add(ASModifier.MODIFIERS[i]);
            }
        }
        return retVal.toArray(new ASModifier[0]);
    }

    public boolean hasModifier(ASModifier modifier) {
        return (this.bits & modifier.getMaskValue()) == modifier.getMaskValue();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModifiersSet)) {
            return false;
        }
        return this.bits == ((ModifiersSet)obj).bits && this.start == ((ModifiersSet)obj).start;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (ASModifier modifier : this.getAllModifiers()) {
            sb.append(modifier.toString());
            sb.append(' ');
        }
        return sb.toString();
    }
}

