/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.common;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.ECMASupport;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IntrinsicsManager {
    private static final String memoryPackage = "avm2.intrinsics.memory";
    private static final String iterationPackage = "avm2.intrinsics.iteration";
    private static final Map<String, Intrinsic> intrinsicMap;

    public static Intrinsic lookupIntrinsic(String qName, int trait) {
        Intrinsic intrinsic = intrinsicMap.get(qName);
        if (intrinsic == null) {
            return null;
        }
        if (!intrinsic.traitMatches(trait)) {
            return null;
        }
        return intrinsic;
    }

    static {
        HashMap<String, Intrinsic> tmpMap = new HashMap<String, Intrinsic>();
        for (Intrinsic intrinsic : Intrinsic.values()) {
            tmpMap.put(intrinsic.getQName(), intrinsic);
        }
        intrinsicMap = Collections.unmodifiableMap(tmpMap);
    }

    public static class Intrinsic
    extends Enum<Intrinsic> {
        public static final /* enum */ Intrinsic li8 = new Intrinsic(53, "avm2.intrinsics.memory.li8", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic li16 = new Intrinsic(54, "avm2.intrinsics.memory.li16", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic li32 = new Intrinsic(55, "avm2.intrinsics.memory.li32", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic lf32 = new Intrinsic(56, "avm2.intrinsics.memory.lf32", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic lf64 = new Intrinsic(57, "avm2.intrinsics.memory.lf64", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic si8 = new Intrinsic(58, "avm2.intrinsics.memory.si8", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic si16 = new Intrinsic(59, "avm2.intrinsics.memory.si16", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic si32 = new Intrinsic(60, "avm2.intrinsics.memory.si32", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic sf32 = new Intrinsic(61, "avm2.intrinsics.memory.sf32", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic sf64 = new Intrinsic(62, "avm2.intrinsics.memory.sf64", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic sxi1 = new Intrinsic(80, "avm2.intrinsics.memory.sxi1", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic sxi8 = new Intrinsic(81, "avm2.intrinsics.memory.sxi8", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic sxi16 = new Intrinsic(82, "avm2.intrinsics.memory.sxi16", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic convert_u = new Intrinsic(116, "uint", (Set)ImmutableSet.of((Object)4), true){

            @Override
            public void codegen(InstructionList insns, List<InstructionList> args) {
                this.codegenCast(insns, args);
            }

            @Override
            protected void codegenEmptyCast(InstructionList insns) {
                this.codegenEmptyNumericCast(insns);
            }

            @Override
            public Object constantEvaluate(List<Object> args) {
                if (args.size() == 0) {
                    return new Long(0L);
                }
                return ECMASupport.toUInt32(args.get(0));
            }
        };
        public static final /* enum */ Intrinsic convert_i = new Intrinsic(115, "int", (Set)ImmutableSet.of((Object)4), true){

            @Override
            public void codegen(InstructionList insns, List<InstructionList> args) {
                this.codegenCast(insns, args);
            }

            @Override
            protected void codegenEmptyCast(InstructionList insns) {
                this.codegenEmptyNumericCast(insns);
            }

            @Override
            public Object constantEvaluate(List<Object> args) {
                if (args.size() == 0) {
                    return new Integer(0);
                }
                return ECMASupport.toInt32(args.get(0));
            }
        };
        public static final /* enum */ Intrinsic convert_b = new Intrinsic(118, "Boolean", (Set)ImmutableSet.of((Object)4), true){

            @Override
            public void codegen(InstructionList insns, List<InstructionList> args) {
                this.codegenCast(insns, args);
            }

            @Override
            protected void codegenEmptyCast(InstructionList insns) {
                insns.addInstruction(39);
            }

            @Override
            public Object constantEvaluate(List<Object> args) {
                if (args.size() == 0) {
                    return Boolean.FALSE;
                }
                return ECMASupport.toBoolean(args.get(0));
            }
        };
        public static final /* enum */ Intrinsic convert_d = new Intrinsic(117, "Number", (Set)ImmutableSet.of((Object)4), true){

            @Override
            public void codegen(InstructionList insns, List<InstructionList> args) {
                this.codegenCast(insns, args);
            }

            @Override
            protected void codegenEmptyCast(InstructionList insns) {
                this.codegenEmptyNumericCast(insns);
            }

            @Override
            public Object constantEvaluate(List<Object> args) {
                if (args.size() == 0) {
                    return new Double(0.0);
                }
                return ECMASupport.toNumeric(args.get(0));
            }
        };
        public static final /* enum */ Intrinsic convert_s = new Intrinsic(112, "String", (Set)ImmutableSet.of((Object)4), true){

            @Override
            public void codegen(InstructionList insns, List<InstructionList> args) {
                this.codegenCast(insns, args);
            }

            @Override
            protected void codegenEmptyCast(InstructionList insns) {
                insns.addInstruction(44, "");
            }

            @Override
            public Object constantEvaluate(List<Object> args) {
                if (args.size() == 0) {
                    return "";
                }
                return ECMASupport.toString(args.get(0));
            }
        };
        public static final /* enum */ Intrinsic hasnext = new Intrinsic(31, "avm2.intrinsics.iteration.hasnext", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic nextvalue = new Intrinsic(35, "avm2.intrinsics.iteration.nextvalue", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        public static final /* enum */ Intrinsic nextname = new Intrinsic(30, "avm2.intrinsics.iteration.nextname", (Set<Integer>)ImmutableSet.of((Object)1, (Object)5));
        private final int op;
        private final String qName;
        private final Set<Integer> traits;
        private final boolean constantEvaluatable;
        private static final /* synthetic */ Intrinsic[] $VALUES;

        public static Intrinsic[] values() {
            return (Intrinsic[])$VALUES.clone();
        }

        public static Intrinsic valueOf(String name) {
            return Enum.valueOf(Intrinsic.class, name);
        }

        private Intrinsic(int op, String qName, Set<Integer> traits) {
            this(op, qName, traits, false);
        }

        private Intrinsic(int op, String qName, Set<Integer> traits, boolean constantEvaluatable) {
            this.op = op;
            this.qName = qName;
            this.traits = traits;
            this.constantEvaluatable = constantEvaluatable;
        }

        public boolean canBeConstantEvaluated() {
            return this.constantEvaluatable;
        }

        public Object constantEvaluate(List<Object> args) {
            return null;
        }

        public void codegen(InstructionList insns, List<InstructionList> args) {
            this.codegenBasic(insns, args);
        }

        private void codegenBasic(InstructionList insns, List<InstructionList> args) {
            for (InstructionList arg : args) {
                insns.addAll(arg);
            }
            insns.addInstruction(this.op);
        }

        public void codegenCast(InstructionList insns, List<InstructionList> args) {
            if (args.size() != 0) {
                this.codegenBasic(insns, args);
            } else {
                this.codegenEmptyCast(insns);
            }
        }

        protected void codegenEmptyCast(InstructionList insns) {
            assert (false) : "should have been overriden";
        }

        protected void codegenEmptyNumericCast(InstructionList insns) {
            insns.pushNumericConstant(0L);
            insns.addInstruction(this.op);
        }

        protected String getQName() {
            return this.qName;
        }

        protected boolean traitMatches(int trait) {
            return this.traits.contains(trait);
        }

        static {
            $VALUES = new Intrinsic[]{li8, li16, li32, lf32, lf64, si8, si16, si32, sf32, sf64, sxi1, sxi8, sxi16, convert_u, convert_i, convert_b, convert_d, convert_s, hasnext, nextvalue, nextname};
        }
    }
}

