/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.common;

import com.adobe.flash.compiler.common.DependencyType;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class DependencyTypeSet
implements Iterable<DependencyType> {
    private static DependencyType[] DEPENDENCY_TYPES = DependencyType.values();
    private int flags;

    public static DependencyTypeSet noneOf() {
        return new DependencyTypeSet();
    }

    public static DependencyTypeSet allOf() {
        DependencyTypeSet typeSet = new DependencyTypeSet();
        for (DependencyType type : DEPENDENCY_TYPES) {
            typeSet.add(type);
        }
        return typeSet;
    }

    public static DependencyTypeSet of(DependencyType ... types) {
        DependencyTypeSet typeSet = new DependencyTypeSet();
        for (DependencyType type : types) {
            typeSet.add(type);
        }
        return typeSet;
    }

    public static DependencyTypeSet copyOf(Collection<DependencyType> dependencyTypeCollection) {
        DependencyTypeSet typeSet = new DependencyTypeSet();
        for (DependencyType type : dependencyTypeCollection) {
            typeSet.add(type);
        }
        return typeSet;
    }

    public static DependencyTypeSet copyOf(DependencyTypeSet otherTypeSet) {
        DependencyTypeSet typeSet = new DependencyTypeSet();
        typeSet.flags = otherTypeSet.flags;
        return typeSet;
    }

    private DependencyTypeSet() {
    }

    @Override
    public Iterator<DependencyType> iterator() {
        return new Iterator<DependencyType>(){
            private int i = -1;

            @Override
            public boolean hasNext() {
                int bit = this.getNextBit(this.i + 1);
                return bit < DEPENDENCY_TYPES.length;
            }

            @Override
            public DependencyType next() {
                this.i = this.getNextBit(this.i + 1);
                if (this.i < DEPENDENCY_TYPES.length) {
                    return DEPENDENCY_TYPES[this.i];
                }
                throw new NoSuchElementException();
            }

            private int getNextBit(int startingBit) {
                int nextBit;
                for (nextBit = startingBit; nextBit < DEPENDENCY_TYPES.length; ++nextBit) {
                    int mask = 1 << nextBit;
                    if ((DependencyTypeSet.this.flags & mask) != 0) break;
                }
                return nextBit;
            }

            @Override
            public void remove() {
                assert (false) : "This should never get called";
            }
        };
    }

    public boolean isEmpty() {
        return this.flags == 0;
    }

    public void add(DependencyType dependencyType) {
        int mask = 1 << dependencyType.ordinal();
        this.flags |= mask;
    }

    public void addAll(DependencyTypeSet otherSet) {
        for (DependencyType type : otherSet) {
            this.add(type);
        }
    }

    public boolean contains(DependencyType dependencyType) {
        int mask = 1 << dependencyType.ordinal();
        return (this.flags & mask) != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(' ');
        for (DependencyType type : DependencyType.values()) {
            if (!this.contains(type)) continue;
            sb.append(type.name());
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }
}

