/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.clients.problems;

import com.adobe.flash.compiler.clients.problems.CompilerProblemCategorizer;
import com.adobe.flash.compiler.clients.problems.ProblemFormatter;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.CompilerProblemClassification;
import com.adobe.flash.compiler.problems.CompilerProblemSeverity;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.io.input.NullReader;

public final class WorkspaceProblemFormatter
extends ProblemFormatter {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final int MAX_CACHED_LINES_PER_FILE = 10;
    private static String ERROR_FORMAT_ID = "ErrorFormat";
    private static String WARNING_FORMAT_ID = "WarningFormat";
    private static String SYNTAXERROR_FORMAT_ID = "SyntaxErrorFormat";
    private static String INTERNALERROR_FORMAT_ID = "InternalErrorFormat";
    private static String LOCATION_FORMAT_ID = "LocationFormat";
    private static String LOCATION_FORMAT_STRING = "%s:%d";
    private final Workspace workspace;
    private final Map<String, FileLineInfo> readers;
    private final CompilerProblemCategorizer problemCategorizer;

    public WorkspaceProblemFormatter(Workspace workspace) {
        this(workspace, null);
    }

    public WorkspaceProblemFormatter(Workspace workspace, CompilerProblemCategorizer problemCategorizer) {
        this.workspace = workspace;
        this.problemCategorizer = problemCategorizer;
        this.readers = new MapMaker().concurrencyLevel(1).softValues().makeComputingMap((Function)new Function<String, FileLineInfo>(){

            public FileLineInfo apply(String fileName) {
                return new FileLineInfo(fileName);
            }
        });
    }

    @Override
    public String format(ICompilerProblem problem) {
        StringBuffer buffer = new StringBuffer();
        String locationString = this.getLocationString(problem.getSourcePath(), problem.getLine());
        if (!locationString.isEmpty()) {
            buffer.append(locationString);
            buffer.append(NEW_LINE);
        }
        String description = super.format(problem);
        if (this.problemCategorizer != null) {
            description = String.format(this.getProblemFormat(problem), description);
        }
        assert (description != null);
        buffer.append(description);
        buffer.append(NEW_LINE);
        String lineText = this.getLineText(problem);
        if (lineText != null) {
            buffer.append(lineText);
            buffer.append(NEW_LINE);
            buffer.append(this.getLinePointer(lineText, problem.getColumn()));
            buffer.append(NEW_LINE);
        }
        return buffer.toString();
    }

    private String getProblemFormat(ICompilerProblem problem) {
        CompilerProblemSeverity severity = this.problemCategorizer.getProblemSeverity(problem);
        CompilerProblemClassification classification = this.problemCategorizer.getProblemClassification(problem);
        String formatString = null;
        if (classification == CompilerProblemClassification.DEFAULT) {
            switch (severity) {
                case ERROR: {
                    formatString = this.getErrorFormat();
                    break;
                }
                case WARNING: {
                    formatString = this.getWarningFormat();
                    break;
                }
                default: {
                    assert (false);
                    formatString = this.getErrorFormat();
                    break;
                }
            }
        } else {
            switch (classification) {
                case SYNTAX_ERROR: {
                    formatString = this.getSyntaxErrorFormat();
                    break;
                }
                case INTERNAL_ERROR: {
                    formatString = this.getInternalErrorFormat();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        assert (formatString != null);
        return formatString;
    }

    protected String getLineText(ICompilerProblem problem) {
        String filePath = problem.getSourcePath();
        if (filePath == null) {
            return null;
        }
        int lineNumber = problem.getLine();
        if (lineNumber < 0) {
            return null;
        }
        FileLineInfo fileLineInfo = this.readers.get(filePath);
        return fileLineInfo.getLineText(lineNumber);
    }

    private String getLinePointer(String lineText, int column) {
        if (lineText == null || column == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder(column);
        int len = lineText.length();
        for (int i = 0; i < column; ++i) {
            if (i < len && lineText.charAt(i) == '\t') {
                b.append('\t');
                continue;
            }
            b.append(' ');
        }
        b.append('^');
        return b.toString();
    }

    private String getLocationString(String filePath, int line) {
        if (filePath == null) {
            return "";
        }
        String location = filePath;
        if (line != -1) {
            location = String.format(this.getLocationFormat(), location, line + 1);
        }
        assert (location != null);
        return location;
    }

    private String getErrorFormat() {
        return this.getMessage(ERROR_FORMAT_ID);
    }

    private String getWarningFormat() {
        return this.getMessage(WARNING_FORMAT_ID);
    }

    private String getSyntaxErrorFormat() {
        return this.getMessage(SYNTAXERROR_FORMAT_ID);
    }

    private String getInternalErrorFormat() {
        return this.getMessage(INTERNALERROR_FORMAT_ID);
    }

    private String getLocationFormat() {
        String format = this.getMessage(LOCATION_FORMAT_ID);
        if (format != null) {
            return format;
        }
        return LOCATION_FORMAT_STRING;
    }

    private class FileLineInfo {
        final String fileName;
        LineNumberReader reader;
        final Map<Integer, String> cachedLines;

        FileLineInfo(String fileName) {
            this.fileName = fileName;
            this.reader = this.createReader();
            this.cachedLines = new MapMaker().concurrencyLevel(1).softValues().maximumSize(10).makeMap();
        }

        private LineNumberReader createReader() {
            Reader reader;
            IFileSpecification fileSpec = WorkspaceProblemFormatter.this.workspace.getFileSpecification(this.fileName);
            try {
                reader = fileSpec.createReader();
            }
            catch (FileNotFoundException e) {
                reader = new NullReader(0L);
            }
            return new LineNumberReader(reader);
        }

        String getLineText(int lineNumber) {
            String result = this.cachedLines.get(lineNumber);
            if (result != null) {
                return result;
            }
            if (this.reader.getLineNumber() > lineNumber) {
                this.reader = this.createReader();
            }
            assert (this.reader.getLineNumber() <= lineNumber);
            try {
                while (this.reader.getLineNumber() < lineNumber) {
                    String lineText = this.reader.readLine();
                    if (lineText != null) continue;
                    return null;
                }
                result = this.reader.readLine();
                if (result == null) {
                    return null;
                }
                this.cachedLines.put(lineNumber, result);
                return result;
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

