/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.clients.problems;

import com.adobe.flash.compiler.clients.problems.IProblemFilter;
import com.adobe.flash.compiler.config.ICompilerProblemSettings;
import com.adobe.flash.compiler.problems.AbstractDeprecatedAPIProblem;
import com.adobe.flash.compiler.problems.ArrayCastProblem;
import com.adobe.flash.compiler.problems.AssignmentInConditionalProblem;
import com.adobe.flash.compiler.problems.ConstNotInitializedProblem;
import com.adobe.flash.compiler.problems.DateCastProblem;
import com.adobe.flash.compiler.problems.DeprecatedConfigurationOptionProblem;
import com.adobe.flash.compiler.problems.DuplicateQNameInSourcePathProblem;
import com.adobe.flash.compiler.problems.DuplicateVariableDefinitionProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.IllogicalComparionWithNaNProblem;
import com.adobe.flash.compiler.problems.IllogicalComparisonWithUndefinedProblem;
import com.adobe.flash.compiler.problems.InstanceOfProblem;
import com.adobe.flash.compiler.problems.NullUsedWhereOtherExpectedProblem;
import com.adobe.flash.compiler.problems.OverlappingSourcePathProblem;
import com.adobe.flash.compiler.problems.ScopedToDefaultNamespaceProblem;
import com.adobe.flash.compiler.problems.SemanticWarningProblem;
import com.adobe.flash.compiler.problems.StrictSemanticsProblem;
import com.adobe.flash.compiler.problems.VariableHasNoTypeDeclarationProblem;
import java.util.HashSet;
import java.util.Set;

public class ProblemSettingsFilter
implements IProblemFilter {
    private final ICompilerProblemSettings problemSettings;
    private final Set<Class<? extends ICompilerProblem>> filter = new HashSet<Class<? extends ICompilerProblem>>();

    public ProblemSettingsFilter(ICompilerProblemSettings problemSettings) {
        assert (problemSettings != null) : "Settings may not be null";
        this.problemSettings = problemSettings;
        this.init();
    }

    @Override
    public boolean accept(ICompilerProblem p) {
        for (Class<? extends ICompilerProblem> filterClass : this.filter) {
            if (!filterClass.isInstance(p)) continue;
            return false;
        }
        return true;
    }

    private void init() {
        this.setShowStrictSemantics(this.problemSettings.isStrict());
        this.setShowWarnings(this.problemSettings.showActionScriptWarnings());
        this.setShowDeprecationWarnings(this.problemSettings.showDeprecationWarnings());
        this.setShowBindingWarnings(this.problemSettings.showBindingWarnings());
        this.setShowMultipleDefinitionWarnings(this.problemSettings.showMultipleDefinitionWarnings());
        this.setShowUnusedTypeSelectorWarnings(this.problemSettings.showUnusedTypeSelectorWarnings());
        this.setAllowSourcePathOverlapWarnings(this.problemSettings.isSourcePathOverlapAllowed());
        this.setShowActionScriptWarnings();
    }

    private void setShowStrictSemantics(boolean isStrict) {
        this.setShowProblemByClass(StrictSemanticsProblem.class, isStrict);
    }

    private void setShowWarnings(boolean showWarnings) {
        this.setShowProblemByClass(SemanticWarningProblem.class, showWarnings);
    }

    private void setAllowSourcePathOverlapWarnings(boolean isSourcePathOverlapAllowed) {
        this.setShowProblemByClass(OverlappingSourcePathProblem.class, !isSourcePathOverlapAllowed);
    }

    private void setShowUnusedTypeSelectorWarnings(boolean showUnusedTypeSelectorWarnings) {
    }

    private void setShowBindingWarnings(boolean showBindingWarnings) {
    }

    private void setShowMultipleDefinitionWarnings(boolean b) {
        this.setShowProblemByClass(DuplicateQNameInSourcePathProblem.class, b);
    }

    private void setShowActionScriptWarnings() {
        this.setShowActionScriptWarning(AssignmentInConditionalProblem.class, 1100);
        this.setShowActionScriptWarning(ArrayCastProblem.class, 1112);
        this.setShowActionScriptWarning(DateCastProblem.class, 3575);
        this.setShowActionScriptWarning(IllogicalComparionWithNaNProblem.class, 1098);
        this.setShowActionScriptWarning(NullUsedWhereOtherExpectedProblem.class, 1102);
        this.setShowActionScriptWarning(IllogicalComparisonWithUndefinedProblem.class, 1012);
        this.setShowActionScriptWarning(ConstNotInitializedProblem.class, 1110);
        this.setShowActionScriptWarning(DuplicateVariableDefinitionProblem.class, 3596);
        this.setShowActionScriptWarning(InstanceOfProblem.class, 3555);
        this.setShowActionScriptWarning(ScopedToDefaultNamespaceProblem.class, 1084);
        this.setShowActionScriptWarning(VariableHasNoTypeDeclarationProblem.class, 1008);
    }

    private void setShowActionScriptWarning(Class<? extends ICompilerProblem> problem, int warningCode) {
        this.setShowProblemByClass(problem, this.problemSettings.checkActionScriptWarning(warningCode));
    }

    private void setShowDeprecationWarnings(boolean showWarnings) {
        this.setShowProblemByClass(AbstractDeprecatedAPIProblem.class, showWarnings);
        this.setShowProblemByClass(DeprecatedConfigurationOptionProblem.class, showWarnings);
    }

    private void setShowProblemByClass(Class<? extends ICompilerProblem> clazz, boolean enable) {
        if (enable) {
            this.filter.remove(clazz);
        } else {
            this.filter.add(clazz);
        }
    }
}

