/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.clients.problems;

import com.adobe.flash.compiler.clients.problems.CompilerProblemCategorizer;
import com.adobe.flash.compiler.clients.problems.IProblemFilter;
import com.adobe.flash.compiler.clients.problems.ProblemFilterClassCriteria;
import com.adobe.flash.compiler.clients.problems.ProblemSettingsFilter;
import com.adobe.flash.compiler.config.ICompilerProblemSettings;
import com.adobe.flash.compiler.problems.AbstractSemanticProblem;
import com.adobe.flash.compiler.problems.CodegenInternalProblem;
import com.adobe.flash.compiler.problems.CodegenProblem;
import com.adobe.flash.compiler.problems.CompilerProblemSeverity;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.ParserProblem;
import com.adobe.flash.compiler.problems.SemanticWarningProblem;
import com.adobe.flash.compiler.problems.StrictSemanticsProblem;
import com.adobe.flash.compiler.problems.UnfoundPropertyProblem;
import com.adobe.flash.compiler.problems.collections.CompositeProblemFilter;
import com.adobe.flash.compiler.problems.collections.FilteredIterator;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class ProblemQuery {
    private ArrayList<ICompilerProblem> problems = new ArrayList();
    private boolean sorted = true;
    private ProblemFilterClassCriteria problemFilter = new ProblemFilterClassCriteria(new Class[0]);
    private ICompilerProblemSettings problemSettings;
    public static final Comparator<ICompilerProblem> compareByPositionAndPhase = new Comparator<ICompilerProblem>(){

        @Override
        public int compare(ICompilerProblem p1, ICompilerProblem p2) {
            int result = ProblemQuery.compareStrings(p1.getSourcePath(), p2.getSourcePath());
            if (result == 0) {
                result = p1.getLine() - p2.getLine();
            }
            if (result == 0) {
                result = this.compareProblemClasses(p1, p2);
            }
            return result;
        }

        private int compareProblemClasses(ICompilerProblem p1, ICompilerProblem p2) {
            if (p1 instanceof ParserProblem) {
                if (!(p2 instanceof ParserProblem)) {
                    return -1;
                }
            } else if (p2 instanceof ParserProblem && !(p1 instanceof ParserProblem)) {
                return 1;
            }
            return 0;
        }
    };

    public ProblemQuery() {
        this(null);
    }

    public ProblemQuery(ICompilerProblemSettings problemSettings) {
        this.problemSettings = problemSettings;
    }

    public void setShowStrictSemantics(boolean isStrict) {
        this.setShowProblemByClass(StrictSemanticsProblem.class, isStrict);
    }

    public void setShowWarnings(boolean showWarnings) {
        this.setShowProblemByClass(SemanticWarningProblem.class, showWarnings);
    }

    public void setShowInternalErrors(boolean showInternalErrors) {
        this.setShowProblemByClass(CodegenInternalProblem.class, showInternalErrors);
    }

    public void setShowIrrelevantProblems(boolean showIrrelevantProblems) {
        this.setShowProblemByClass(UnfoundPropertyProblem.class, showIrrelevantProblems);
    }

    public void setShowProblemByClass(Class<? extends ICompilerProblem> problemClass, boolean enable) {
        if (enable) {
            this.problemFilter.removeRejectedClass(problemClass);
        } else {
            this.problemFilter.addRejectedClass(problemClass);
        }
    }

    public void addAll(ICompilerProblem[] newProblems) {
        this.addAll(Arrays.asList(newProblems));
    }

    public void addAll(Iterable<ICompilerProblem> newProblems) {
        this.sorted = false;
        Iterables.addAll(this.problems, newProblems);
    }

    public void add(ICompilerProblem problem) {
        this.sorted = false;
        this.problems.add(problem);
    }

    public void clear() {
        this.sorted = true;
        this.problems.clear();
    }

    public Iterable<ICompilerProblem> getFilteredProblems() {
        IProblemFilter filter = CompositeProblemFilter.and(this.problemFilter, new SkipSemanticCascadesFilter());
        CompilerProblemCategorizer categorizer = new CompilerProblemCategorizer(this.problemSettings);
        return this.getFilteredProblems(CompositeProblemFilter.and(filter, new ErrorsAndWarningsFilter(categorizer)));
    }

    private Iterable<ICompilerProblem> getFilteredProblemsUsingBaseFilter() {
        return this.getFilteredProblems(CompositeProblemFilter.and(this.problemFilter, new SkipSemanticCascadesFilter()));
    }

    private Iterable<ICompilerProblem> getFilteredProblems(IProblemFilter filter) {
        if (this.problemSettings != null) {
            filter = CompositeProblemFilter.and(filter, new ProblemSettingsFilter(this.problemSettings));
        }
        this.sortProblems();
        return this.getProblemView(filter);
    }

    public boolean hasFilteredProblems() {
        return this.getFilteredProblems().iterator().hasNext();
    }

    public boolean hasFilteredProblems(IProblemFilter filter) {
        return this.getProblemView(filter).iterator().hasNext();
    }

    public Iterable<ICompilerProblem> getProblemView(IProblemFilter filter) {
        return FilteredIterator.getFilteredIterable(this.problems, filter);
    }

    public Iterable<ICompilerProblem> getInternalErrors() {
        return this.getProblemView(new ProblemFilterClassCriteria(CodegenInternalProblem.class));
    }

    public void sortProblems() {
        if (!this.sorted) {
            Collections.sort(this.problems, compareByPositionAndPhase);
        }
        this.sorted = true;
    }

    public void getErrorsAndWarnings(Collection<ICompilerProblem> errors, Collection<ICompilerProblem> warnings) {
        CompilerProblemCategorizer categorizer = new CompilerProblemCategorizer(this.problemSettings);
        for (ICompilerProblem problem : this.getFilteredProblemsUsingBaseFilter()) {
            CompilerProblemSeverity severity = categorizer.getProblemSeverity(problem);
            if (severity == CompilerProblemSeverity.ERROR) {
                errors.add(problem);
                continue;
            }
            if (severity != CompilerProblemSeverity.WARNING) continue;
            warnings.add(problem);
        }
    }

    public boolean hasErrors() {
        CompilerProblemCategorizer categorizer = new CompilerProblemCategorizer(this.problemSettings);
        for (ICompilerProblem problem : this.getFilteredProblemsUsingBaseFilter()) {
            CompilerProblemSeverity severity = categorizer.getProblemSeverity(problem);
            if (severity != CompilerProblemSeverity.ERROR) continue;
            return true;
        }
        return false;
    }

    private static int compareStrings(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 != null && s2 != null) {
            return s1.compareTo(s2);
        }
        return s1 == null ? -1 : 1;
    }

    private class ErrorsAndWarningsFilter
    implements IProblemFilter {
        private final CompilerProblemCategorizer categorizer;

        ErrorsAndWarningsFilter(CompilerProblemCategorizer categorizer) {
            this.categorizer = categorizer;
        }

        @Override
        public boolean accept(ICompilerProblem problem) {
            CompilerProblemSeverity severity = this.categorizer.getProblemSeverity(problem);
            return severity == CompilerProblemSeverity.ERROR || severity == CompilerProblemSeverity.WARNING;
        }
    }

    private class SkipSemanticCascadesFilter
    implements IProblemFilter {
        private int lineNumber = -1;
        private String fileName = null;
        private boolean parserProblemOnLine = false;

        private SkipSemanticCascadesFilter() {
        }

        @Override
        public boolean accept(ICompilerProblem problem) {
            if (problem.getLine() != this.lineNumber || ProblemQuery.compareStrings(this.fileName, problem.getSourcePath()) != 0) {
                this.lineNumber = problem.getLine();
                this.fileName = problem.getSourcePath();
            } else if (this.parserProblemOnLine && (problem instanceof AbstractSemanticProblem || problem instanceof CodegenProblem)) {
                return false;
            }
            this.parserProblemOnLine = problem instanceof ParserProblem;
            return true;
        }
    }
}

