/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.clients.problems;

import com.adobe.flash.compiler.clients.problems.IProblemFilter;
import com.adobe.flash.compiler.clients.problems.ProblemFormatter;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;

public final class ProblemPrinter {
    private ProblemFormatter formatter;
    private OutputStream outputStream;
    private String encoding = "";

    public ProblemPrinter(ProblemFormatter formatter, OutputStream outputStream) {
        this.formatter = formatter;
        this.outputStream = outputStream;
    }

    public ProblemPrinter(ProblemFormatter formatter, OutputStream outputStream, String encoding) {
        this.formatter = formatter;
        this.outputStream = outputStream;
        this.encoding = encoding;
    }

    public ProblemPrinter(ProblemFormatter formatter) {
        this(formatter, System.err);
    }

    public int printProblems(Collection<ICompilerProblem> problems, IProblemFilter filter) {
        if (problems == null || problems.isEmpty()) {
            return 0;
        }
        ArrayList<ICompilerProblem> filteredProblems = new ArrayList<ICompilerProblem>();
        for (ICompilerProblem problem : problems) {
            if (filter != null && !filter.accept(problem)) continue;
            filteredProblems.add(problem);
        }
        return this.printProblems(filteredProblems);
    }

    public int printProblems(Iterable<ICompilerProblem> problems) {
        PrintWriter writer;
        int problemCount = 0;
        try {
            writer = new PrintWriter(new OutputStreamWriter(this.outputStream, this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            writer = new PrintWriter(new PrintStream(this.outputStream));
        }
        for (ICompilerProblem problem : problems) {
            writer.println(this.formatter.format(problem));
            ++problemCount;
        }
        writer.flush();
        return problemCount;
    }
}

