/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.clients.problems;

import com.adobe.flash.compiler.Messages;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public class ProblemFormatter {
    public static ProblemFormatter DEFAULT_FORMATTER = new ProblemFormatter();

    public String format(ICompilerProblem problem) {
        Class<?> c = problem.getClass();
        String problemMessage = this.getMessage(c.getSimpleName());
        if (problemMessage == null) {
            try {
                Field descriptionField = c.getDeclaredField("DESCRIPTION");
                problemMessage = (String)descriptionField.get(null);
            }
            catch (Exception e) {
                return '!' + c.getSimpleName() + '!';
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (c != Object.class) {
            for (Field field : c.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
                try {
                    Object value = field.get(problem);
                    if (value == null) continue;
                    map.put(field.getName(), value);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            c = c.getSuperclass();
        }
        return ProblemFormatter.substitute(problemMessage, map);
    }

    public static String substitute(String text, Map<String, Object> parameters) {
        for (String key : parameters.keySet()) {
            String value = parameters.get(key).toString();
            if (value == null) continue;
            value = Matcher.quoteReplacement(value);
            text = text.replaceAll("[$][{]" + key + "[}]", value);
        }
        return text;
    }

    protected String getMessage(String key) {
        return Messages.getString(key);
    }
}

