/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.clients.problems;

import com.adobe.flash.compiler.clients.problems.IProblemFilter;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ProblemFilterClassCriteria
implements IProblemFilter {
    private Set<Class<?>> classesToFilterOut;
    private Set<Class<?>> classesToRequire;

    public ProblemFilterClassCriteria(Class<?> ... classesToFilterOut) {
        this.classesToFilterOut = new HashSet(Arrays.asList(classesToFilterOut));
        this.classesToRequire = new HashSet();
    }

    public ProblemFilterClassCriteria(Set<Class<?>> classesToFilterOut, Set<Class<?>> classesToRequire) {
        this.classesToFilterOut = classesToFilterOut;
        this.classesToRequire = classesToRequire;
    }

    public void addRejectedClass(Class<?> clazz) {
        assert (!this.classesToRequire.contains(clazz));
        this.classesToFilterOut.add(clazz);
    }

    public void removeRejectedClass(Class<?> clazz) {
        this.classesToFilterOut.remove(clazz);
    }

    public void addRequiredClass(Class<?> clazz) {
        assert (!this.classesToFilterOut.contains(clazz));
        this.classesToRequire.add(clazz);
    }

    @Override
    public boolean accept(ICompilerProblem p) {
        for (Class<?> filter : this.classesToFilterOut) {
            if (!filter.isInstance(p)) continue;
            return false;
        }
        for (Class<?> filter : this.classesToRequire) {
            if (filter.isInstance(p)) continue;
            return false;
        }
        return true;
    }
}

