/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.clients;

import com.adobe.flash.compiler.Messages;
import com.adobe.flash.compiler.clients.problems.CompilerProblemCategorizer;
import com.adobe.flash.compiler.clients.problems.ProblemPrinter;
import com.adobe.flash.compiler.clients.problems.ProblemQuery;
import com.adobe.flash.compiler.clients.problems.WorkspaceProblemFormatter;
import com.adobe.flash.compiler.common.VersionInfo;
import com.adobe.flash.compiler.config.CommandLineConfigurator;
import com.adobe.flash.compiler.config.Configuration;
import com.adobe.flash.compiler.config.ConfigurationBuffer;
import com.adobe.flash.compiler.config.ConfigurationPathResolver;
import com.adobe.flash.compiler.config.ConfigurationValue;
import com.adobe.flash.compiler.config.Configurator;
import com.adobe.flash.compiler.config.ICompilerProblemSettings;
import com.adobe.flash.compiler.config.RSLSettings;
import com.adobe.flash.compiler.exceptions.ConfigurationException;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.config.localization.LocalizationManager;
import com.adobe.flash.compiler.internal.graph.GraphMLWriter;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.projects.DefinitionPriority;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.targets.LinkageChecker;
import com.adobe.flash.compiler.internal.targets.SWFTarget;
import com.adobe.flash.compiler.internal.targets.Target;
import com.adobe.flash.compiler.internal.units.ResourceModuleCompilationUnit;
import com.adobe.flash.compiler.internal.units.SourceCompilationUnitFactory;
import com.adobe.flash.compiler.internal.units.StyleModuleCompilationUnit;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.ConfigurationProblem;
import com.adobe.flash.compiler.problems.FileIOProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.InternalCompilerProblem;
import com.adobe.flash.compiler.problems.UnableToBuildSWFProblem;
import com.adobe.flash.compiler.problems.UnsupportedSourceFileProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.targets.ISWFTarget;
import com.adobe.flash.compiler.targets.ITarget;
import com.adobe.flash.compiler.targets.ITargetReport;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IFileNode;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.swc.io.ISWFWriterFactory;
import com.adobe.flash.swf.Header;
import com.adobe.flash.swf.ISWF;
import com.adobe.flash.swf.io.ISWFWriter;
import com.adobe.flash.swf.io.SWFWriterAndSizeReporter;
import com.adobe.flash.utils.FilenameNormalization;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class MXMLC {
    static final String NEWLINE = System.getProperty("line.separator");
    private static final String SWF_EXT = ".swf";
    private static final String DEFAULT_VAR = "file-specs";
    private static final String L10N_CONFIG_PREFIX = "com.adobe.flash.compiler.internal.config.configuration";
    protected Workspace workspace = new Workspace();
    protected FlexProject project = new FlexProject(this.workspace);
    protected Configuration config;
    protected ProblemQuery problems = new ProblemQuery();
    protected ConfigurationBuffer configBuffer;
    protected Configurator projectConfigurator;
    protected ICompilationUnit mainCU;
    protected SWFTarget target;
    protected long startTime;
    protected ITargetSettings targetSettings;
    private ISWF swfTarget;
    private String swfOutputMessage;

    public static void main(String[] args) {
        int exitCode = MXMLC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        MXMLC mxmlc = new MXMLC();
        return mxmlc.mainNoExit(args);
    }

    public static boolean isFatalFailure(int code) {
        return code == ExitCode.FAILED_WITH_ERRORS.getCode() || code == ExitCode.FAILED_WITH_EXCEPTIONS.getCode() || code == ExitCode.FAILED_WITH_CONFIG_ERRORS.getCode();
    }

    public int mainNoExit(String[] args) {
        return this.mainNoExit(args, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mainNoExit(String[] args, OutputStream err) {
        String encoding = MXMLC.getCurrentEncoding();
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, encoding));
            System.setErr(new PrintStream((OutputStream)System.err, true, encoding));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        this.startTime = System.nanoTime();
        ExitCode exitCode = ExitCode.SUCCESS;
        try {
            boolean continueCompilation = this.configure(args);
            boolean legacyOutput = this.config.useLegacyMessageFormat();
            CompilerProblemCategorizer categorizer = null;
            if (legacyOutput) {
                categorizer = this.createProblemCategorizer();
            }
            WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(this.workspace, categorizer);
            ProblemPrinter printer = new ProblemPrinter(formatter, err, encoding);
            if (continueCompilation) {
                this.compile();
                exitCode = this.printProblems(printer, legacyOutput);
                this.reportTargetCompletion();
            } else if (this.problems.hasFilteredProblems()) {
                printer.printProblems(this.problems.getFilteredProblems());
                exitCode = ExitCode.FAILED_WITH_CONFIG_ERRORS;
            } else {
                exitCode = ExitCode.PRINT_HELP;
            }
        }
        catch (Exception e) {
            new PrintStream(err).println(e.getMessage());
            exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
        }
        finally {
            this.waitAndClose();
        }
        return exitCode.code;
    }

    private ExitCode printProblems(ProblemPrinter printer, boolean legacyOutput) {
        ExitCode exitCode = ExitCode.SUCCESS;
        if (legacyOutput) {
            if (printer.printProblems(this.problems.getFilteredProblems()) > 0 && this.problems.hasErrors()) {
                exitCode = ExitCode.FAILED_WITH_ERRORS;
            }
        } else {
            ArrayList<ICompilerProblem> errors = new ArrayList<ICompilerProblem>();
            ArrayList<ICompilerProblem> warnings = new ArrayList<ICompilerProblem>();
            this.problems.getErrorsAndWarnings(errors, warnings);
            int errorCount = errors.size();
            int warningCount = warnings.size();
            if (warningCount > 0) {
                System.err.println(Messages.getString("MXMLC.WarningsHeader"));
                printer.printProblems(warnings);
            }
            if (errorCount > 0) {
                System.err.println(Messages.getString("MXMLC.ErrorsHeader"));
                printer.printProblems(errors);
            }
            if (errorCount == 1) {
                System.err.println(Messages.getString("MXMLC.1_error"));
            } else if (errorCount > 0) {
                System.err.println(Messages.getString("MXMLC.multiple_errors_format", Collections.singletonMap("errorCount", errors.size())));
            }
            if (warningCount == 1) {
                System.err.println(Messages.getString("MXMLC.1_warning"));
            } else if (warningCount > 0) {
                System.err.println(Messages.getString("MXMLC.multiple_warnings_format", Collections.singletonMap("warningCount", warnings.size())));
            }
            if (errorCount > 0) {
                exitCode = ExitCode.FAILED_WITH_ERRORS;
            }
        }
        return exitCode;
    }

    public void println(String msg) {
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitAndClose() {
        this.workspace.startIdleState();
        try {
            this.workspace.close();
        }
        finally {
            this.workspace.endIdleState(Collections.<ICompilerProject, Set<ICompilationUnit>>emptyMap());
        }
    }

    protected void close() {
        this.workspace.close();
    }

    protected Configurator createConfigurator() {
        return new Configurator();
    }

    protected boolean configure(String[] args) {
        this.projectConfigurator = this.createConfigurator();
        try {
            if (args.length == 0) {
                String usage = CommandLineConfigurator.brief(this.getProgramName(), DEFAULT_VAR, LocalizationManager.get(), L10N_CONFIG_PREFIX);
                this.println(this.getStartMessage());
                if (usage != null) {
                    this.println(usage);
                }
                this.config = new Configuration();
                this.configBuffer = new ConfigurationBuffer(Configuration.class, Configuration.getAliases());
                return false;
            }
            ConfigurationPathResolver resolver = new ConfigurationPathResolver(System.getProperty("user.dir"));
            this.projectConfigurator.setConfigurationPathResolver(resolver);
            this.projectConfigurator.setWarnOnFlexOnlyOptionUsage(true);
            this.projectConfigurator.setConfiguration(args, this.getConfigurationDefaultVariable());
            this.projectConfigurator.applyToProject(this.project);
            this.getTargetSettings();
            this.problems = new ProblemQuery(this.projectConfigurator.getCompilerProblemSettings());
            this.config = this.projectConfigurator.getConfiguration();
            Messages.setLocale(this.config.getToolsLocale());
            this.configBuffer = this.projectConfigurator.getConfigurationBuffer();
            this.problems.addAll(this.projectConfigurator.getConfigurationProblems());
            if (this.configBuffer.getVar("version") != null) {
                this.println(VersionInfo.buildMessage());
                return false;
            }
            List<ConfigurationValue> helpVar = this.configBuffer.getVar("help");
            if (helpVar != null) {
                this.processHelp(helpVar);
                return false;
            }
            for (String fileName : this.projectConfigurator.getLoadedConfigurationFiles()) {
                this.println(Messages.getString("MXMLC.Loading_configuration_format", Collections.singletonMap("configurationName", fileName)));
            }
            this.println("");
            if (this.config.isVerbose()) {
                for (IFileSpecification themeFile : this.project.getThemeFiles()) {
                    this.println(Messages.getString("MXMLC.Found_theme_file_format", Collections.singletonMap("themePath", themeFile.getPath())));
                }
            }
            if (this.problems.hasErrors()) {
                return false;
            }
            this.validateTargetFile();
            return true;
        }
        catch (ConfigurationException e) {
            ConfigurationProblem problem = new ConfigurationProblem(e);
            this.problems.add(problem);
            return false;
        }
        catch (Exception e) {
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            this.problems.add(problem);
            return false;
        }
    }

    protected String getConfigurationDefaultVariable() {
        return DEFAULT_VAR;
    }

    protected void validateTargetFile() throws ConfigurationException {
        if (this.mainCU instanceof ResourceModuleCompilationUnit) {
            return;
        }
        String targetFile = this.config.getTargetFile();
        if (targetFile == null) {
            throw new ConfigurationException.MustSpecifyTarget(null, null, -1);
        }
        File file = new File(targetFile);
        if (!file.exists()) {
            throw new ConfigurationException.IOError(targetFile);
        }
    }

    protected boolean compile() {
        boolean compilationSuccess = false;
        try {
            if (!this.setupTargetFile()) {
                return false;
            }
            if (this.config.isDumpAst()) {
                this.dumpAST();
            }
            this.buildArtifact();
            if (this.swfTarget == null) {
                return false;
            }
            if (!this.config.getCreateTargetWithErrors() && this.problems.hasErrors()) {
                return false;
            }
            File outputFile = new File(this.getOutputFilePath());
            int swfSize = this.writeSWF(this.swfTarget, outputFile);
            long endTime = System.nanoTime();
            String seconds = String.format("%5.3f", (double)(endTime - this.startTime) / 1.0E9);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("byteCount", swfSize);
            params.put("path", outputFile.getCanonicalPath());
            params.put("seconds", seconds);
            this.swfOutputMessage = Messages.getString("MXMLC.bytes_written_to_file_in_seconds_format", params);
            this.dumpDependencyGraphIfNeeded();
            compilationSuccess = true;
        }
        catch (IOException e) {
            FileIOProblem problem = new FileIOProblem(e);
            this.problems.add(problem);
        }
        catch (Exception e) {
            InternalCompilerProblem problem = new InternalCompilerProblem(e);
            this.problems.add(problem);
        }
        return compilationSuccess;
    }

    protected void setupThemeFiles() {
        this.project.setThemeFiles(MXMLC.toFileSpecifications(this.config.getCompilerThemeFiles(), this.workspace));
        if (this.config.isVerbose()) {
            for (IFileSpecification themeFile : this.project.getThemeFiles()) {
                this.verboseMessage(Messages.getString("MXMLC.Found_theme_file_format", Collections.singletonMap("themePath", themeFile.getPath())));
            }
        }
    }

    protected void reportTargetCompletion() throws InterruptedException {
        if (this.swfOutputMessage != null) {
            this.reportRequiredRSLs(this.target);
            this.println(this.swfOutputMessage);
        }
    }

    private CompilerProblemCategorizer createProblemCategorizer() {
        ICompilerProblemSettings problemSettings = null;
        try {
            problemSettings = this.projectConfigurator.getCompilerProblemSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new CompilerProblemCategorizer(problemSettings);
    }

    private void dumpAST() throws InterruptedException {
        ArrayList<String> astDump = new ArrayList<String>();
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        ImmutableList<ICompilationUnit> compilationUnits = this.target.getReachableCompilationUnits(problems);
        for (ICompilationUnit compilationUnit : compilationUnits) {
            IASNode ast = compilationUnit.getSyntaxTreeRequest().get().getAST();
            if (ast == null) continue;
            ((IFileNode)ast).populateFunctionNodes();
            astDump.add(ast.toString());
        }
        this.println(Joiner.on((String)"\n\n").join(astDump));
    }

    protected void buildArtifact() throws InterruptedException, IOException {
        this.swfTarget = this.buildSWFModel();
    }

    private ISWF buildSWFModel() throws InterruptedException {
        ArrayList<ICompilerProblem> problemsBuildingSWF = new ArrayList<ICompilerProblem>();
        ISWF swf = this.target.build(problemsBuildingSWF);
        this.problems.addAll(problemsBuildingSWF);
        if (swf == null) {
            UnableToBuildSWFProblem problem = new UnableToBuildSWFProblem(this.getOutputFilePath());
            this.problems.add(problem);
        }
        return swf;
    }

    private void reportRequiredRSLs(ISWFTarget target) throws InterruptedException {
        if (this.hasRSLs()) {
            ITargetReport report = target.getTargetReport();
            if (report == null) {
                return;
            }
            List<RSLSettings> requiredRSLs = report.getRequiredRSLs();
            List<String> legacyRSLs = this.targetSettings.getRuntimeSharedLibraries();
            if (requiredRSLs.isEmpty() && legacyRSLs.isEmpty()) {
                return;
            }
            this.println(Messages.getString("MXMLC.Required_RSLs"));
            block5: for (RSLSettings rslSettings : requiredRSLs) {
                List<RSLSettings.RSLAndPolicyFileURLPair> rslURLs = rslSettings.getRSLURLs();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("rslPath", rslURLs.get(0).getRSLURL());
                switch (rslURLs.size()) {
                    case 0: {
                        assert (false);
                        continue block5;
                    }
                    case 1: {
                        this.println(Messages.getString("MXMLC.required_rsl_url_format", params));
                        continue block5;
                    }
                    case 2: {
                        this.println(Messages.getString("MXMLC.required_rsl_url_with_1_failover_format", params));
                        continue block5;
                    }
                }
                params.put("failoverCount", rslURLs.size() - 1);
                this.println(Messages.getString("MXMLC.required_rsl_url_with_multiple_failovers_format", params));
            }
            for (String rslURL : legacyRSLs) {
                this.println(Messages.getString("MXMLC.required_rsl_url_format", Collections.singletonMap("rslPath", rslURL)));
            }
        }
    }

    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWF;
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(this.getTargetType());
        }
        return this.targetSettings;
    }

    private boolean hasRSLs() {
        return this.getTargetSettings().getRuntimeSharedLibraryPath().size() > 0 || this.getTargetSettings().getRuntimeSharedLibraryPath().size() > 0;
    }

    private int writeSWF(ISWF swf, File outputFile) throws IOException {
        boolean useCompression = this.targetSettings.useCompression();
        if (this.config.getMobile()) {
            boolean setCompress;
            boolean bl = setCompress = this.configBuffer.getVar("compiler.compress") != null;
            if (!setCompress) {
                useCompression = false;
            }
        }
        Header.Compression compression = Header.decideCompression(useCompression, this.targetSettings.getSWFVersion(), this.targetSettings.isDebugEnabled());
        ISWFWriterFactory writerFactory = SWFWriterAndSizeReporter.getSWFWriterFactory(this.targetSettings.getSizeReport());
        ISWFWriter writer = writerFactory.createSWFWriter(swf, compression, this.targetSettings.isDebugEnabled());
        return writer.writeTo(outputFile);
    }

    protected boolean setupTargetFile() throws InterruptedException {
        String mainFileName = this.config.getTargetFile();
        if (mainFileName != null) {
            String normalizedMainFileName = FilenameNormalization.normalize(mainFileName);
            File normalizedMainFile = new File(normalizedMainFileName);
            if (mainFileName.toLowerCase().endsWith(".css")) {
                if (!this.project.isFlex()) {
                    this.problems.add(new UnsupportedSourceFileProblem(normalizedMainFile));
                    return false;
                }
                this.mainCU = new StyleModuleCompilationUnit(this.project, this.workspace.getFileSpecification(normalizedMainFileName), DefinitionPriority.BasePriority.SOURCE_LIST);
                this.config.setMainDefinition("CSSModule2Main");
                this.project.addCompilationUnitsAndUpdateDefinitions(Collections.singleton(this.mainCU));
            } else {
                SourceCompilationUnitFactory compilationUnitFactory = this.project.getSourceCompilationUnitFactory();
                if (!compilationUnitFactory.canCreateCompilationUnit(normalizedMainFile)) {
                    this.problems.add(new UnsupportedSourceFileProblem(normalizedMainFile));
                    return false;
                }
                this.project.removeSourceFile(normalizedMainFile);
                this.project.addIncludeSourceFile(normalizedMainFile, true);
                Collection<ICompilationUnit> mainFileCompilationUnits = this.workspace.getCompilationUnits(normalizedMainFileName, this.project);
                assert (mainFileCompilationUnits.size() == 1);
                this.mainCU = (ICompilationUnit)Iterables.getOnlyElement(mainFileCompilationUnits);
            }
        } else {
            ArrayList<ICompilerProblem> resourceBundleProblems = new ArrayList<ICompilerProblem>();
            Collection<ICompilationUnit> includedResourceBundles = this.target.getIncludedResourceBundlesCompilationUnits(resourceBundleProblems);
            this.problems.addAll(resourceBundleProblems);
            if (includedResourceBundles.size() > 0) {
                if (!this.project.isFlex()) {
                    ICompilationUnit unit = includedResourceBundles.iterator().next();
                    this.problems.add(new UnsupportedSourceFileProblem(new File(unit.getAbsoluteFilename())));
                    return false;
                }
                this.mainCU = new ResourceModuleCompilationUnit((CompilerProject)this.project, "GeneratedResourceModule", includedResourceBundles, DefinitionPriority.BasePriority.SOURCE_LIST);
                this.config.setMainDefinition("GeneratedResourceModule");
                this.project.addCompilationUnitsAndUpdateDefinitions(Collections.singleton(this.mainCU));
            }
        }
        Preconditions.checkNotNull((Object)this.mainCU, (Object)"Main compilation unit can't be null");
        if (this.getTargetSettings() == null) {
            return false;
        }
        this.target = (SWFTarget)this.project.createSWFTarget(this.getTargetSettings(), null);
        return true;
    }

    protected void setupLocaleSettings() {
        this.project.setLocales(this.config.getCompilerLocales());
        this.project.setLocaleDependentResources(this.config.getLocaleDependentSources());
    }

    private String getOutputFilePath() {
        if (this.config.getOutput() == null) {
            return FilenameUtils.removeExtension((String)this.config.getTargetFile()).concat(SWF_EXT);
        }
        return this.config.getOutput();
    }

    private void verboseMessage(String s) {
        if (this.config.isVerbose()) {
            this.println(s);
        }
    }

    public static List<File> toFiles(List<String> paths) {
        ArrayList<File> result = new ArrayList<File>();
        for (String path : paths) {
            if (path == null) continue;
            result.add(new File(path));
        }
        return result;
    }

    public static List<IFileSpecification> toFileSpecifications(List<String> paths, final Workspace workspace) {
        return Lists.transform(paths, (Function)new Function<String, IFileSpecification>(){

            public IFileSpecification apply(String path) {
                return workspace.getFileSpecification(path);
            }
        });
    }

    protected String getProgramName() {
        return "mxmlc";
    }

    protected String getStartMessage() {
        String message = "Adobe ActionScript Compiler (mxmlc)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE + "Copyright 2004-2012 Adobe Systems Incorporated. All rights reserved." + NEWLINE;
        return message;
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        for (ConfigurationValue val : helpVar) {
            Iterator<String> i$ = val.getArgs().iterator();
            while (i$.hasNext()) {
                String element;
                String keyword = element = i$.next();
                while (keyword.startsWith("-")) {
                    keyword = keyword.substring(1);
                }
                keywords.add(keyword);
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage(this.getProgramName(), DEFAULT_VAR, this.configBuffer, keywords, LocalizationManager.get(), L10N_CONFIG_PREFIX);
        this.println(this.getStartMessage());
        this.println(usages);
    }

    protected boolean isCompc() {
        return false;
    }

    private void dumpDependencyGraphIfNeeded() throws IOException, InterruptedException {
        File dependencyGraphOutput = this.config.getDependencyGraphOutput();
        if (dependencyGraphOutput != null) {
            LinkageChecker linkageChecker = new LinkageChecker(this.project, this.getTargetSettings());
            Target.RootedCompilationUnits rootedCompilationUnits = this.target.getRootedCompilationUnits();
            this.problems.addAll(rootedCompilationUnits.getProblems());
            GraphMLWriter dependencyGraphWriter = new GraphMLWriter(this.project.getDependencyGraph(), rootedCompilationUnits.getUnits(), true, linkageChecker);
            BufferedOutputStream graphStream = new BufferedOutputStream(new FileOutputStream(dependencyGraphOutput));
            LinkedList<ICompilerProblem> problemList = new LinkedList<ICompilerProblem>();
            Iterables.addAll(problemList, rootedCompilationUnits.getProblems());
            dependencyGraphWriter.writeToStream(graphStream, problemList);
            this.problems.addAll(problemList);
        }
    }

    public ProblemQuery getProblems() {
        return this.problems;
    }

    private static String getConsoleEncoding() {
        String encoding = null;
        try {
            Class<?> consoleClass = Class.forName("java.io.Console");
            Method encodingMethod = consoleClass.getDeclaredMethod("encoding", new Class[0]);
            encodingMethod.setAccessible(true);
            encoding = (String)encodingMethod.invoke(consoleClass, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encoding;
    }

    private static String getCurrentEncoding() {
        String consoleEncoding = MXMLC.getConsoleEncoding();
        String encoding = "";
        if (consoleEncoding != null) {
            encoding = consoleEncoding;
        } else {
            String langEnvVar = System.getenv("LANG");
            if (langEnvVar != null) {
                encoding = langEnvVar.substring(langEnvVar.lastIndexOf(".") + 1);
            }
        }
        return encoding;
    }

    public static final class ExitCode
    extends Enum<ExitCode> {
        public static final /* enum */ ExitCode SUCCESS = new ExitCode(0);
        public static final /* enum */ ExitCode PRINT_HELP = new ExitCode(1);
        public static final /* enum */ ExitCode FAILED_WITH_ERRORS = new ExitCode(2);
        public static final /* enum */ ExitCode FAILED_WITH_EXCEPTIONS = new ExitCode(3);
        public static final /* enum */ ExitCode FAILED_WITH_CONFIG_ERRORS = new ExitCode(4);
        final int code;
        private static final /* synthetic */ ExitCode[] $VALUES;

        public static ExitCode[] values() {
            return (ExitCode[])$VALUES.clone();
        }

        public static ExitCode valueOf(String name) {
            return Enum.valueOf(ExitCode.class, name);
        }

        private ExitCode(int code) {
            assert (code >= 0) : "Exit code must be non-negative";
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        static {
            $VALUES = new ExitCode[]{SUCCESS, PRINT_HELP, FAILED_WITH_ERRORS, FAILED_WITH_EXCEPTIONS, FAILED_WITH_CONFIG_ERRORS};
        }
    }
}

