/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.clients;

import com.adobe.flash.compiler.Messages;
import com.adobe.flash.compiler.clients.MXMLC;
import com.adobe.flash.compiler.common.VersionInfo;
import com.adobe.flash.compiler.config.Configurator;
import com.adobe.flash.compiler.exceptions.ConfigurationException;
import com.adobe.flash.compiler.internal.config.COMPCConfiguration;
import com.adobe.flash.compiler.internal.targets.SWFTarget;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MissingRequirementConfigurationProblem;
import com.adobe.flash.compiler.targets.ISWCTarget;
import com.adobe.flash.compiler.targets.ITarget;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.io.SWCDirectoryWriter;
import com.adobe.flash.swc.io.SWCWriter;
import com.adobe.flash.swf.io.SWFWriterAndSizeReporter;
import com.adobe.flash.utils.FilenameNormalization;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class COMPC
extends MXMLC {
    private String swcOutputMessage;

    public static void main(String[] args) {
        int exitCode = COMPC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        COMPC compc = new COMPC();
        return compc.mainNoExit(args);
    }

    @Override
    protected boolean configure(String[] args) {
        return super.configure(args);
    }

    @Override
    protected String getConfigurationDefaultVariable() {
        return "include-classes";
    }

    @Override
    protected Configurator createConfigurator() {
        return new Configurator(COMPCConfiguration.class);
    }

    @Override
    protected String getProgramName() {
        return "compc";
    }

    @Override
    protected String getStartMessage() {
        String message = "Adobe SWC Component Compiler (compc)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE + "Copyright 2004-2012 Adobe Systems Incorporated. All rights reserved." + NEWLINE;
        return message;
    }

    @Override
    protected void buildArtifact() throws InterruptedException, IOException {
        String outputOptionValue = this.config.getOutput();
        if (outputOptionValue == null || outputOptionValue.length() == 0) {
            MissingRequirementConfigurationProblem problem = new MissingRequirementConfigurationProblem("output");
            this.problems.add(problem);
            return;
        }
        ITargetSettings targetSettings = this.projectConfigurator.getTargetSettings(ITarget.TargetType.SWC);
        if (targetSettings == null) {
            return;
        }
        ISWCTarget swcTarget = this.project.createSWCTarget(targetSettings, null);
        this.target = (SWFTarget)swcTarget.getLibrarySWFTarget();
        ArrayList<ICompilerProblem> swcProblems = new ArrayList<ICompilerProblem>();
        ISWC swc = swcTarget.build(swcProblems);
        this.problems.addAll(swcProblems);
        if (!this.config.getCreateTargetWithErrors() && this.problems.hasErrors()) {
            return;
        }
        boolean useCompression = targetSettings.useCompression();
        if (this.config.getOutputSwcAsDirectory()) {
            String path = FilenameNormalization.normalize(outputOptionValue);
            SWCDirectoryWriter swcWriter = new SWCDirectoryWriter(path, useCompression, targetSettings.isDebugEnabled(), SWFWriterAndSizeReporter.getSWFWriterFactory(targetSettings.getSizeReport()));
            swcWriter.write(swc);
            long endTime = System.nanoTime();
            String seconds = String.format("%5.3f", (double)(endTime - this.startTime) / 1.0E9);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("path", path);
            params.put("seconds", seconds);
            this.swcOutputMessage = Messages.getString("COMPC.swc_written_open_directory_in_seconds_format", params);
        } else {
            SWCWriter swcWriter = new SWCWriter(outputOptionValue, useCompression, targetSettings.isDebugEnabled(), SWFWriterAndSizeReporter.getSWFWriterFactory(targetSettings.getSizeReport()));
            swcWriter.write(swc);
            File outputFile = new File(outputOptionValue);
            long endTime = System.nanoTime();
            String seconds = String.format("%5.3f", (double)(endTime - this.startTime) / 1.0E9);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("byteCount", outputFile.length());
            params.put("path", outputFile.getCanonicalPath());
            params.put("seconds", seconds);
            this.swcOutputMessage = Messages.getString("MXMLC.bytes_written_to_file_in_seconds_format", params);
        }
    }

    @Override
    protected void reportTargetCompletion() {
        if (this.swcOutputMessage != null) {
            this.println(this.swcOutputMessage);
        }
    }

    @Override
    protected boolean setupTargetFile() throws InterruptedException {
        return true;
    }

    @Override
    protected void validateTargetFile() throws ConfigurationException {
    }

    @Override
    protected boolean isCompc() {
        return true;
    }

    @Override
    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }
}

