/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.abc.semantics;

import com.adobe.flash.abc.semantics.Metadata;
import com.adobe.flash.abc.semantics.Name;
import java.util.HashMap;
import java.util.Vector;

public class Trait {
    public static final String TRAIT_CLASS = "class_id";
    public static final String TRAIT_DISP = "disp_id";
    public static final String TRAIT_FINAL = "final";
    public static final String TRAIT_METHOD = "method_id";
    public static final String TRAIT_NAME = "name";
    public static final String TRAIT_OVERRIDE = "override";
    public static final String TRAIT_PUBLIC = "public";
    public static final String TRAIT_SLOT = "slot_id";
    public static final String TRAIT_TYPE = "type";
    public static final String SLOT_VALUE = "value";
    private byte kind_byte;
    private final Name name;
    HashMap<String, Object> attrs = new HashMap();
    private Vector<Metadata> metaData;
    private static final Vector<Metadata> emptyMetadata = new Vector();

    public Trait(int kind, Name name) {
        this.kind_byte = (byte)(kind & 0xF);
        this.name = name;
        this.addAttr(TRAIT_NAME, name);
    }

    public void addAttr(String key, Object value) {
        if (this.attrs.containsKey(key)) {
            throw new IllegalArgumentException("Trait attribute " + key + " cannot be specified twice.");
        }
        this.attrs.put(key, value);
    }

    public byte getKind() {
        return (byte)(this.kind_byte & 0xF);
    }

    public byte getFullKindByte() {
        int result = this.getKind();
        if (this.hasAttr(TRAIT_FINAL) && this.getBooleanAttr(TRAIT_FINAL)) {
            result |= 0x10;
        }
        if (this.hasAttr(TRAIT_OVERRIDE) && this.getBooleanAttr(TRAIT_OVERRIDE)) {
            result |= 0x20;
        }
        if (this.hasMetadata()) {
            result |= 0x40;
        }
        return (byte)result;
    }

    public Name getName() {
        return this.name;
    }

    public void setAttr(String attr_name, Object attr_value) {
        this.attrs.put(attr_name, attr_value);
    }

    public boolean hasAttr(String attr_name) {
        return this.attrs.containsKey(attr_name);
    }

    public Object getAttr(String attr_name) {
        this.verifyContains(attr_name, null);
        return this.attrs.get(attr_name);
    }

    public int getIntAttr(String attr_name) {
        this.verifyContains(attr_name, Integer.class);
        return (Integer)this.attrs.get(attr_name);
    }

    public Name getNameAttr(String attr_name) {
        this.verifyContains(attr_name, Name.class);
        return (Name)this.attrs.get(attr_name);
    }

    public boolean getBooleanAttr(String attr_name) {
        this.verifyContains(attr_name, Boolean.class);
        return (Boolean)this.attrs.get(attr_name);
    }

    void verifyContains(String attr_name, Class<? extends Object> clazz) {
        if (!this.attrs.containsKey(attr_name)) {
            throw new IllegalArgumentException("Required attribute " + attr_name + " not found.");
        }
        if (null != clazz && null != this.attrs.get(attr_name) && !this.attrs.get(attr_name).getClass().equals(clazz)) {
            throw new IllegalArgumentException("Attribute " + attr_name + " must be type " + clazz.getSimpleName());
        }
    }

    public void setKind(int kind_byte) {
        this.kind_byte = (byte)(kind_byte & 0xF);
    }

    public boolean isFinal() {
        return (this.kind_byte >> 4 & 1) != 0;
    }

    public boolean isOverride() {
        return (this.kind_byte >> 4 & 2) != 0;
    }

    public boolean hasMetadata() {
        return this.metaData != null;
    }

    public boolean isConst() {
        return this.getKind() == 6 || this.getKind() == 2;
    }

    public boolean isClass() {
        return this.getKind() == 4;
    }

    public boolean isMethod() {
        return this.getKind() == 1;
    }

    public boolean isGetter() {
        return this.getKind() == 2;
    }

    public boolean isSetter() {
        return this.getKind() == 3;
    }

    public boolean isSlot() {
        byte tk = this.getKind();
        return tk == 0 || tk == 6 || tk == 4;
    }

    public void addMetadata(Metadata md) {
        if (null == this.metaData) {
            this.metaData = new Vector();
        }
        this.metaData.add(md);
    }

    public final Vector<Metadata> getMetadata() {
        if (this.metaData != null) {
            return this.metaData;
        }
        return emptyMetadata;
    }
}

