/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.abc.semantics;

import com.adobe.flash.abc.ABCConstants;
import com.adobe.flash.abc.semantics.Float4;
import com.adobe.flash.abc.semantics.Namespace;

public class PooledValue {
    private int kind;
    private int poolIndex = -1;
    private final Object value;

    public PooledValue(Object value) {
        if (value instanceof Integer) {
            this.kind = 3;
        } else if (value instanceof Long) {
            this.kind = 4;
        } else if (value instanceof Double) {
            this.kind = 6;
        } else if (value instanceof Float) {
            this.kind = 2;
        } else if (value instanceof Float4) {
            this.kind = 30;
        } else if (value instanceof String) {
            this.kind = 1;
        } else if (Boolean.TRUE.equals(value)) {
            this.kind = 11;
        } else if (Boolean.FALSE.equals(value)) {
            this.kind = 10;
        } else if (ABCConstants.UNDEFINED_VALUE == value) {
            this.kind = 0;
        } else if (value == ABCConstants.NULL_VALUE) {
            this.kind = 12;
        } else if (value instanceof Namespace) {
            this.kind = ((Namespace)value).getKind();
        } else {
            throw new IllegalArgumentException("Unknown value class " + value == null ? "null" : value.getClass().toString());
        }
        this.value = value;
    }

    public PooledValue(int kind, Object value) {
        this.kind = kind;
        this.value = value;
    }

    public void setPoolIndex(int index) {
        assert (this.poolIndex == -1);
        this.poolIndex = index;
    }

    public int getPoolIndex() {
        assert (this.poolIndex != -1);
        return this.poolIndex;
    }

    public int getKind() {
        return this.kind;
    }

    public Object getValue() {
        return this.value;
    }

    public Integer getIntegerValue() {
        return (Integer)this.value;
    }

    public Long getLongValue() {
        return (Long)this.value;
    }

    public Double getDoubleValue() {
        return (Double)this.value;
    }

    public String getStringValue() {
        return (String)this.value;
    }

    public Namespace getNamespaceValue() {
        return (Namespace)this.value;
    }

    public Float getFloatValue() {
        return (Float)this.value;
    }

    public Float4 getFloat4Value() {
        return (Float4)this.value;
    }
}

