/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.abc.semantics;

import com.adobe.flash.abc.semantics.Instruction;

public class ImmediateOperandInstruction
extends Instruction {
    public static final boolean allowAnyDeferredIntermediate = false;
    private int immediate;

    public ImmediateOperandInstruction(int opcode, int immediate) {
        super(opcode);
        this.immediate = immediate;
    }

    public ImmediateOperandInstruction(int opcode) {
        super(opcode);
        this.verifyDeferredImmediate("%s requires an immediate operand.");
    }

    @Override
    public String toString() {
        return String.format("%s(%d)", super.toString(), this.immediate);
    }

    @Override
    public int getImmediate() {
        return this.immediate;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public void setImmediate(int immediate) {
        this.verifyDeferredImmediate("Cannot set immediate field on %s");
        this.immediate = immediate;
    }

    private void verifyDeferredImmediate(String diagnostic) {
        switch (this.opcode) {
            case 8: 
            case 31: 
            case 98: 
            case 99: 
            case 146: 
            case 148: 
            case 194: 
            case 195: {
                break;
            }
            default: {
                assert (false) : String.format(diagnostic, this.toString());
                break;
            }
        }
    }
}

